/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.conjure.utils;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.math.DoubleMath;
import com.google.common.net.MediaType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.aksw.commons.collections.collectors.CollectorUtils;
import org.aksw.jena_sparql_api.conjure.utils.HttpHeaderUtils;
import org.aksw.jena_sparql_api.conjure.utils.MapPair;
import org.aksw.jena_sparql_api.http.domain.api.RdfEntityInfo;
import org.apache.http.Header;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeader;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;

public class ContentTypeUtils {
    protected static MapPair<String, String> ctExtensions = new MapPair();
    protected static MapPair<String, String> codingExtensions = new MapPair();

    public static Set<MediaType> compatibleContentTypes(MediaType range, Collection<MediaType> candidates) {
        Set<MediaType> result = candidates.stream().filter(arg_0 -> ((MediaType)range).is(arg_0)).collect(Collectors.toSet());
        return result;
    }

    public static String entryToHeaderValue(Map.Entry<String, Float> e) {
        Float weight = e.getValue();
        boolean isOne = weight == null || DoubleMath.fuzzyEquals((double)1.0, (double)weight.floatValue(), (double)0.001);
        String result = e.getKey() + (String)(isOne ? "" : ";q=" + weight);
        return result;
    }

    public static int classifyLang(Lang lang) {
        int result = RDFLanguages.isTriples((Lang)lang) ? 3 : (RDFLanguages.isQuads((Lang)lang) ? 4 : -1);
        return result;
    }

    public static Header[] expandAccept(Header[] headers) {
        Map ranges = (Map)HttpHeaderUtils.getOrderedValues(headers, "Accept").entrySet().stream().collect(CollectorUtils.toLinkedHashMap(e -> MediaType.parse((String)((String)e.getKey())), Map.Entry::getValue));
        LinkedHashMap<MediaType, Float> expansions = new LinkedHashMap<MediaType, Float>();
        List<MediaType> supportedMediaTypes = HttpHeaderUtils.supportedMediaTypes();
        for (Map.Entry rangeEntry : ranges.entrySet()) {
            MediaType range = (MediaType)rangeEntry.getKey();
            Float weight = (Float)rangeEntry.getValue();
            Set<MediaType> compatibles = ContentTypeUtils.compatibleContentTypes(range, supportedMediaTypes);
            for (MediaType mediaType : compatibles) {
                Lang lang = RDFLanguages.nameToLang((String)mediaType.toString());
                if (lang == null) continue;
                int langClass = ContentTypeUtils.classifyLang(lang);
                List expansionLangs = RDFLanguages.getRegisteredLanguages().stream().filter(l -> ContentTypeUtils.classifyLang(l) == langClass).collect(Collectors.toList());
                Collection langCts = expansionLangs.stream().flatMap(l -> HttpHeaderUtils.langToMediaTypes(l).stream()).collect(Collectors.toList());
                Collection newCts = langCts.stream().filter(mt -> ranges.keySet().stream().noneMatch(r -> mt.is(r))).collect(Collectors.toList());
                for (MediaType newCt : newCts) {
                    expansions.put(newCt, weight);
                }
            }
        }
        Map sortedExp = (Map)expansions.entrySet().stream().sorted((a, b) -> ((Float)a.getValue()).compareTo((Float)b.getValue())).collect(CollectorUtils.toLinkedHashMap(Map.Entry::getKey, Map.Entry::getValue));
        String expansionStr = sortedExp.entrySet().stream().map(e -> Maps.immutableEntry((Object)((MediaType)e.getKey()).toString(), (Object)((Float)e.getValue()))).map(ContentTypeUtils::entryToHeaderValue).collect(Collectors.joining(","));
        Header[] tmp = new Header[headers.length + 1];
        System.arraycopy(headers, 0, tmp, 0, headers.length);
        tmp[headers.length] = new BasicHeader("Accept", expansionStr);
        Header[] result = HttpHeaderUtils.mergeHeaders(tmp, "Accept");
        return result;
    }

    public static MapPair<String, String> getCtExtensions() {
        return ctExtensions;
    }

    public static MapPair<String, String> getCodingExtensions() {
        return codingExtensions;
    }

    public static String toFileExtension(Header[] headers) {
        String result = ContentTypeUtils.toFileExtensionCt(headers) + ContentTypeUtils.toFileExtension(HttpHeaderUtils.getValues(headers, "Content-Encoding"));
        return result;
    }

    public static String toFileExtensionCt(Header[] headers) {
        MimeType mimeType;
        String ct = HttpHeaderUtils.getValue(headers, "Content-Type");
        MimeTypes allTypes = MimeTypes.getDefaultMimeTypes();
        try {
            mimeType = allTypes.forName(ct);
        }
        catch (MimeTypeException e) {
            throw new RuntimeException(e);
        }
        String result = mimeType.getExtension();
        Objects.requireNonNull(result, "Could not find file extension for content type: " + ct + " ; got: " + String.valueOf(ctExtensions.getPrimary()));
        return result;
    }

    public static List<String> toFileExtensionParts(List<String> codings) {
        ArrayList<String> parts = new ArrayList<String>(codings.size());
        for (String coding : codings) {
            String part = Objects.requireNonNull(codingExtensions.getPrimary().get(coding));
            parts.add(part);
        }
        return parts;
    }

    public static String toFileExtension(List<String> codings) {
        List<String> parts = ContentTypeUtils.toFileExtensionParts(codings);
        Object result = parts.stream().collect(Collectors.joining("."));
        result = ((String)result).isEmpty() ? result : "." + (String)result;
        return result;
    }

    public static String toFileExtension(RdfEntityInfo info) {
        Header[] headers = HttpHeaderUtils.toHeaders(info);
        String result = ContentTypeUtils.toFileExtension(headers);
        return result;
    }

    public static String toFileExtension(String contentType, boolean precedeWithDotIfNotEmpty) {
        String result = Objects.requireNonNull(ctExtensions.getPrimary().get(contentType));
        result = precedeWithDotIfNotEmpty && !result.isEmpty() ? "." + result : result;
        return result;
    }

    public static String toFileExtension(String contentType, List<String> codings) {
        ArrayList<String> parts = new ArrayList<String>(1 + codings.size());
        String part = Objects.requireNonNull(ctExtensions.getPrimary().get(contentType));
        parts.add(part);
        for (String coding : codings) {
            part = Objects.requireNonNull(codingExtensions.getPrimary().get(coding));
            parts.add(part);
        }
        String result = parts.stream().collect(Collectors.joining("."));
        return result;
    }

    public static RdfEntityInfo deriveHeadersFromFileName(String fileName) {
        List<String> parts = Arrays.asList(fileName.split("\\."));
        Collections.reverse(parts);
        String contentType = null;
        ArrayList<String> codings = new ArrayList<String>();
        for (String ext : parts) {
            String coding = codingExtensions.getAlternatives().get(ext);
            String ct = ctExtensions.getAlternatives().get(ext);
            assert (coding == null || ct == null) : "File extension conflict: '" + ext + "' maps to " + coding + " and " + ct;
            if (coding != null) {
                codings.add(coding);
            }
            if (ct != null) {
                contentType = ct;
                break;
            }
            if (coding != null || ct != null) continue;
            break;
        }
        RdfEntityInfo result = null;
        if (contentType != null) {
            result = (RdfEntityInfo)ModelFactory.createDefaultModel().createResource().as(RdfEntityInfo.class);
            result.setContentType(contentType);
            result.setContentEncodings(codings);
        }
        return result;
    }

    static {
        for (Lang lang : RDFLanguages.getRegisteredLanguages()) {
            List<String> contentTypes = HttpHeaderUtils.langToContentTypes(lang);
            for (String contentType : contentTypes) {
                String primaryFileExtension = (String)Iterables.getFirst((Iterable)lang.getFileExtensions(), null);
                if (primaryFileExtension != null) {
                    ctExtensions.getPrimary().put(contentType, primaryFileExtension);
                }
                for (String fileExtension : lang.getFileExtensions()) {
                    ctExtensions.getAlternatives().put(fileExtension, contentType);
                }
            }
        }
        ctExtensions.putPrimary(ContentType.TEXT_HTML.getMimeType(), "html");
        ctExtensions.putPrimary(ContentType.APPLICATION_OCTET_STREAM.getMimeType(), "bin");
        codingExtensions.putPrimary("gzip", "gz");
        codingExtensions.putPrimary("bzip2", "bz2");
    }
}

