/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.http.repository.impl;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aksw.commons.io.util.UriToPathUtils;
import org.aksw.jena_sparql_api.conjure.utils.ContentTypeUtils;
import org.aksw.jena_sparql_api.http.domain.api.RdfEntityInfo;
import org.aksw.jena_sparql_api.http.repository.api.HttpResourceRepositoryFromFileSystem;
import org.aksw.jena_sparql_api.http.repository.api.PathAnnotatorRdf;
import org.aksw.jena_sparql_api.http.repository.api.RdfHttpEntityFile;
import org.aksw.jena_sparql_api.http.repository.api.RdfHttpResourceFile;
import org.aksw.jena_sparql_api.http.repository.api.ResourceStore;
import org.aksw.jena_sparql_api.http.repository.impl.HttpObjectSerializer;
import org.aksw.jena_sparql_api.http.repository.impl.HttpObjectSerializerModel;
import org.aksw.jena_sparql_api.http.repository.impl.HttpResourceRepositoryFromFileSystemImpl;
import org.aksw.jena_sparql_api.http.repository.impl.PathAnnotatorRdfImpl;
import org.aksw.jena_sparql_api.http.repository.impl.RdfHttpEntityFileImpl;
import org.aksw.jena_sparql_api.http.repository.impl.RdfHttpResourceFileImpl;
import org.aksw.jena_sparql_api.http.repository.impl.ResourceSourceFile;
import org.aksw.jena_sparql_api.http.repository.impl.ResourceSourceFileImpl;
import org.aksw.jena_sparql_api.http.repository.impl.ResourceUtils;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceStoreImpl
implements ResourceStore {
    protected String TMP_SUFFIX = ".tmp";
    protected Path basePath;
    protected String CONTENT = "_content";
    protected ResourceSourceFile resourceSource;
    protected PathAnnotatorRdf pathAnnotator;
    protected Function<String, Path> uriToRelPath;
    private static final Logger logger = LoggerFactory.getLogger(ResourceStore.class);

    public static Map.Entry<RdfHttpEntityFile, Model> requestModel(HttpResourceRepositoryFromFileSystem repo, ResourceStore store, String uri, RDFFormat preferredOutputFormat, Supplier<Model> modelSupplier) throws IOException {
        Map.Entry<RdfHttpEntityFile, Model> result = ResourceStoreImpl.getOrCacheEntity(repo, store, uri, new HttpObjectSerializerModel(preferredOutputFormat), modelSupplier);
        return result;
    }

    public static <T> Map.Entry<RdfHttpEntityFile, T> getOrCacheEntity(HttpResourceRepositoryFromFileSystem repo, ResourceStore store, String uri, HttpObjectSerializer<T> serializer, Supplier<T> contentSupplier) throws IOException {
        T content;
        RdfHttpEntityFile entity;
        HttpUriRequest baseRequest = serializer.createHttpRequest(uri);
        HttpRequest effectiveRequest = HttpResourceRepositoryFromFileSystemImpl.expandHttpRequest((HttpRequest)baseRequest);
        logger.info("Expanded HTTP Request: " + String.valueOf(effectiveRequest));
        try {
            entity = repo.get(effectiveRequest, null);
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
        if (entity != null) {
            logger.info("Serving " + uri + " from cache");
            content = serializer.deserialize(entity);
        } else {
            logger.info("Serving" + uri + " from computation and adding to cache");
            content = contentSupplier.get();
            entity = serializer.serialize(uri, store, content);
            boolean sanityCheck = true;
            if (sanityCheck) {
                String file = entity.getAbsolutePath().toString();
                Model sanityCheckModel = RDFDataMgr.loadModel((String)file);
                logger.info("Sanity check result: Model has " + sanityCheckModel.size() + " triples");
            }
        }
        return Maps.immutableEntry((Object)entity, content);
    }

    public ResourceStoreImpl(Path basePath) {
        this(basePath, UriToPathUtils::resolvePath);
    }

    public ResourceStoreImpl(Path basePath, Function<String, Path> uriToRelPath) {
        this.basePath = basePath;
        this.uriToRelPath = uriToRelPath;
        this.pathAnnotator = new PathAnnotatorRdfImpl();
        this.resourceSource = new ResourceSourceFileImpl();
    }

    @Override
    public Path getAbsolutePath() {
        return this.basePath;
    }

    @Override
    public Resource getInfo(Path absPath) {
        Resource r1 = this.resourceSource.getResource(absPath);
        Resource r2 = this.pathAnnotator.getRecord(absPath);
        Resource result = ResourceUtils.merge(Arrays.asList(r1, r2));
        return result;
    }

    public Path fullPath(String uri) {
        Path relPath = this.uriToRelPath.apply(uri);
        Path result = this.basePath.resolve(relPath);
        return result;
    }

    public RdfHttpResourceFile get(String uri) {
        Path fullPath = this.fullPath(uri);
        RdfHttpResourceFileImpl result = new RdfHttpResourceFileImpl(this, fullPath);
        return result;
    }

    @Override
    public RdfHttpEntityFile putWithMove(String uri, RdfEntityInfo metadata, Path file) throws IOException {
        RdfHttpEntityFile result = this.allocateEntity(uri, (Resource)metadata);
        Path tgtFile = result.getAbsolutePath();
        Files.createDirectories(tgtFile.getParent(), new FileAttribute[0]);
        Files.move(file, tgtFile, StandardCopyOption.REPLACE_EXISTING);
        result.updateInfo(record -> ResourceUtils.copyDirectProperties(record, (Resource)metadata));
        return result;
    }

    @Override
    public RdfHttpEntityFile getEntityForPath(Path absEntityPath) {
        RdfHttpEntityFileImpl result;
        if (absEntityPath.startsWith(this.basePath)) {
            String fileName = absEntityPath.getFileName().toString();
            Path parent = absEntityPath.getParent();
            String parentFileName = parent.getFileName().toString();
            if (parentFileName.equals(this.CONTENT)) {
                Path resRelFolder = this.basePath.relativize(parent);
                Path entityRelFolder = parent.relativize(absEntityPath);
                RdfHttpResourceFileImpl res = new RdfHttpResourceFileImpl(this, resRelFolder);
                result = new RdfHttpEntityFileImpl(res, entityRelFolder);
            } else {
                result = null;
            }
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public RdfHttpResourceFile getResource(String uri) {
        Path path = this.uriToRelPath.apply(uri);
        path = path.resolve(this.CONTENT);
        RdfHttpResourceFileImpl result = new RdfHttpResourceFileImpl(this, path);
        return result;
    }

    @Override
    public Collection<RdfHttpEntityFile> listEntities(Path relContentFolder) {
        List<RdfHttpEntityFile> result;
        block9: {
            Path contentFolder = this.basePath.resolve(relContentFolder);
            try {
                if (!Files.exists(contentFolder, new LinkOption[0])) {
                    result = Collections.emptyList();
                    break block9;
                }
                try (Stream<Path> stream = Files.list(contentFolder);){
                    result = stream.filter(file -> this.pathAnnotator.isAnnotationFor((Path)file).isEmpty()).filter(file -> !file.getFileName().toString().endsWith(this.TMP_SUFFIX)).map(this::getEntityForPath).collect(Collectors.toList());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    @Override
    public boolean contains(Path path) {
        path = path.toAbsolutePath();
        boolean result = path.startsWith(this.basePath);
        return result;
    }

    @Override
    public Resource getInfo(Path path, String layer) {
        Resource result = this.contains(path) ? this.pathAnnotator.getRecord(path) : null;
        return result;
    }

    @Override
    public RdfHttpEntityFile allocateEntity(String uri, Resource description) {
        RdfHttpResourceFile res = this.getResource(uri);
        Path resPath = res.getAbsolutePath();
        RdfHttpEntityFile result = this.allocateEntity(resPath, description);
        return result;
    }

    public RdfHttpResourceFile pathToResource(Path baseRelPath) {
        RdfHttpResourceFileImpl result = new RdfHttpResourceFileImpl(this, baseRelPath);
        return result;
    }

    @Override
    public RdfHttpEntityFile allocateEntity(Path baseRelPath, Resource _info) {
        RdfEntityInfo info = (RdfEntityInfo)_info.as(RdfEntityInfo.class);
        String suffix = ContentTypeUtils.toFileExtension(info);
        Path finalRelPath = Paths.get("data" + suffix, new String[0]);
        RdfHttpResourceFile res = this.pathToResource(baseRelPath);
        RdfHttpEntityFileImpl result = new RdfHttpEntityFileImpl(res, finalRelPath);
        return result;
    }

    @Override
    public void updateInfo(Path path, Consumer<? super Resource> callback) {
        Resource r = this.pathAnnotator.getRecord(path);
        if (r == null) {
            throw new RuntimeException("Cannot update record of non-existent content file");
        }
        callback.accept((Resource)r);
        this.pathAnnotator.setRecord(path, r);
    }
}

