/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.http.repository.impl;

import com.google.common.base.Splitter;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteSource;
import com.google.common.net.MediaType;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aksw.dcat.ap.domain.api.Checksum;
import org.aksw.jena_sparql_api.conjure.algebra.common.ResourceTreeUtils;
import org.aksw.jena_sparql_api.conjure.entity.algebra.Op;
import org.aksw.jena_sparql_api.conjure.entity.engine.OpExecutor;
import org.aksw.jena_sparql_api.conjure.entity.engine.Planner;
import org.aksw.jena_sparql_api.conjure.entity.utils.PathCoderRegistry;
import org.aksw.jena_sparql_api.conjure.utils.ContentTypeUtils;
import org.aksw.jena_sparql_api.conjure.utils.FileUtils;
import org.aksw.jena_sparql_api.conjure.utils.HttpHeaderUtils;
import org.aksw.jena_sparql_api.http.domain.api.RdfEntityInfo;
import org.aksw.jena_sparql_api.http.repository.api.HttpResourceRepositoryFromFileSystem;
import org.aksw.jena_sparql_api.http.repository.api.RdfHttpEntity;
import org.aksw.jena_sparql_api.http.repository.api.RdfHttpEntityFile;
import org.aksw.jena_sparql_api.http.repository.api.RdfHttpResourceFile;
import org.aksw.jena_sparql_api.http.repository.api.ResourceStore;
import org.aksw.jena_sparql_api.http.repository.impl.ResourceStoreImpl;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpRequest;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sys.JenaSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResourceRepositoryFromFileSystemImpl
implements HttpResourceRepositoryFromFileSystem {
    private static final Logger logger = LoggerFactory.getLogger(HttpResourceRepositoryFromFileSystemImpl.class);
    protected ResourceStore downloadStore;
    protected ResourceStore cacheStore;
    protected ResourceStore hashStore;
    public static final String IDENTITY_ENCODING = "identity";

    public static Path hashToRelPath(String hash) {
        List parts = Splitter.fixedLength((int)8).splitToList((CharSequence)hash);
        String id = parts.stream().collect(Collectors.joining("/"));
        Path result = Paths.get(id, new String[0]);
        return result;
    }

    public static HttpResourceRepositoryFromFileSystemImpl create(Path absBasePath) {
        HttpResourceRepositoryFromFileSystemImpl result = new HttpResourceRepositoryFromFileSystemImpl();
        result.setDownloadStore(new ResourceStoreImpl(absBasePath.resolve("downloads")));
        result.setCacheStore(new ResourceStoreImpl(absBasePath.resolve("cache")));
        result.setHashStore(new ResourceStoreImpl(absBasePath.resolve("hash"), HttpResourceRepositoryFromFileSystemImpl::hashToRelPath));
        return result;
    }

    public Collection<ResourceStore> getResourceStores() {
        return Arrays.asList(this.downloadStore, this.cacheStore, this.hashStore);
    }

    public ResourceStore getDownloadStore() {
        return this.downloadStore;
    }

    public void setDownloadStore(ResourceStore downloadStore) {
        this.downloadStore = downloadStore;
    }

    public ResourceStore getCacheStore() {
        return this.cacheStore;
    }

    public void setCacheStore(ResourceStore cacheStore) {
        this.cacheStore = cacheStore;
    }

    public ResourceStore getHashStore() {
        return this.hashStore;
    }

    public void setHashStore(ResourceStore hashStore) {
        this.hashStore = hashStore;
    }

    public ResourceStore getStoreByPath(Path path) {
        ResourceStore result = this.getResourceStores().stream().filter(store -> store.contains(path)).findFirst().orElse(null);
        return result;
    }

    public Resource getInfo(Path path) {
        Resource result = Optional.ofNullable(this.getStoreByPath(path)).map(store -> store.getInfo(path)).orElse(null);
        return result;
    }

    public List<Path> readSymbolicLinkTransitive(Path absPath) {
        LinkedHashSet<Path> seen = new LinkedHashSet<Path>();
        ArrayList<Path> result = new ArrayList<Path>();
        while (Files.isSymbolicLink(absPath)) {
            Path tmpPath;
            if (!Files.exists(absPath, new LinkOption[0])) {
                result = null;
                break;
            }
            if (seen.contains(absPath)) {
                throw new RuntimeException("Cyclic symbolic link detected: " + String.valueOf(seen));
            }
            seen.add(absPath);
            result.add(absPath);
            try {
                tmpPath = Files.readSymbolicLink(absPath);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            absPath = absPath.getParent().resolve(tmpPath).normalize();
        }
        if (result != null) {
            result.add(absPath);
            Collections.reverse(result);
        }
        return result;
    }

    @Override
    public RdfHttpEntityFile getEntityForPath(Path path) {
        List<Path> resolvedPaths = this.readSymbolicLinkTransitive(path);
        Collection<ResourceStore> stores = this.getResourceStores();
        RdfHttpEntityFile result = null;
        block0: for (Path resolvedPath : resolvedPaths) {
            for (ResourceStore store : stores) {
                result = store.getEntityForPath(resolvedPath);
                if (result == null) continue;
                break block0;
            }
        }
        return result;
    }

    public Collection<RdfHttpEntityFile> getEntities(String uri) {
        Collection<ResourceStore> stores = this.getResourceStores();
        Collection result = stores.stream().map(store -> store.getResource(uri)).flatMap(res -> res.getEntities().stream()).collect(Collectors.toList());
        return result;
    }

    public static BasicHttpRequest createRequest(String url, String contentType, List<String> encodings) {
        BasicHttpRequest result = new BasicHttpRequest("GET", url);
        result.setHeader("Accept", contentType);
        ArrayList<String> effectiveEncodings = new ArrayList<String>(encodings);
        if (!encodings.contains(IDENTITY_ENCODING) && !encodings.isEmpty()) {
            effectiveEncodings.add("identity;q=0");
        }
        String encoding = effectiveEncodings.stream().collect(Collectors.joining(","));
        result.setHeader("Accept-Encoding", encoding);
        return result;
    }

    public static RdfHttpEntityFile get(HttpResourceRepositoryFromFileSystem repo, String url, String contentType, List<String> encodings) throws IOException {
        BasicHttpRequest request = HttpResourceRepositoryFromFileSystemImpl.createRequest(url, contentType, encodings);
        RdfHttpEntityFile result = repo.get((HttpRequest)request, HttpResourceRepositoryFromFileSystemImpl::resolveRequest);
        return result;
    }

    public String bestEncoding(Collection<String> encodings) {
        PathCoderRegistry registry = PathCoderRegistry.get();
        String result = encodings.stream().filter(enc -> registry.getCoder(enc) != null).findFirst().orElse(null);
        return result;
    }

    public MediaType bestContentType(Collection<MediaType> contentTypes) {
        List<MediaType> supportedMediaTypes = HttpHeaderUtils.supportedMediaTypes();
        MediaType result = contentTypes.stream().flatMap(range -> supportedMediaTypes.stream().filter(supportedMt -> supportedMt.is(range))).findFirst().orElse(null);
        return result;
    }

    public static Plan findBestPlanToServeRequest(HttpRequest request, Collection<RdfHttpEntityFile> entities, OpExecutor opExecutor) throws IOException {
        Map<String, Float> requestedEncodings;
        Header[] headers = request.getAllHeaders();
        List<MediaType> supportedContentTypes = HttpHeaderUtils.supportedMediaTypes();
        ArrayList<String> supportedEncodings = new ArrayList<String>(Arrays.asList(IDENTITY_ENCODING));
        supportedEncodings.addAll(PathCoderRegistry.get().getCoderNames());
        Map<MediaType, Float> requestedContentTypeRanges = HttpHeaderUtils.getOrderedValues(headers, "Accept").entrySet().stream().collect(Collectors.toMap(e -> MediaType.parse((String)((String)e.getKey())), Map.Entry::getValue));
        if (requestedContentTypeRanges.isEmpty()) {
            for (RdfHttpEntity rdfHttpEntity : entities) {
                RdfEntityInfo info = (RdfEntityInfo)rdfHttpEntity.getCombinedInfo().as(RdfEntityInfo.class);
                String mediaTypeStr = info.getContentType();
                if (mediaTypeStr == null) continue;
                MediaType mediaType = MediaType.parse((String)mediaTypeStr);
                requestedContentTypeRanges.put(mediaType, Float.valueOf(1.0f));
            }
        }
        if (!(requestedEncodings = HttpHeaderUtils.getOrderedValues(headers, "Accept-Encoding")).containsKey(IDENTITY_ENCODING)) {
            requestedEncodings.put(IDENTITY_ENCODING, Float.valueOf(1.0f));
        }
        Map map = requestedContentTypeRanges.entrySet().stream().filter(rangeEntry -> ((Float)rangeEntry.getValue()).floatValue() > 0.0f).flatMap(rangeEntry -> supportedContentTypes.stream().filter(supported -> supported.is((MediaType)rangeEntry.getKey())).map(supported -> Maps.immutableEntry((Object)supported, (Object)((Float)rangeEntry.getValue())))).sorted((a, b) -> ((Float)a.getValue()).compareTo((Float)b.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a, LinkedHashMap::new));
        Map candidateEncodings = requestedEncodings.entrySet().stream().filter(entry -> ((Float)entry.getValue()).floatValue() > 0.0f).flatMap(entry -> supportedEncodings.stream().filter(supported -> supported.equalsIgnoreCase((String)entry.getKey())).map(supported -> Maps.immutableEntry((Object)supported, (Object)((Float)entry.getValue())))).sorted((a, b) -> ((Float)a.getValue()).compareTo((Float)b.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a, LinkedHashMap::new));
        HashMultimap entityToPlan = HashMultimap.create();
        for (RdfHttpEntityFile entity : entities) {
            RdfEntityInfo info = (RdfEntityInfo)entity.getCombinedInfo().as(RdfEntityInfo.class);
            for (Map.Entry e2 : map.entrySet()) {
                String tgtContentType = ((MediaType)e2.getKey()).toString();
                Float tgtContentTypeScore = (Float)e2.getValue();
                for (Map.Entry f : candidateEncodings.entrySet()) {
                    String tgtEncoding = (String)f.getKey();
                    Float tgtEncodingScore = (Float)f.getValue();
                    List<String> tgtEncodings = tgtEncoding.equalsIgnoreCase(IDENTITY_ENCODING) ? Collections.emptyList() : Arrays.asList(tgtEncoding);
                    Op op = Planner.createPlan(entity, tgtContentType, tgtEncodings);
                    if (op == null) continue;
                    int numOps = ResourceTreeUtils.getNumOps(op, Op::getChildren);
                    RdfEntityInfo meta = ((RdfEntityInfo)ModelFactory.createDefaultModel().createResource().as(RdfEntityInfo.class)).setContentType(tgtContentType).setContentEncodings(tgtEncodings);
                    Plan plan = new Plan(op, meta);
                    Map.Entry planAndScore = Maps.immutableEntry((Object)plan, (Object)Float.valueOf(numOps));
                    entityToPlan.put((Object)entity, (Object)planAndScore);
                }
            }
        }
        Map.Entry entry2 = entityToPlan.entries().stream().sorted((a, b) -> ((Float)((Map.Entry)a.getValue()).getValue()).compareTo((Float)((Map.Entry)b.getValue()).getValue())).findFirst().orElse(null);
        Plan result = entry2 == null ? null : (Plan)((Map.Entry)entry2.getValue()).getKey();
        return result;
    }

    public static HttpRequest expandHttpRequest(HttpRequest request) {
        HttpUriRequest result = RequestBuilder.copy((HttpRequest)request).build();
        Header[] origHeaders = result.getAllHeaders();
        Header[] newHeaders = ContentTypeUtils.expandAccept(origHeaders);
        result.setHeaders(newHeaders);
        return result;
    }

    public boolean validateEntity(RdfHttpEntityFile entity) {
        Path path = entity.getAbsolutePath();
        boolean result = Files.exists(path, new LinkOption[0]);
        return result;
    }

    @Override
    public RdfHttpEntityFile get(HttpRequest request, Function<HttpRequest, Map.Entry<HttpRequest, HttpResponse>> httpRequester) throws IOException {
        RdfHttpEntityFile entity;
        Path hashPath;
        OpExecutor opExecutor;
        String uri = request.getRequestLine().getUri();
        Collection<RdfHttpEntityFile> entities = this.getEntities(uri);
        List<RdfHttpEntityFile> validatedEntities = entities.stream().filter(this::validateEntity).collect(Collectors.toList());
        Plan plan = HttpResourceRepositoryFromFileSystemImpl.findBestPlanToServeRequest(request, validatedEntities, opExecutor = new OpExecutor(this, this.hashStore));
        if (plan == null) {
            RdfHttpResourceFile res = this.downloadStore.getResource(uri);
            HttpRequest newRequest = HttpResourceRepositoryFromFileSystemImpl.expandHttpRequest(request);
            if (httpRequester != null) {
                Map.Entry<HttpRequest, HttpResponse> response = httpRequester.apply(newRequest);
                RdfHttpEntityFile entity2 = this.saveResponse(res, response.getKey(), response.getValue());
                plan = HttpResourceRepositoryFromFileSystemImpl.findBestPlanToServeRequest(request, Collections.singleton(entity2), opExecutor);
            }
        }
        if (plan == null) {
            return null;
        }
        Op op = plan.getOp();
        Path tgt = op.accept(opExecutor);
        if (tgt.startsWith(hashPath = this.hashStore.getAbsolutePath())) {
            if (!Files.isSymbolicLink(tgt)) {
                RdfEntityInfo meta = plan.getInfo();
                entity = this.cacheStore.allocateEntity(uri, (Resource)meta);
                Path tgtPath = entity.getAbsolutePath();
                HttpResourceRepositoryFromFileSystemImpl.forceCreateDirectories(tgtPath.getParent());
                try {
                    Files.move(tgt, tgtPath, new CopyOption[0]);
                }
                catch (Exception e) {
                    logger.warn("Should not happen: Failed move " + String.valueOf(tgt) + " to " + String.valueOf(tgtPath), (Throwable)e);
                }
                Path relTgtPath = tgt.getParent().relativize(tgtPath);
                Files.createSymbolicLink(tgt, relTgtPath, new FileAttribute[0]);
                entity = this.cacheStore.getEntityForPath(tgtPath);
                HttpResourceRepositoryFromFileSystemImpl.computeHashForEntity(entity, null);
            } else {
                Path relPathTgt = Files.readSymbolicLink(tgt);
                Path absPath = tgt.getParent().resolve(relPathTgt).normalize();
                entity = this.getEntityForPath(absPath);
            }
        } else {
            entity = this.getEntityForPath(tgt);
        }
        return entity;
    }

    public static void forceCreateFile(Path path) {
        try {
            Files.createFile(path, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void forceCreateDirectories(Path path) {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void computeHashForEntity(RdfHttpEntityFile rdfEntity, Path tmp) {
        Path targetPath = rdfEntity.getAbsolutePath();
        if (tmp == null) {
            tmp = targetPath;
        }
        ByteSource bs = com.google.common.io.Files.asByteSource((File)tmp.toFile());
        try {
            HashCode hashCode = bs.hash(Hashing.sha256());
            String str = hashCode.toString();
            HttpResourceRepositoryFromFileSystemImpl.forceCreateFile(targetPath);
            rdfEntity.updateInfo(info -> {
                Checksum hi = (Checksum)info.getModel().createResource().as(Checksum.class);
                hi.setAlgorithm("sha256").setChecksum(str);
                Collection hashes = ((RdfEntityInfo)info.as(RdfEntityInfo.class)).getHashes();
                hashes.add(hi);
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public RdfHttpEntityFile saveResponse(RdfHttpResourceFile targetResource, HttpRequest request, HttpResponse response) throws UnsupportedOperationException, IOException {
        HttpEntity entity = response.getEntity();
        String ct = HttpHeaderUtils.getValueOrNull(entity.getContentType());
        RdfEntityInfo meta = HttpHeaderUtils.copyMetaData(entity, null);
        String uri = request.getRequestLine().getUri();
        if (ct == null || ct.equalsIgnoreCase(ContentType.APPLICATION_OCTET_STREAM.getMimeType()) || ct.equalsIgnoreCase(ContentType.TEXT_PLAIN.getMimeType()) || ct.equalsIgnoreCase(ContentType.parse((String)"application/x-gzip").getMimeType()) || ct.equalsIgnoreCase(ContentType.parse((String)"application/x-bzip2").getMimeType())) {
            meta = ContentTypeUtils.deriveHeadersFromFileName(uri);
        }
        RdfHttpEntityFile rdfEntity = targetResource.allocate((Resource)meta);
        Path targetPath = rdfEntity.getAbsolutePath();
        Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
        Path tmp = FileUtils.allocateTmpFile(targetPath);
        Files.copy(entity.getContent(), tmp, StandardCopyOption.REPLACE_EXISTING);
        HttpResourceRepositoryFromFileSystemImpl.computeHashForEntity(rdfEntity, tmp);
        logger.info("For url " + uri + " moving file " + String.valueOf(tmp) + " to " + String.valueOf(targetPath));
        Files.move(tmp, targetPath, StandardCopyOption.REPLACE_EXISTING);
        return rdfEntity;
    }

    public static Map.Entry<HttpRequest, HttpResponse> resolveRequest(HttpRequest request) {
        HttpResponse response;
        String url = request.getRequestLine().getUri();
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpUriRequest myRequest = RequestBuilder.copy((HttpRequest)request).setUri(url).build();
        try {
            response = client.execute(myRequest);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return Maps.immutableEntry((Object)myRequest, (Object)response);
    }

    public static Path getDefaultPath() {
        String homeDir = StandardSystemProperty.USER_HOME.value();
        Path result = Paths.get(homeDir, new String[0]).resolve(".dcat/repository");
        return result;
    }

    public static HttpResourceRepositoryFromFileSystemImpl createDefault() throws IOException {
        Path root = HttpResourceRepositoryFromFileSystemImpl.getDefaultPath();
        Files.createDirectories(root, new FileAttribute[0]);
        HttpResourceRepositoryFromFileSystemImpl result = HttpResourceRepositoryFromFileSystemImpl.create(root);
        return result;
    }

    public static void main(String[] args) throws IOException {
        JenaSystem.init();
        Header[] expansionTest = new Header[]{new BasicHeader("Accept", "application/turtle;q=0.3")};
        expansionTest = ContentTypeUtils.expandAccept(expansionTest);
        System.out.println("Expanded: " + String.valueOf(Arrays.asList(expansionTest)));
        Path root = Paths.get("/home/raven/.dcat/test3", new String[0]);
        Files.createDirectories(root, new FileAttribute[0]);
        HttpResourceRepositoryFromFileSystemImpl manager = HttpResourceRepositoryFromFileSystemImpl.create(root);
        ResourceStore store = manager.getDownloadStore();
        ResourceStore hashStore = manager.getHashStore();
        String url = "http://downloads.dbpedia.org/2016-10/core-i18n/en/genders_en.ttl.bz2";
        RdfHttpEntityFile entity = HttpResourceRepositoryFromFileSystemImpl.get(manager, url, "application/rdf+xml", Arrays.asList("bzip2"));
    }

    public static class Plan {
        protected Op op;
        protected RdfEntityInfo info;

        public Plan(Op op, RdfEntityInfo info) {
            this.op = op;
            this.info = info;
        }

        public Op getOp() {
            return this.op;
        }

        public RdfEntityInfo getInfo() {
            return this.info;
        }
    }
}

