/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.conjure.noderef;

import org.aksw.jena_sparql_api.conjure.dataref.rdf.api.RdfDataRef;
import org.aksw.jena_sparql_api.conjure.dataref.rdf.api.RdfDataRefDcat;
import org.aksw.jena_sparql_api.conjure.dataref.rdf.api.RdfDataRefUrl;
import org.aksw.jenax.annotation.reprogen.HashId;
import org.aksw.jenax.annotation.reprogen.IriNs;
import org.aksw.jenax.annotation.reprogen.PolymorphicOnly;
import org.aksw.jenax.annotation.reprogen.ResourceView;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;

@ResourceView
public interface NodeRef
extends Resource {
    @IriNs(value="rpif")
    @HashId
    @PolymorphicOnly
    public RdfDataRef getDataRef();

    public NodeRef setDataRef(Resource var1);

    @IriNs(value="rpif")
    @HashId
    public Node getNode();

    public NodeRef setNode(Node var1);

    @IriNs(value="rpif")
    @HashId
    public Node getGraph();

    public NodeRef setGraph(Node var1);

    public static NodeRef createForFile(Model model, String fileIri, Node node, Node graph) {
        RdfDataRefUrl dataRef = ((RdfDataRefUrl)model.createResource().as(RdfDataRefUrl.class)).setDataRefUrl(fileIri);
        NodeRef result = ((NodeRef)model.createResource().as(NodeRef.class)).setDataRef(dataRef).setNode(node).setGraph(graph);
        return result;
    }

    public static NodeRef createForDcatEntity(Model model, Node dcatEntity, Node node, Node graph) {
        RdfDataRefDcat dataRef = ((RdfDataRefDcat)model.createResource().as(RdfDataRefDcat.class)).setDcatRecordNode(dcatEntity);
        NodeRef result = NodeRef.createForDataRef(model, dataRef.asNode(), node, graph);
        return result;
    }

    public static NodeRef createForDataRef(Model model, Node dataRef, Node node, Node graph) {
        NodeRef result = ((NodeRef)model.createResource().as(NodeRef.class)).setDataRef(model.wrapAsResource(dataRef)).setNode(node).setGraph(graph);
        return result;
    }
}

