/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.conjure.datapod.impl;

import java.io.IOException;
import java.net.Authenticator;
import java.net.http.HttpClient;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.aksw.commons.io.util.UriUtils;
import org.aksw.commons.util.ref.Ref;
import org.aksw.commons.util.ref.RefImpl;
import org.aksw.jena_sparql_api.conjure.datapod.api.RdfDataPod;
import org.aksw.jena_sparql_api.conjure.datapod.impl.DataPodFactoryAdvancedImpl;
import org.aksw.jena_sparql_api.conjure.datapod.impl.DataPodFactoryImpl;
import org.aksw.jena_sparql_api.conjure.datapod.impl.RdfDataPodBase;
import org.aksw.jena_sparql_api.conjure.datapod.impl.RdfDataPodHdtImpl;
import org.aksw.jena_sparql_api.conjure.dataref.core.api.DataRef;
import org.aksw.jena_sparql_api.conjure.dataref.core.api.DataRefSparqlEndpoint;
import org.aksw.jena_sparql_api.conjure.dataref.core.api.DataRefUrl;
import org.aksw.jena_sparql_api.conjure.dataref.rdf.api.RdfAuth;
import org.aksw.jena_sparql_api.conjure.dataref.rdf.api.RdfAuthBasic;
import org.aksw.jena_sparql_api.conjure.dataref.rdf.api.RdfAuthBearerToken;
import org.aksw.jena_sparql_api.conjure.dataref.rdf.api.RdfDataRef;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpDataRefResource;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpVisitor;
import org.aksw.jena_sparql_api.conjure.dataset.engine.ExecutionUtils;
import org.aksw.jena_sparql_api.http.repository.api.HttpResourceRepositoryFromFileSystem;
import org.aksw.jena_sparql_api.http.repository.api.RdfHttpEntityFile;
import org.aksw.jena_sparql_api.http.repository.impl.HttpResourceRepositoryFromFileSystemImpl;
import org.aksw.jena_sparql_api.io.hdt.JenaPluginHdt;
import org.aksw.jenax.dataaccess.sparql.connection.common.RDFConnectionUtils;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSource;
import org.aksw.jenax.dataaccess.sparql.factory.dataset.connection.DatasetRDFConnectionFactoryBuilder;
import org.aksw.jenax.reprogen.core.JenaPluginUtils;
import org.aksw.jenax.sparql.query.rx.RDFDataMgrEx;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.jena.http.auth.AuthEnv;
import org.apache.jena.http.auth.AuthLib;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdfconnection.RDFConnectionRemote;
import org.apache.jena.rdfconnection.RDFConnectionRemoteBuilder;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.sparql.exec.http.QuerySendMode;
import org.apache.jena.sparql.exec.http.UpdateSendMode;
import org.apache.jena.util.ResourceUtils;
import org.rdfhdt.hdt.hdt.HDT;
import org.rdfhdt.hdt.hdt.HDTManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataPods {
    private static final Logger logger = LoggerFactory.getLogger(DataPods.class);

    public static RdfDataPod fromDataRef(RdfDataRef dataRef) {
        Resource rawCopy = dataRef.inModel(ResourceUtils.reachableClosure((Resource)dataRef));
        RdfDataRef copy = (RdfDataRef)JenaPluginUtils.polymorphicCast((RDFNode)rawCopy, RdfDataRef.class);
        OpDataRefResource basicWorkflow = OpDataRefResource.from(copy.getModel(), copy);
        RdfDataPod result = ExecutionUtils.executeJob(basicWorkflow);
        return result;
    }

    public static RdfDataPod empty() {
        RdfDataPod result = DataPods.fromModel(ModelFactory.createDefaultModel());
        return result;
    }

    public static RdfDataPod fromData(Object data) {
        if (data != null) {
            throw new RuntimeException("not implemented yet");
        }
        RdfDataPod result = DataPods.fromModel(ModelFactory.createDefaultModel());
        return result;
    }

    public static RdfDataPod fromDataRef(DataRef dataRef, Dataset dataset, HttpResourceRepositoryFromFileSystem repo, OpVisitor<? extends RdfDataPod> opExecutor) {
        DataPodFactoryAdvancedImpl factory = new DataPodFactoryAdvancedImpl(dataset, opExecutor, repo);
        RdfDataPod result = dataRef.accept(factory);
        return result;
    }

    public static RdfDataPod fromDataRef(DataRef dataRef, OpVisitor<? extends RdfDataPod> opExecutor) {
        DataPodFactoryImpl defaultFactory = new DataPodFactoryImpl(opExecutor);
        RdfDataPod result = dataRef.accept(defaultFactory);
        return result;
    }

    public static RdfDataPod fromDataset(final Dataset dataset) {
        return new RdfDataPodBase(){

            @Override
            protected RDFConnection newConnection() {
                RDFConnection result = DatasetRDFConnectionFactoryBuilder.connect((Dataset)dataset);
                return result;
            }

            @Override
            public Model getModel() {
                Model r = dataset.getDefaultModel();
                return r;
            }
        };
    }

    public static RdfDataPod fromModel(Model model) {
        Dataset dataset = DatasetFactory.wrap((Model)model);
        RdfDataPod result = DataPods.fromDataset(dataset);
        return result;
    }

    public static RdfDataPod fromUrl(DataRefUrl dataRef) {
        String url = dataRef.getDataRefUrl();
        RdfDataPod result = DataPods.fromUrl(url);
        return result;
    }

    public static RdfDataPod fromUrl(String url) {
        RdfDataPod result;
        logger.info("Loading: " + url);
        Lang lang = RDFLanguages.resourceNameToLang((String)url);
        if (JenaPluginHdt.LANG_HDT.equals((Object)lang)) {
            HDT hdt;
            logger.info("HDT file detected - loading using HDT graph " + url);
            Path path = Paths.get(UriUtils.newURI((String)url));
            String pathStr = path.toString();
            try {
                hdt = HDTManager.mapHDT((String)pathStr);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            logger.info("Loading of hdt complete " + pathStr);
            Ref hdtRef = RefImpl.create((Object)hdt, null, () -> {
                logger.debug("Closed HDT file: " + pathStr);
                hdt.close();
            }, (Object)("HDT Data Pod from " + pathStr));
            result = new RdfDataPodHdtImpl((Ref<HDT>)hdtRef, false);
        } else {
            Dataset dataset = RDFDataMgrEx.loadDatasetAsGiven((String)url, null);
            result = DataPods.fromDataset(dataset);
        }
        return result;
    }

    public static RdfDataPod create(String url, HttpResourceRepositoryFromFileSystem repo) {
        RdfDataPod r;
        if (url.startsWith("http://") || url.startsWith("https://")) {
            RdfHttpEntityFile entity;
            try {
                HttpUriRequest baseRequest = RequestBuilder.get((String)url).setHeader("Accept", "application/x-hdt").setHeader("Accept-Encoding", "identity,bzip2,gzip").build();
                HttpRequest effectiveRequest = HttpResourceRepositoryFromFileSystemImpl.expandHttpRequest((HttpRequest)baseRequest);
                logger.info("Expanded HTTP Request: " + String.valueOf(effectiveRequest));
                entity = repo.get(effectiveRequest, HttpResourceRepositoryFromFileSystemImpl::resolveRequest);
                logger.info("Response entity is: " + String.valueOf(entity));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Path absPath = entity.getAbsolutePath();
            logger.info("Resolved " + url + " to " + String.valueOf(absPath));
            r = DataPods.fromUrl(absPath.toUri().toString());
        } else {
            r = DataPods.fromUrl(url);
        }
        return r;
    }

    public static RdfDataPod fromSparqlEndpoint(final DataRefSparqlEndpoint dataRef) {
        RdfAuth authData;
        final String serviceUrl = dataRef.getServiceUrl();
        List<String> defaultGraphs = dataRef.getDefaultGraphs();
        List<String> namedGraphs = dataRef.getNamedGraphs();
        Object auth = dataRef.getAuth();
        Objects.requireNonNull(serviceUrl, "Service URL must not be null");
        final ArrayList<String> defaultGraphsCpy = defaultGraphs == null ? null : new ArrayList<String>(defaultGraphs);
        final ArrayList<String> namedGraphsCpy = namedGraphs == null ? null : new ArrayList<String>(namedGraphs);
        Authenticator authenticator = null;
        if (auth instanceof RdfAuthBasic) {
            authData = (RdfAuthBasic)auth;
            String username = authData.getUsername();
            String password = authData.getPassword();
            authenticator = AuthLib.authenticator((String)username, (String)password);
        }
        if (auth instanceof RdfAuthBearerToken) {
            authData = (RdfAuthBearerToken)auth;
            String bearerToken = authData.getBearerToken();
            AuthEnv.get().setBearerToken(serviceUrl, bearerToken);
        }
        HttpClient.Builder httpClientBuilder = HttpClient.newBuilder();
        if (authenticator != null) {
            httpClientBuilder = httpClientBuilder.authenticator(authenticator);
        }
        final HttpClient httpClient = httpClientBuilder.build();
        RdfDataPod result = new RdfDataPod(){

            @Override
            public RDFConnection getConnection() {
                QuerySendMode sendMode;
                RDFConnectionRemoteBuilder rdfConnectionBuilder = RDFConnectionRemote.create().destination(serviceUrl);
                String value = dataRef.getAcceptHeaderAskQuery();
                if (value != null) {
                    rdfConnectionBuilder = rdfConnectionBuilder.acceptHeaderAskQuery(value);
                }
                if ((value = dataRef.getAcceptHeaderSelectQuery()) != null) {
                    rdfConnectionBuilder = rdfConnectionBuilder.acceptHeaderSelectQuery(value);
                }
                if ((value = dataRef.getAcceptHeaderGraph()) != null) {
                    rdfConnectionBuilder = rdfConnectionBuilder.acceptHeaderGraph(value);
                }
                if ((value = dataRef.getAcceptHeaderDataset()) != null) {
                    rdfConnectionBuilder = rdfConnectionBuilder.acceptHeaderDataset(value);
                }
                if ((value = dataRef.getSendModeQuery()) != null) {
                    sendMode = QuerySendMode.valueOf((String)value);
                    rdfConnectionBuilder = rdfConnectionBuilder.querySendMode(sendMode);
                }
                if ((value = dataRef.getSendModeUpdate()) != null) {
                    sendMode = UpdateSendMode.valueOf((String)value);
                    rdfConnectionBuilder = rdfConnectionBuilder.updateSendMode((UpdateSendMode)sendMode);
                }
                rdfConnectionBuilder = rdfConnectionBuilder.httpClient(httpClient);
                RDFConnection r = rdfConnectionBuilder.build();
                r = RDFConnectionUtils.wrapWithQueryTransform((RDFConnection)r, query -> {
                    Query res;
                    boolean updateNamedGraphs;
                    boolean updateDefaultGraphs = query.getGraphURIs().isEmpty() && defaultGraphsCpy != null && !defaultGraphsCpy.isEmpty();
                    boolean bl = updateNamedGraphs = query.getNamedGraphURIs().isEmpty() && namedGraphsCpy != null && !namedGraphsCpy.isEmpty();
                    if (updateDefaultGraphs || updateNamedGraphs) {
                        res = query.cloneQuery();
                        if (updateDefaultGraphs) {
                            res.getGraphURIs().addAll(defaultGraphsCpy);
                        }
                        if (updateNamedGraphs) {
                            res.getNamedGraphURIs().addAll(namedGraphsCpy);
                        }
                    } else {
                        res = query;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Effective query: " + String.valueOf(res));
                    }
                    return res;
                });
                return r;
            }

            @Override
            public void close() throws Exception {
            }

            @Override
            public boolean isMutable() {
                return true;
            }
        };
        return result;
    }

    public static RdfDataPod fromDataSource(final RDFDataSource supplier) {
        return new RdfDataPodBase(){

            @Override
            protected RDFConnection newConnection() {
                RDFConnection result = supplier.getConnection();
                return result;
            }
        };
    }
}

