/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.conjure.utils;

import com.google.common.collect.Maps;
import com.google.common.net.MediaType;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aksw.commons.collections.collectors.CollectorUtils;
import org.aksw.jena_sparql_api.http.domain.api.RdfEntityInfo;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicHeader;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;

public class HttpHeaderUtils {
    public static Map.Entry<String, String> toEntry(Header header) {
        Map.Entry result = Maps.immutableEntry((Object)header.getName(), (Object)header.getValue());
        return result;
    }

    public static Stream<Map.Entry<String, String>> toEntries(Header[] headers) {
        return Arrays.asList(headers).stream().map(HttpHeaderUtils::toEntry);
    }

    public static Header[] mergeHeaders(Header[] headers, String name) {
        List<Header> affectedHeaders = HttpHeaderUtils.streamHeaders(headers, name).collect(Collectors.toList());
        List parts = HttpHeaderUtils.getElements(affectedHeaders.toArray(new Header[0]), name).collect(Collectors.toList());
        String mergedStr = parts.stream().map(Objects::toString).collect(Collectors.joining(","));
        Header[] result = new Header[headers.length - (affectedHeaders.isEmpty() ? 0 : affectedHeaders.size() - 1)];
        boolean isHeaderEmitted = false;
        int j = 0;
        for (int i = 0; i < headers.length; ++i) {
            Header h = headers[i];
            String headerName = h.getName();
            if (headerName.equalsIgnoreCase(name)) {
                if (isHeaderEmitted) continue;
                result[j++] = new BasicHeader(headerName, mergedStr);
                isHeaderEmitted = true;
                continue;
            }
            result[j++] = headers[i];
        }
        return result;
    }

    public static float qValueOf(HeaderElement h) {
        float result = Optional.ofNullable(h.getParameterByName("q")).map(NameValuePair::getValue).map(Float::parseFloat).orElse(Float.valueOf(1.0f)).floatValue();
        return result;
    }

    public static Stream<Header> streamHeaders(Header[] headers) {
        Stream<Header> result = headers == null ? Stream.empty() : Arrays.asList(headers).stream();
        return result;
    }

    public static Stream<Header> streamHeaders(Header[] headers, String name) {
        Stream<Header> result = HttpHeaderUtils.streamHeaders(headers).filter(h -> h.getName().equalsIgnoreCase(name));
        return result;
    }

    public static Stream<HeaderElement> getElements(Header[] headers) {
        Stream<HeaderElement> result = HttpHeaderUtils.streamHeaders(headers).flatMap(h -> Arrays.asList(h.getElements()).stream());
        return result;
    }

    public static Stream<HeaderElement> getElements(Header[] headers, String name) {
        Stream<HeaderElement> result = HttpHeaderUtils.streamHeaders(headers).filter(Objects::nonNull).filter(h -> h.getName().equalsIgnoreCase(name)).flatMap(h -> Arrays.asList(h.getElements()).stream());
        return result;
    }

    public static Map<String, Float> getOrderedValues(Header[] headers, String name) {
        Map result = (Map)HttpHeaderUtils.getElements(headers, name).map(e -> Maps.immutableEntry((Object)e.getName(), (Object)Float.valueOf(HttpHeaderUtils.qValueOf(e)))).sorted((a, b) -> ((Float)a.getValue()).compareTo((Float)b.getValue())).collect(CollectorUtils.toLinkedHashMap(Map.Entry::getKey, Map.Entry::getValue));
        return result;
    }

    public static String getValueOrNull(Header header) {
        List<String> values;
        List<String> list = values = header == null ? null : HttpHeaderUtils.getValues(new Header[]{header}, header.getName());
        if (values != null && values.size() > 1) {
            throw new RuntimeException("At most 1 value expected, got: " + String.valueOf(values));
        }
        String result = values == null ? null : values.get(0);
        return result;
    }

    public static String getValue(Header[] headers, String name) {
        List<String> contentTypes = HttpHeaderUtils.getValues(headers, name);
        if (contentTypes.size() != 1) {
            throw new RuntimeException("Exactly one content type expected, got: " + String.valueOf(contentTypes));
        }
        return contentTypes.get(0);
    }

    public static List<String> getValues(Header header, String name) {
        List<String> result = HttpHeaderUtils.getValues(new Header[]{header}, name);
        return result;
    }

    public static List<String> getValues(Header[] headers, String name) {
        List<String> result = HttpHeaderUtils.getElements(headers, name).map(HeaderElement::getName).collect(Collectors.toList());
        return result;
    }

    public static RdfEntityInfo copyMetaData(HttpEntity src, RdfEntityInfo tgt) {
        tgt = tgt != null ? tgt : (RdfEntityInfo)ModelFactory.createDefaultModel().createResource().as(RdfEntityInfo.class);
        List<String> encodings = HttpHeaderUtils.getValues(src.getContentEncoding(), "Content-Encoding");
        String ct = HttpHeaderUtils.getValueOrNull(src.getContentType());
        tgt.setContentType(ct);
        tgt.setContentEncodings(encodings);
        return tgt;
    }

    public static Header[] toHeaders(RdfEntityInfo info) {
        Header[] result = new Header[]{new BasicHeader("Content-Type", info.getContentType()), new BasicHeader("Content-Encoding", info.getEncodingsAsHttpHeader())};
        return result;
    }

    public static List<MediaType> supportedMediaTypes() {
        Collection langs = RDFLanguages.getRegisteredLanguages();
        List<MediaType> result = HttpHeaderUtils.supportedMediaTypes(langs);
        return result;
    }

    public static List<String> langToContentTypes(Lang lang) {
        List<String> result = Stream.concat(Stream.of(lang.getContentType().getContentTypeStr()), lang.getAltContentTypes().stream()).distinct().collect(Collectors.toList());
        return result;
    }

    public static List<MediaType> langToMediaTypes(Lang lang) {
        List<MediaType> result = HttpHeaderUtils.langToContentTypes(lang).stream().map(MediaType::parse).collect(Collectors.toList());
        return result;
    }

    public static List<MediaType> supportedMediaTypes(Collection<Lang> langs) {
        List<MediaType> types = langs.stream().flatMap(lang -> HttpHeaderUtils.langToMediaTypes(lang).stream()).collect(Collectors.toList());
        return types;
    }
}

