/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.conjure.fluent;

import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.aksw.jena_sparql_api.common.DefaultPrefixes;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.Op;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpUtils;
import org.aksw.jena_sparql_api.conjure.fluent.ConjureBuilderImpl;
import org.aksw.jena_sparql_api.conjure.job.api.Job;
import org.aksw.jena_sparql_api.conjure.job.api.JobInstance;
import org.aksw.jena_sparql_api.conjure.job.api.JobParam;
import org.aksw.jenax.arq.util.node.NodeEnvsubst;
import org.aksw.jenax.reprogen.core.JenaPluginUtils;
import org.aksw.jenax.stmt.core.SparqlStmt;
import org.aksw.jenax.stmt.core.SparqlStmtParserImpl;
import org.aksw.jenax.stmt.util.SparqlStmtUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.vocabulary.RDF;

public class JobUtils {
    public static List<Job> listJobs(Model model) {
        Resource xjob = ResourceFactory.createResource((String)"http://w3id.org/rpif/vocab#Job");
        List jobs = model.listResourcesWithProperty(RDF.type, (RDFNode)xjob).mapWith(r -> (Job)r.as(Job.class)).toList();
        return jobs;
    }

    public static Job getOnlyJob(Model model) {
        List<Job> jobs = JobUtils.listJobs(model);
        Job job = (Job)Iterables.getOnlyElement(jobs);
        return job;
    }

    public static Job fromSparqlStmts(Collection<SparqlStmt> stmts, Set<String> optionalArgs, Map<Var, Expr> varToExpr) {
        Set mentionedEnvVars = SparqlStmtUtils.getMentionedEnvVars(stmts);
        List<String> stmtStrs = stmts.stream().map(Object::toString).collect(Collectors.toList());
        ConjureBuilderImpl cj = new ConjureBuilderImpl();
        String opVarName = "ARG";
        Op op = cj.fromVar(opVarName).construct(stmtStrs).getOp();
        Map<String, Boolean> combinedMap = stmts.stream().map(SparqlStmtUtils::mentionedEnvVars).map(Map::entrySet).flatMap(Collection::stream).distinct().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Set<String> envVars = combinedMap.keySet();
        Job result = Job.create(cj.getContext().getModel()).setOp(op).setOpVars(Collections.singleton(opVarName));
        for (String varName : mentionedEnvVars) {
            JobParam param = result.addNewParam();
            param.setParamName(varName);
            Var v = Var.alloc((String)varName);
            Expr expr = varToExpr.get(v);
            param.setDefaultValueExpr(expr);
        }
        return result;
    }

    public static Job fromSparqlFile(String path) throws FileNotFoundException, IOException {
        List stmts = Streams.stream((Iterator)SparqlStmtUtils.processFile((PrefixMapping)DefaultPrefixes.get(), (String)path)).collect(Collectors.toList());
        List<String> stmtStrs = stmts.stream().map(Object::toString).collect(Collectors.toList());
        ConjureBuilderImpl cj = new ConjureBuilderImpl();
        String opVarName = "ARG";
        Op op = cj.fromVar(opVarName).stmts(stmtStrs).getOp();
        Map<String, Boolean> combinedMap = stmts.stream().map(SparqlStmtUtils::mentionedEnvVars).map(Map::entrySet).flatMap(Collection::stream).distinct().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Set<String> envVars = combinedMap.keySet();
        Job result = Job.create(cj.getContext().getModel()).setOp(op).setOpVars(Collections.singleton(opVarName));
        for (String varName : envVars) {
            JobParam param = result.addNewParam();
            param.setParamName(varName);
        }
        return result;
    }

    public static JobInstance createJobInstanceWithCopy(Job job, Map<String, ? extends Node> env, Map<String, ? extends Op> map) {
        Model model = ModelFactory.createDefaultModel();
        Job j = (Job)JenaPluginUtils.copyClosureInto((RDFNode)job, Job.class, (Model)model);
        JobInstance result = ((JobInstance)model.createResource().as(JobInstance.class)).setJob(j);
        result.getEnvMap().putAll(env);
        for (Map.Entry<String, ? extends Op> e : map.entrySet()) {
            String k = e.getKey();
            Op v = e.getValue();
            Op vv = (Op)JenaPluginUtils.copyClosureInto((RDFNode)v, Op.class, (Model)model);
            result.getOpVarMap().put(k, vv);
        }
        return result;
    }

    public static JobInstance createJobInstance(Job job, Map<String, ? extends Node> env, Map<String, ? extends Op> map) {
        Model model = job.getModel();
        JobInstance result = ((JobInstance)model.createResource().as(JobInstance.class)).setJob(job);
        result.getEnvMap().putAll(env);
        for (Map.Entry<String, ? extends Op> e : map.entrySet()) {
            String k = e.getKey();
            Op v = e.getValue();
            Op vv = (Op)JenaPluginUtils.copyClosureInto((RDFNode)v, Op.class, (Model)model);
            result.getOpVarMap().put(k, vv);
        }
        return result;
    }

    public static Op materializeJobInstance(JobInstance jobInstance) {
        Map<String, Node> envMap = jobInstance.getEnvMap();
        Map<String, Op> opMap = jobInstance.getOpVarMap();
        Job job = jobInstance.getJob();
        Op tmp = job.getOp();
        Op op = (Op)JenaPluginUtils.reachableClosure((RDFNode)tmp, Op.class);
        NodeTransform nodeTransform = x -> NodeEnvsubst.substWithNode((Node)x, envMap::get);
        OpUtils.applyNodeTransform(op, nodeTransform, stmt -> SparqlStmtUtils.optimizePrefixes((SparqlStmt)SparqlStmtParserImpl.create((PrefixMapping)DefaultPrefixes.get()).apply(stmt)));
        Op inst = OpUtils.substituteVars(op, opMap::get);
        return inst;
    }
}

