/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.conjure.entity.algebra;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import org.aksw.jena_sparql_api.conjure.algebra.common.ResourceTreeUtils;
import org.aksw.jena_sparql_api.conjure.entity.algebra.Op;
import org.aksw.jena_sparql_api.conjure.entity.algebra.OpPath;
import org.aksw.jena_sparql_api.conjure.entity.algebra.OpVisitor;
import org.aksw.jena_sparql_api.http.domain.api.RdfEntityInfo;
import org.aksw.jena_sparql_api.http.repository.api.RdfHttpEntityFile;
import org.aksw.jena_sparql_api.http.repository.api.RdfHttpResourceFile;
import org.aksw.jena_sparql_api.http.repository.api.ResourceStore;
import org.apache.http.entity.ContentType;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;

public class OpUtils {
    public static Op optimize(Op op, OpVisitor<String> hasher, ResourceStore hashSpace) {
        Op result;
        String hash = op.accept(hasher);
        RdfHttpResourceFile res = hashSpace.getResource(hash);
        RdfHttpEntityFile entity = res.allocate((Resource)((RdfEntityInfo)ModelFactory.createDefaultModel().createResource().as(RdfEntityInfo.class)).setContentType(ContentType.APPLICATION_OCTET_STREAM.toString()));
        Path path = entity.getAbsolutePath();
        boolean exists = Files.exists(path, new LinkOption[0]);
        if (exists) {
            ResourceTreeUtils.clearSubTree(op, Op::getChildren);
            OpPath opValue = (OpPath)op.as(OpPath.class);
            opValue.setName(path.toString());
            result = opValue;
        } else {
            Collection<Op> children = op.getChildren();
            for (Op child : children) {
                OpUtils.optimize(child, hasher, hashSpace);
            }
            result = op;
        }
        return result;
    }
}

