/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.conjure.dataset.engine;

import com.google.common.collect.LinkedHashMultimap;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aksw.commons.model.maven.domain.api.MavenEntityCore;
import org.aksw.dcat.jena.domain.api.DcatDataset;
import org.aksw.dcat.jena.domain.api.DcatDistribution;
import org.aksw.dcat.jena.domain.api.MavenEntity;
import org.aksw.jena_sparql_api.conjure.algebra.common.ResourceTreeUtils;
import org.aksw.jena_sparql_api.conjure.datapod.api.RdfDataPod;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.Op;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpUtils;
import org.aksw.jena_sparql_api.conjure.dataset.engine.ConjureFormatConfig;
import org.aksw.jena_sparql_api.conjure.dataset.engine.OpExecutorDefault;
import org.aksw.jena_sparql_api.conjure.dataset.engine.TaskContext;
import org.aksw.jena_sparql_api.conjure.job.api.Job;
import org.aksw.jena_sparql_api.conjure.job.api.JobBinding;
import org.aksw.jena_sparql_api.conjure.traversal.api.OpTraversal;
import org.aksw.jena_sparql_api.conjure.traversal.engine.FunctionAssembler;
import org.aksw.jena_sparql_api.http.repository.api.HttpResourceRepositoryFromFileSystem;
import org.aksw.jena_sparql_api.http.repository.api.RdfHttpEntityFile;
import org.aksw.jena_sparql_api.http.repository.api.ResourceStore;
import org.aksw.jena_sparql_api.http.repository.impl.HttpResourceRepositoryFromFileSystemImpl;
import org.aksw.jena_sparql_api.http.repository.impl.ResourceStoreImpl;
import org.aksw.jena_sparql_api.rdf.collections.ResourceUtils;
import org.aksw.jenax.arq.util.binding.BindingUtils;
import org.aksw.jenax.reprogen.core.JenaPluginUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.vocabulary.DCAT;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionUtils {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionUtils.class);

    public static String deriveId(Resource r) {
        MavenEntity ds = (MavenEntity)ModelFactory.createDefaultModel().createResource().as(MavenEntity.class);
        String mvnId = MavenEntityCore.toString((MavenEntityCore)MavenEntityCore.normalize((MavenEntityCore)ds));
        String result = !mvnId.isEmpty() ? mvnId : (r.isURIResource() ? r.getURI() : ResourceTreeUtils.createGenericHash((RDFNode)r).toString());
        return result;
    }

    public static String createDefaultJobHash(Job job) {
        Op jobOp = job.getOp();
        Op semanticJobOp = OpUtils.stripCache(jobOp);
        String result = ResourceTreeUtils.createGenericHash((RDFNode)semanticJobOp).toString();
        return result;
    }

    public static RdfDataPod executeJob(Op op) {
        HttpResourceRepositoryFromFileSystemImpl repo;
        Model core = op.getModel();
        Model copy = ModelFactory.createDefaultModel();
        copy.add(core);
        Op x = (Op)JenaPluginUtils.polymorphicCast((RDFNode)op.inModel(copy), Op.class);
        Job job = Job.create(copy);
        job.setOp(x);
        try {
            repo = HttpResourceRepositoryFromFileSystemImpl.createDefault();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        OpExecutorDefault catalogExecutor = new OpExecutorDefault(null, repo, TaskContext.empty(), new LinkedHashMap<String, Node>(), RDFFormat.TURTLE_PRETTY);
        RdfDataPod result = op.accept(catalogExecutor);
        return result;
    }

    public static DcatDataset executeJob(Job job, TaskContext taskContext, HttpResourceRepositoryFromFileSystem repo, ResourceStore cacheStore, ConjureFormatConfig formatConfig) {
        DcatDataset result;
        RDFFormat dataFormat = formatConfig.getDatasetFormat();
        RDFFormat provenanceFormat = formatConfig.getProvenanceFormat();
        Model resultModel = ModelFactory.createDefaultModel();
        String jobHash = ExecutionUtils.createDefaultJobHash(job);
        Resource inputRecord = taskContext.getInputRecord();
        String inputRecordId = ExecutionUtils.deriveId(inputRecord);
        String targetArtifactId = inputRecordId + "/" + jobHash;
        logger.info("Processing: " + String.valueOf(inputRecord));
        logger.info("  Target artifact id     : " + targetArtifactId);
        logger.info("  Input model size: " + inputRecord.getModel().size());
        logger.info("  Job model size  : " + job.getModel().size());
        try {
            Map.Entry<RdfHttpEntityFile, Model> dataEntry = ResourceStoreImpl.requestModel(repo, cacheStore, targetArtifactId + "/data", dataFormat, () -> {
                Model r;
                logger.info("No cache entry for " + String.valueOf(inputRecord) + "  Executing job ...");
                try (RdfDataPod tmp = ExecutionUtils.executeJob(job, repo, taskContext, inputRecord, dataFormat);){
                    r = tmp.getModel();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return r;
            });
            Model provModel = ResourceStoreImpl.requestModel(repo, cacheStore, targetArtifactId + "/dcat", provenanceFormat, () -> {
                Model r = ExecutionUtils.createProvenanceData(job, inputRecord).getModel();
                return r;
            }).getValue();
            ExecutionUtils.toPlaceholder(provModel, ExecutionUtils.prov("hadPlan"), "http://conjure.org/procenance/placeholder");
            resultModel.add(provModel);
            result = (DcatDataset)((Resource)provModel.listSubjectsWithProperty(RDF.type, (RDFNode)DCAT.Dataset).toList().get(0)).inModel(resultModel).as(DcatDataset.class);
            Set dists = result.getDistributionsAs(DcatDistribution.class);
            DcatDistribution dist = (DcatDistribution)resultModel.createResource().as(DcatDistribution.class);
            dists.add(dist);
            String downloadUrl = dataEntry.getKey().getAbsolutePath().toUri().toString();
            dist.setDownloadUrl(downloadUrl);
            logger.info("Download url: " + downloadUrl);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static RdfDataPod executeJob(Job job, HttpResourceRepositoryFromFileSystem repo, TaskContext taskContext, Resource inputRecord, RDFFormat persistRdfFormat) {
        Set<String> mentionedVars = OpUtils.mentionedVarNames(job.getOp());
        logger.debug("Mentioned vars: " + String.valueOf(mentionedVars));
        Map<String, Op> dataRefMapping = taskContext.getDataRefMapping();
        HashSet<String> unmatchedVars = new HashSet<String>(mentionedVars);
        unmatchedVars.removeAll(dataRefMapping.keySet());
        if (unmatchedVars.size() > 1) {
            throw new RuntimeException("Too many unmatched vars: " + String.valueOf(unmatchedVars));
        }
        if (unmatchedVars.size() == 1) {
            String unmatchedVarName = (String)unmatchedVars.iterator().next();
            if (dataRefMapping.size() == 1) {
                Op entry = dataRefMapping.values().iterator().next();
                dataRefMapping.put(unmatchedVarName, entry);
                logger.info("Autobind of " + unmatchedVarName + " to " + String.valueOf(entry));
            } else {
                throw new RuntimeException("Could not auto-bind var " + unmatchedVarName);
            }
        }
        Op effectiveWorkflow = job.getOp();
        LinkedHashMultimap valueMap = LinkedHashMultimap.create();
        FunctionAssembler assembler = new FunctionAssembler();
        for (JobBinding bspec : job.getJobBindings()) {
            String varName = bspec.getVarName();
            Var var = Var.alloc((String)varName);
            OpTraversal trav = bspec.getTraversal();
            Function<RDFNode, Set<RDFNode>> fn = trav.accept(assembler);
            Set<RDFNode> values = fn.apply((RDFNode)inputRecord);
            Iterator<RDFNode> iterator = values.iterator();
            while (iterator.hasNext()) {
                RDFNode value = iterator.next();
                Node node = value.asNode();
                valueMap.put((Object)var, (Object)node);
            }
        }
        ArrayList<Binding> currentBindings = new ArrayList<Binding>();
        currentBindings.add(BindingFactory.root());
        ArrayList<Binding> nextBindings = new ArrayList<Binding>();
        for (Map.Entry entry : valueMap.asMap().entrySet()) {
            Var k = (Var)entry.getKey();
            Collection vs = (Collection)entry.getValue();
            for (Node node : vs) {
                for (Binding cb : currentBindings) {
                    Binding nb = BindingFactory.binding((Binding)cb, (Var)k, (Node)node);
                    nextBindings.add(nb);
                }
            }
            ArrayList<Binding> xtmp = currentBindings;
            currentBindings = nextBindings;
            nextBindings = xtmp;
            nextBindings.clear();
        }
        if (currentBindings.isEmpty() || currentBindings.size() > 1) {
            throw new RuntimeException("Can only handle exactly a single binding at present");
        }
        Binding binding = (Binding)currentBindings.iterator().next();
        logger.info("Job Binding: " + String.valueOf(binding));
        logger.info("Conjure spec is:");
        RDFDataMgr.write((OutputStream)System.err, (Model)effectiveWorkflow.getModel(), (RDFFormat)RDFFormat.TURTLE_PRETTY);
        Map map = BindingUtils.toMap((Binding)binding);
        Map<String, Node> execCtx = map.entrySet().stream().collect(Collectors.toMap(e -> ((Var)e.getKey()).getName(), Map.Entry::getValue));
        OpExecutorDefault executor = new OpExecutorDefault(null, repo, taskContext, execCtx, persistRdfFormat);
        RdfDataPod resultDataPod = effectiveWorkflow.accept(executor);
        return resultDataPod;
    }

    public static void toPlaceholder(Model model, Property property, String placeholderUri) {
        Set<Resource> objects = ExecutionUtils.clear(model, property);
        for (Resource object : objects) {
            org.apache.jena.util.ResourceUtils.renameResource((Resource)object, (String)placeholderUri);
        }
    }

    public static Set<Resource> clear(Model model, Property property) {
        Set objects = ResourceUtils.listPropertyValues((Model)model, null, (Property)ExecutionUtils.prov("hadPlan"), Resource.class).toSet();
        for (Resource o : objects) {
            ResourceTreeUtils.clearSubTree(o);
        }
        return objects;
    }

    public static Resource createProvenanceData(Job job, Resource inputRecord) {
        Model resultModel = ModelFactory.createDefaultModel();
        Resource inputRecordX = inputRecord.inModel(resultModel.add(inputRecord.getModel()));
        Resource jobX = job.inModel(resultModel.add(job.getModel()));
        Resource resultDcat = resultModel.createResource().addProperty(RDF.type, (RDFNode)ExecutionUtils.prov("Entity")).addProperty(RDF.type, (RDFNode)DCAT.Dataset);
        Resource association = resultModel.createResource().addProperty(RDF.type, (RDFNode)ExecutionUtils.prov("Association")).addProperty(ExecutionUtils.prov("hadPlan"), (RDFNode)job);
        Resource activity = resultModel.createResource().addProperty(RDF.type, (RDFNode)ExecutionUtils.prov("Activity")).addProperty(ExecutionUtils.prov("qualifiedAssociation"), (RDFNode)association).addProperty(ExecutionUtils.prov("used"), (RDFNode)inputRecord).addProperty(ExecutionUtils.prov("used"), (RDFNode)job);
        resultDcat.addProperty(ExecutionUtils.prov("wasGeneratedBy"), (RDFNode)activity);
        return resultDcat;
    }

    public static Property prov(String name) {
        return ResourceFactory.createProperty((String)("http://www.w3.org/ns/prov#" + name));
    }
}

