/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.database;

import java.util.AbstractList;
import java.util.List;

class SubList<T>
extends AbstractList<T> {
    private List<T> original;
    private int beginIndex;
    private int endIndex;

    public SubList(List<T> original, int beginIndex) {
        this.original = original;
        this.beginIndex = beginIndex;
        this.endIndex = original.size();
    }

    public SubList(List<T> original, int beginIndex, int endIndex) {
        this.original = original;
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
    }

    public List<T> getOriginal() {
        return this.original;
    }

    @Override
    public T get(int index) {
        return this.original.get(this.beginIndex + index);
    }

    @Override
    public int size() {
        return this.endIndex - this.beginIndex;
    }

    @Override
    public SubList<T> subList(int beginIndex, int endIndex) {
        return new SubList<T>(this.original, this.beginIndex + beginIndex, this.beginIndex + beginIndex + endIndex);
    }

    public SubList<T> subList(int beginIndex) {
        return new SubList<T>(this.original, this.beginIndex + beginIndex, this.beginIndex + beginIndex + this.endIndex);
    }
}

