/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.views;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.UnaryOperator;
import org.aksw.commons.util.Pair;
import org.aksw.commons.util.reflect.MultiMethod;
import org.aksw.jena_sparql_api.views.Alignment;
import org.aksw.jena_sparql_api.views.E_RdfTerm;
import org.aksw.jena_sparql_api.views.InverseFunctionManager;
import org.aksw.jena_sparql_api.views.InverseFunctionManagerImpl;
import org.aksw.jena_sparql_api.views.SqlPrePusher;
import org.aksw.jena_sparql_api.views.SqlTranslationUtils;
import org.aksw.jenax.arq.util.expr.DnfUtils;
import org.apache.jena.sparql.engine.binding.BindingRoot;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.E_GreaterThan;
import org.apache.jena.sparql.expr.E_GreaterThanOrEqual;
import org.apache.jena.sparql.expr.E_LessThan;
import org.apache.jena.sparql.expr.E_LessThanOrEqual;
import org.apache.jena.sparql.expr.E_StrConcat;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprFunction;
import org.apache.jena.sparql.expr.ExprFunction2;
import org.apache.jena.sparql.expr.ExprLib;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.util.ExprUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class SqlExprOptimizer {
    public static Logger logger = LoggerFactory.getLogger(SqlExprOptimizer.class);
    public static Map<Class, Class> functionToInverse;
    private static InverseFunctionManager<Expr> inverseFunctionManager;

    public static Expr optimizeMM(Expr expr) {
        Expr result = (Expr)MultiMethod.invokeStatic(SqlExprOptimizer.class, (String)"optimize", (Object[])new Object[]{expr});
        result = result.copySubstitute(BindingRoot.create());
        result = ExprLib.foldConstants((Expr)result);
        Set dnf = DnfUtils.toSetDnf((Expr)result);
        result = DnfUtils.dnfToExpr((Set)dnf, (boolean)true);
        return result;
    }

    public static Expr optimize(Expr expr) {
        return expr;
    }

    public static Expr optimize(ExprFunction expr) {
        return expr;
    }

    public static List<Expr> optimizeList(List<Expr> exprs) {
        ArrayList<Expr> result = new ArrayList<Expr>();
        for (Expr expr : exprs) {
            result.add(expr == null ? null : SqlExprOptimizer.optimize(expr));
        }
        return result;
    }

    public static Expr optimize(ExprFunction2 expr) {
        return expr.copy(SqlExprOptimizer.optimizeMM(expr.getArg1()), SqlExprOptimizer.optimizeMM(expr.getArg2()));
    }

    public static Expr optimize(E_LessThan expr) {
        return SqlExprOptimizer.optimizeCompare((ExprFunction2)expr);
    }

    public static Expr optimize(E_LessThanOrEqual expr) {
        return SqlExprOptimizer.optimizeCompare((ExprFunction2)expr);
    }

    public static Expr optimize(E_GreaterThan expr) {
        return SqlExprOptimizer.optimizeCompare((ExprFunction2)expr);
    }

    public static Expr optimize(E_GreaterThanOrEqual expr) {
        return SqlExprOptimizer.optimizeCompare((ExprFunction2)expr);
    }

    public static Expr optimizeCompare(ExprFunction2 expr) {
        return SqlExprOptimizer.optimizeCompare(expr.getArg1(), expr.getArg2(), expr.getClass());
    }

    public static Expr optimizeCompare(Expr a, Expr b, Class<?> clazz) {
        BinaryOperator factory = (x, y) -> {
            try {
                Constructor<?> ctor = clazz.getConstructors()[0];
                return (Expr)ctor.newInstance(x, y);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        return SqlExprOptimizer.optimizeCompare(a, b, factory);
    }

    public static Expr optimizeCompare(Expr ea, Expr eb, BinaryOperator<Expr> factory) {
        Expr oa = SqlExprOptimizer.optimizeMM(ea);
        Expr ob = SqlExprOptimizer.optimizeMM(eb);
        E_RdfTerm a = SqlPrePusher.asRdfTerm(oa);
        E_RdfTerm b = SqlPrePusher.asRdfTerm(ob);
        if (a == null || b == null) {
            logger.warn("Arguments are no ExprRdfTerms");
            return (Expr)factory.apply(oa, ob);
        }
        NodeValue zero = NodeValue.makeInteger((long)0L);
        NodeValue one = NodeValue.makeInteger((long)1L);
        NodeValue two = NodeValue.makeInteger((long)2L);
        NodeValue three = NodeValue.makeInteger((long)3L);
        Expr result = org.aksw.jenax.arq.util.expr.ExprUtils.andifyBalanced((Expr[])new Expr[]{(Expr)factory.apply(a.getLexicalValue(), b.getLexicalValue())});
        return result;
    }

    public static <T> Pair<T, T> createPair(T a, T b, boolean swapArgs) {
        return swapArgs ? new Pair(b, a) : new Pair(a, b);
    }

    public static Pair<Expr, Expr> optimizeFunctionOpConstant(Expr a, Expr b) {
        NodeValue constant = null;
        ExprFunction function = null;
        boolean swapArgs = false;
        if (a.isConstant() && b.isFunction()) {
            constant = a.getConstant();
            function = b.getFunction();
        } else if (a.isFunction() && b.isConstant()) {
            function = a.getFunction();
            constant = b.getConstant();
            swapArgs = true;
        } else {
            return Pair.create((Object)a, (Object)b);
        }
        UnaryOperator<Expr> factory = inverseFunctionManager.getInverse(b.getFunction().getFunctionIRI());
        if (factory == null) {
            return Pair.create((Object)a, (Object)b);
        }
        Expr invConst = (Expr)factory.apply((Expr)constant);
        NodeValue resultConst = ExprUtils.eval((Expr)invConst);
        Expr resultFunc = function.getArg(1);
        return SqlExprOptimizer.createPair(resultConst, resultFunc, swapArgs);
    }

    public static Expr optimize(E_Equals expr) {
        Expr expr2 = SqlTranslationUtils.optimizeRdfTerm(expr = new E_Equals(SqlExprOptimizer.optimizeMM(expr.getArg1()), SqlExprOptimizer.optimizeMM(expr.getArg2())));
        if (expr2 != expr) {
            return SqlExprOptimizer.optimizeMM(expr2);
        }
        Expr result = SqlTranslationUtils.optimizeOpConcat((ExprFunction2)expr);
        if (result instanceof E_Equals) {
            result = SqlTranslationUtils.optimizeRdfTerm((E_Equals)result);
        }
        if (!result.equals((Object)expr)) {
            result = SqlExprOptimizer.optimizeMM(result);
        }
        return result;
    }

    public static List<Alignment> toAlignment(List<Expr> a, List<List<Expr>> bs) {
        ArrayList<Alignment> result = new ArrayList<Alignment>();
        for (List<Expr> b : bs) {
            result.add(new Alignment(a, b));
        }
        return result;
    }

    public static List<Alignment> align(List<Expr> a, List<Expr> b) {
        List<Alignment> result;
        ArrayList<List<Expr>> tmp = new ArrayList<List<Expr>>();
        if (a.size() > b.size()) {
            SqlExprOptimizer.alignRec(a, 0, b, 0, tmp);
            result = SqlExprOptimizer.toAlignment(a, tmp);
        } else if (a.size() < b.size()) {
            SqlExprOptimizer.alignRec(b, 0, a, 0, tmp);
            result = SqlExprOptimizer.toAlignment(b, tmp);
        } else {
            result = Collections.singletonList(new Alignment(a, b));
        }
        return result;
    }

    public static int indexOfFirstConstant(List<Expr> a, int offset) {
        for (int i = offset; i < a.size(); ++i) {
            Expr ea = a.get(i);
            if (!ea.isConstant()) continue;
            return i;
        }
        return -1;
    }

    public static List<Expr> copyReplace(List<Expr> a, int itemIndex, String[] parts) {
        int i;
        ArrayList<Expr> result = new ArrayList<Expr>(a.size() + parts.length - 1);
        for (i = 0; i < itemIndex; ++i) {
            result.add(a.get(i));
        }
        for (i = 0; i < parts.length; ++i) {
            result.add((Expr)NodeValue.makeString((String)parts[i]));
        }
        for (i = itemIndex + 1; i < a.size(); ++i) {
            result.add(a.get(i));
        }
        return result;
    }

    public static String[] split(String str, int i, int l) {
        int n = 1;
        if (i > 0) {
            ++n;
        }
        if (i + l < str.length()) {
            ++n;
        }
        String[] result = new String[n];
        int j = 0;
        if (i > 0) {
            result[j++] = str.substring(0, i);
        }
        result[j++] = str.substring(i, i + l);
        if (i + l < str.length()) {
            result[j++] = str.substring(i + l, str.length());
        }
        return result;
    }

    public static void alignRec(List<Expr> a, int oa, List<Expr> b, int ob, List<List<Expr>> result) {
        int i = SqlExprOptimizer.indexOfFirstConstant(a, oa);
        if (i < 0) {
            result.add(b);
            return;
        }
        Expr ea = a.get(i);
        String sa = ea.getConstant().asUnquotedString();
        block0: for (int j = ob; j < b.size(); ++j) {
            Expr eb = b.get(j);
            if (!eb.isConstant()) continue;
            String sb = eb.getConstant().asUnquotedString();
            int k = 0;
            while ((k = sb.indexOf(sa, k)) >= 0) {
                if (i == 0 && k != 0) continue;
                if (i == a.size() - 1 && k + sa.length() != sb.length()) continue block0;
                String[] parts = SqlExprOptimizer.split(sb, k, sa.length());
                List<Expr> subB = SqlExprOptimizer.copyReplace(b, j, parts);
                SqlExprOptimizer.alignRec(a, i + 1, subB, j + parts.length - 1, result);
                k += sa.length();
            }
        }
    }

    public static Expr optimizeEqualsConcat2(List<Expr> la, List<Expr> lb) {
        int i;
        Expr b;
        Expr a;
        int c;
        Expr b2;
        Expr a2 = la.get(0);
        if (a2.equals((Object)(b2 = lb.get(0)))) {
            la.remove(0);
            lb.remove(0);
        } else if (a2.isConstant() && b2.isConstant()) {
            String sb;
            String sa = a2.getConstant().asUnquotedString();
            if (sa.startsWith(sb = b2.getConstant().asUnquotedString())) {
                delta = sa.substring(sb.length());
                if (delta.isEmpty()) {
                    la.remove(0);
                } else {
                    la.set(0, (Expr)NodeValue.makeString((String)delta));
                }
                lb.remove(0);
            } else if (sb.startsWith(sa)) {
                delta = sb.substring(sa.length());
                if (delta.isEmpty()) {
                    lb.remove(0);
                } else {
                    lb.set(0, (Expr)NodeValue.makeString((String)delta));
                }
                la.remove(0);
                lb.set(0, (Expr)NodeValue.makeString((String)delta));
            }
        }
        int n = Math.min(la.size(), lb.size());
        boolean sameLength = la.size() == lb.size();
        for (c = 0; c < n && (a = la.get(c)).equals((Object)(b = lb.get(c))); ++c) {
        }
        if (sameLength) {
            if (c == n) {
                return NodeValue.TRUE;
            }
            if (c + 1 == n) {
                return new E_Equals(la.get(c), lb.get(c));
            }
        }
        if (c == 0) {
            if (lb.size() == 0) {
                throw new IndexOutOfBoundsException();
            }
            a = la.get(0);
            b = lb.get(0);
            if (a.isConstant() && b.isConstant()) {
                return NodeValue.FALSE;
            }
            return null;
        }
        ExprList na = new ExprList();
        ExprList nb = new ExprList();
        for (i = c; i < la.size(); ++i) {
            na.add(la.get(i));
        }
        for (i = c; i < lb.size(); ++i) {
            nb.add(lb.get(i));
        }
        return new E_Equals((Expr)new E_StrConcat(na), (Expr)new E_StrConcat(nb));
    }

    static {
        inverseFunctionManager = InverseFunctionManagerImpl.getInstance();
    }
}

