/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.views.index;

import java.util.function.Function;
import org.aksw.jena_sparql_api.views.index.QueryRewriter;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpAsQuery;

public class QueryRewriterOpRewrite
implements QueryRewriter {
    protected Function<Query, Op> queryToOp;
    protected Function<Op, Op> opRewriter;
    protected Function<Op, Query> opToQuery;

    public QueryRewriterOpRewrite(Function<Query, Op> queryToOp, Function<Op, Op> opRewriter, Function<Op, Query> opToQuery) {
        this.queryToOp = queryToOp;
        this.opRewriter = opRewriter;
        this.opToQuery = opToQuery;
    }

    public Function<Query, Op> getQueryToOp() {
        return this.queryToOp;
    }

    public Function<Op, Op> getOpRewriter() {
        return this.opRewriter;
    }

    public Function<Op, Query> getOpToQuery() {
        return this.opToQuery;
    }

    @Override
    public Query rewrite(Query query) {
        Op op = this.queryToOp.apply(query);
        Op rewrite = this.opRewriter.apply(op);
        Query result = this.opToQuery.apply(rewrite);
        return result;
    }

    public static QueryRewriterOpRewrite createDefault(Function<Op, Op> opRewriter) {
        QueryRewriterOpRewrite result = new QueryRewriterOpRewrite(Algebra::compile, opRewriter, OpAsQuery::asQuery);
        return result;
    }

    public static QueryRewriterOpRewrite createDefaultQuadForm(Function<Op, Op> opRewriter) {
        QueryRewriterOpRewrite result = new QueryRewriterOpRewrite(op -> Algebra.toQuadForm((Op)Algebra.compile((Query)op)), opRewriter, OpAsQuery::asQuery);
        return result;
    }
}

