/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.views;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.aksw.jena_sparql_api.views.ExprArgs;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprFunction;
import org.apache.jena.sparql.expr.ExprFunction0;
import org.apache.jena.sparql.expr.ExprFunction1;
import org.apache.jena.sparql.expr.ExprFunction2;
import org.apache.jena.sparql.expr.ExprFunction3;
import org.apache.jena.sparql.expr.ExprFunctionN;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;

public class ExprCopy {
    private static ExprCopy instance;

    public static ExprCopy getInstance() {
        if (instance == null) {
            instance = new ExprCopy();
        }
        return instance;
    }

    public Expr deepCopy(Expr proto) {
        Expr result;
        if (proto == null) {
            throw new NullPointerException();
        }
        if (proto.isConstant()) {
            result = this.deepCopy(proto.getConstant());
        } else if (proto.isFunction()) {
            result = this.deepCopy(proto.getFunction());
        } else if (proto.isVariable()) {
            result = this.deepCopy(proto.getExprVar());
        } else {
            throw new RuntimeException("Don't know how to copy " + String.valueOf(proto) + " of type " + String.valueOf(proto.getClass()));
        }
        return result;
    }

    public Expr deepCopy(NodeValue expr) {
        return expr;
    }

    public Expr deepCopy(ExprVar expr) {
        return expr;
    }

    public Expr deepCopy(ExprFunction fn) {
        List args = fn.getArgs();
        ArrayList<Expr> newArgs = new ArrayList<Expr>(args.size());
        for (Expr arg : args) {
            Expr newArg = this.deepCopy(arg);
            newArgs.add(newArg);
        }
        Expr result = this.deepCopy(fn, newArgs);
        return result;
    }

    public Expr deepCopy(ExprFunction proto, List<Expr> args) {
        Expr result = this.copy(proto, args);
        return result;
    }

    public Expr deepCopy(Expr proto, ExprList args) {
        return this.copy(proto, this.deepCopy(args));
    }

    public ExprList deepCopy(ExprList exprs) {
        ExprList result = new ExprList();
        for (Expr expr : exprs) {
            result.add(this.deepCopy(expr));
        }
        return result;
    }

    public Expr copy(Expr proto, Expr ... args) {
        List<Expr> list = Arrays.asList(args);
        return this.copy(proto, list);
    }

    public Expr copy(Expr proto, ExprList args) {
        return this.copy(proto, (List<Expr>)args.getList());
    }

    public Expr copy(Expr proto, List<Expr> args) {
        if (!proto.isFunction()) {
            throw new RuntimeException("Must not be called on non-functions");
        }
        ExprFunction fn = proto.getFunction();
        Expr result = this.copy(fn, args);
        return result;
    }

    public Expr copy(ExprFunction proto, List<Expr> args) {
        Expr result;
        if (proto == null) {
            throw new NullPointerException();
        }
        if (proto instanceof ExprFunction0) {
            result = this.copy((ExprFunction0)proto, args);
        } else if (proto instanceof ExprFunction1) {
            result = this.copy((ExprFunction1)proto, args);
        } else if (proto instanceof ExprFunction2) {
            result = this.copy((ExprFunction2)proto, args);
        } else if (proto instanceof ExprFunction3) {
            result = this.copy((ExprFunction3)proto, args);
        } else if (proto instanceof ExprFunctionN) {
            result = this.copy((ExprFunctionN)proto, args);
        } else {
            throw new RuntimeException("Don't know how to handle " + String.valueOf(proto) + " with type " + String.valueOf(proto.getClass()));
        }
        return result;
    }

    public Expr copy(Expr expr) {
        return this.copy(expr, ExprArgs.getArgs(expr));
    }

    public Expr copy(ExprFunction0 func, List<Expr> args) {
        return func.copy();
    }

    public Expr copy(ExprFunction1 func, List<Expr> args) {
        return func.copy(args.get(0));
    }

    public Expr copy(ExprFunction2 func, List<Expr> args) {
        return func.copy(args.get(0), args.get(1));
    }

    public Expr copy(ExprFunction3 func, List<Expr> args) {
        return func.copy(args.get(0), args.get(1), args.get(2));
    }

    public List<String> classNameList(Iterable<Class<?>> classes) {
        ArrayList<String> result = new ArrayList<String>();
        for (Class<?> clazz : classes) {
            result.add(clazz.getName());
        }
        return result;
    }

    public Expr copy(ExprFunctionN func, List<Expr> args) {
        ExprList exprList = new ExprList(args);
        try {
            Method m = func.getClass().getDeclaredMethod("copy", ExprList.class);
            m.setAccessible(true);
            Expr result = (Expr)m.invoke((Object)func, exprList);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

