/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.views;

import java.util.Objects;
import org.aksw.jena_sparql_api.restriction.RestrictionSetImpl;
import org.apache.jena.sparql.expr.Expr;

public class RestrictedExpr {
    private Expr expr;
    private RestrictionSetImpl restrictions;

    public RestrictedExpr(Expr expr) {
        this(expr, new RestrictionSetImpl());
    }

    public RestrictedExpr(Expr expr, RestrictionSetImpl restrictions) {
        this.expr = Objects.requireNonNull(expr);
        this.restrictions = restrictions;
    }

    public static RestrictedExpr create(Expr expr) {
        return new RestrictedExpr(expr);
    }

    public static RestrictedExpr create(Expr expr, RestrictionSetImpl restrictions) {
        return new RestrictedExpr(expr, restrictions);
    }

    public Expr getExpr() {
        return this.expr;
    }

    public RestrictionSetImpl getRestrictions() {
        return this.restrictions;
    }

    public String toString() {
        return "RestrictedExpr [expr=" + String.valueOf(this.expr) + ", restrictions=" + String.valueOf(this.restrictions) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
        result = 31 * result + (this.restrictions == null ? 0 : this.restrictions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RestrictedExpr other = (RestrictedExpr)obj;
        if (this.expr == null ? other.expr != null : !this.expr.equals((Object)other.expr)) {
            return false;
        }
        return !(this.restrictions == null ? other.restrictions != null : !this.restrictions.equals(other.restrictions));
    }
}

