/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.sparqlview;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.aksw.jena_sparql_api.restriction.RestrictionManagerImpl;
import org.aksw.jena_sparql_api.views.IViewDef;
import org.aksw.jena_sparql_api.views.ViewInstance;

public class ViewInstanceJoin<T extends IViewDef> {
    private ListMultimap<String, ViewInstance<T>> nameToInstances = ArrayListMultimap.create();
    private RestrictionManagerImpl restrictions;

    public List<String> getViewNames() {
        Collection<ViewInstance<T>> viewInstances = this.getViewInstances();
        ArrayList<String> result = new ArrayList<String>(viewInstances.size());
        for (ViewInstance<T> instance : viewInstances) {
            result.add(instance.getViewDefinition().getName());
        }
        return result;
    }

    public static <T extends IViewDef> ListMultimap<String, ViewInstance<T>> toMap(Collection<ViewInstance<T>> viewInstances) {
        ArrayListMultimap result = ArrayListMultimap.create();
        for (ViewInstance<T> viewInstance : viewInstances) {
            String viewName = viewInstance.getViewDefinition().getName();
            result.put((Object)viewName, viewInstance);
        }
        return result;
    }

    public ListMultimap<String, ViewInstance<T>> getInstancesGroupedByParent() {
        return this.nameToInstances;
    }

    public ViewInstanceJoin(List<ViewInstance<T>> viewInstances, RestrictionManagerImpl restrictions) {
        this(ViewInstanceJoin.toMap(viewInstances), restrictions);
    }

    public ViewInstanceJoin(ListMultimap<String, ViewInstance<T>> nameToInstances, RestrictionManagerImpl restrictions) {
        this.nameToInstances = nameToInstances;
        this.restrictions = restrictions;
    }

    public Collection<ViewInstance<T>> getViewInstances() {
        return this.nameToInstances.values();
    }

    public RestrictionManagerImpl getRestrictions() {
        return this.restrictions;
    }

    public String toString() {
        return String.valueOf(this.getViewInstances());
    }
}

