/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.database;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import org.aksw.commons.util.string.StringUtils;
import org.aksw.sparqlify.database.Constraint;
import org.aksw.sparqlify.database.EqualsConstraint;
import org.aksw.sparqlify.database.IsPrefixOfConstraint;
import org.aksw.sparqlify.database.MapStoreAccessor;
import org.aksw.sparqlify.database.StartsWithConstraint;

public class PrefixMapStoreAccessor
implements MapStoreAccessor {
    public static Set<Class<?>> supportedConstraintClasses = new HashSet();
    private int indexColumn;
    private Function<Object, Set<String>> prefixExtractor;

    @Override
    public Set<Class<?>> getSupportedConstraintClasses() {
        return supportedConstraintClasses;
    }

    public PrefixMapStoreAccessor(int[] indexColumns, Function<Object, Set<String>> prefixExtractor) {
        if (indexColumns.length != 1) {
            throw new RuntimeException("Prefix index can only operate on single columns");
        }
        this.indexColumn = indexColumns[0];
        this.prefixExtractor = prefixExtractor;
    }

    @Override
    public void put(Object store, List<?> row, Object value) {
        this.put((NavigableMap)store, row, value);
    }

    public void put(NavigableMap<String, Object> map, List<?> row, Object value) {
        map.put((String)row.get(this.indexColumn), value);
    }

    @Override
    public Collection<Object> lookup(Object store, Constraint constraint) {
        NavigableMap map = (NavigableMap)store;
        if (constraint instanceof IsPrefixOfConstraint) {
            return this.lookup((NavigableMap<String, Object>)map, (IsPrefixOfConstraint)constraint);
        }
        if (constraint instanceof StartsWithConstraint) {
            return this.lookup((NavigableMap<String, Object>)map, (StartsWithConstraint)constraint);
        }
        if (constraint instanceof EqualsConstraint) {
            return this.lookup((NavigableMap<String, Object>)map, (EqualsConstraint)constraint);
        }
        throw new RuntimeException("Could not handle constraint " + String.valueOf(constraint));
    }

    public Collection<Object> lookup(NavigableMap<String, Object> map, EqualsConstraint constraint) {
        return Collections.singleton(map.get(constraint.getValue()));
    }

    public Collection<Object> lookup(NavigableMap<String, Object> map, StartsWithConstraint constraint) {
        return StringUtils.getAllPrefixedEntries((String)constraint.getPrefix(), (boolean)constraint.isInclusive(), map).values();
    }

    public Collection<Object> lookup(NavigableMap<String, Object> map, IsPrefixOfConstraint constraint) {
        return StringUtils.getAllPrefixes((String)constraint.getValue(), (boolean)constraint.isInclusive(), map).values();
    }

    @Override
    public Object get(Object store, List<Object> row) {
        return this.get((NavigableMap)store, row);
    }

    public Object get(NavigableMap<String, Object> map, List<Object> row) {
        return map.get(row.get(this.indexColumn));
    }

    @Override
    public Collection<Object> list(Object store) {
        return ((NavigableMap)store).values();
    }

    @Override
    public Object createStore() {
        return new TreeMap();
    }

    static {
        supportedConstraintClasses.add(EqualsConstraint.class);
        supportedConstraintClasses.add(StartsWithConstraint.class);
        supportedConstraintClasses.add(IsPrefixOfConstraint.class);
    }
}

