/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.views.index;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aksw.commons.collections.CartesianProduct;
import org.aksw.commons.util.string.StringUtils;
import org.aksw.jena_sparql_api.views.index.CandidateViewSelector;
import org.aksw.jena_sparql_api.views.index.QuadPrefixes;
import org.aksw.jenax.arq.util.expr.DnfUtils;
import org.aksw.jenax.arq.util.expr.ExprUtils;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.sparqlify.database.Constraint;
import org.aksw.sparqlify.database.IndexMetaNode;
import org.aksw.sparqlify.database.IsPrefixOfConstraint;
import org.aksw.sparqlify.database.MetaIndexFactory;
import org.aksw.sparqlify.database.PrefixIndexMetaFactory;
import org.aksw.sparqlify.database.Table;
import org.aksw.sparqlify.database.TableBuilder;
import org.aksw.sparqlify.database.TreeIndex;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprVars;
import org.apache.jena.sparql.expr.NodeValue;

public class CandidateViewSelectorImpl<V>
implements CandidateViewSelector<Map.Entry<QuadPrefixes, V>> {
    public static final String[] COLUMN_NAMES = new String[]{"g_prefix", "s_prefix", "p_prefix", "o_prefix"};
    protected Table<Object> table = CandidateViewSelectorImpl.createDefaultTable();
    protected boolean validateConstraintExpr = true;

    public static Table<Object> createDefaultTable() {
        TableBuilder<Object> builder = new TableBuilder<Object>();
        builder.addColumn("g_prefix", String.class);
        builder.addColumn("s_prefix", String.class);
        builder.addColumn("p_prefix", String.class);
        builder.addColumn("o_prefix", String.class);
        builder.addColumn("o_type", Integer.class);
        builder.addColumn("value", Object.class);
        Table<Object> result = builder.create();
        Function<Object, Set<String>> prefixExtractor = input -> Collections.singleton(input.toString());
        PrefixIndexMetaFactory factory = new PrefixIndexMetaFactory(prefixExtractor);
        IndexMetaNode root = IndexMetaNode.create(result, (MetaIndexFactory)factory, "s_prefix");
        IndexMetaNode s = IndexMetaNode.create(root, (MetaIndexFactory)factory, "p_prefix");
        TreeIndex.attach(result, root);
        IndexMetaNode root2 = IndexMetaNode.create(result, (MetaIndexFactory)factory, "p_prefix");
        IndexMetaNode s2 = IndexMetaNode.create(root2, (MetaIndexFactory)factory, "s_prefix");
        TreeIndex.attach(result, root2);
        return result;
    }

    public static String mostSpecificSubstring(String a, String b) {
        int n;
        int m = a.length();
        boolean isALonger = m > (n = b.length());
        String result = isALonger ? CandidateViewSelectorImpl.mostSpecificSubstring2(a, b) : CandidateViewSelectorImpl.mostSpecificSubstring2(b, a);
        return result;
    }

    public static String mostSpecificSubstring2(String a, String b) {
        String result = a.startsWith(b) ? a : null;
        return result;
    }

    public static String lessSpecificSubstring(String a, String b) {
        int n;
        int m = a.length();
        boolean isAShorter = m < (n = b.length());
        String result = isAShorter ? CandidateViewSelectorImpl.lessSpecificSubstring2(a, b) : CandidateViewSelectorImpl.lessSpecificSubstring2(b, a);
        return result;
    }

    public static String lessSpecificSubstring2(String a, String b) {
        String result = b.startsWith(a) ? a : null;
        return result;
    }

    public static NavigableSet<String> intersectPrefixes(NavigableSet<String> as, NavigableSet<String> bs) {
        NavigableSet result = Stream.concat(as.stream().filter(a -> StringUtils.longestPrefixLookup((String)a, (NavigableSet)bs) != null), bs.stream().filter(b -> StringUtils.longestPrefixLookup((String)b, (NavigableSet)as) != null)).collect(Collectors.toCollection(TreeSet::new));
        return result;
    }

    public static NavigableSet<String> unionPrefixes(NavigableSet<String> as, NavigableSet<String> bs) {
        NavigableSet result = Stream.concat(as.stream().filter(a -> StringUtils.longestPrefixLookup((String)a, (NavigableSet)bs) == null), bs.stream().filter(b -> StringUtils.longestPrefixLookup((String)b, (NavigableSet)as) == null)).collect(Collectors.toCollection(TreeSet::new));
        return result;
    }

    public static void validateConstraintExpr(Expr expr) {
        Set exprVars = ExprVars.getVarsMentioned((Expr)expr);
        boolean isValid = Vars.gspo.containsAll(exprVars);
        if (!isValid) {
            throw new RuntimeException("Constraint expressions may only use the variables g, s, p, and o");
        }
    }

    public void put(QuadPrefixes decl, V value) {
        AbstractMap.SimpleEntry<QuadPrefixes, V> entry = new AbstractMap.SimpleEntry<QuadPrefixes, V>(decl, value);
        ArrayList<Set<Object>> columnValues = new ArrayList<Set<Object>>(6);
        for (int i = 0; i < 4; ++i) {
            Set<String> prefixes = (Set<String>)decl.getPrefixes().get(i);
            if (prefixes == null) {
                prefixes = Collections.singleton("");
            }
            columnValues.add(prefixes);
        }
        Set<Integer> termTypes = decl.isMayBeObjectResource() ? (decl.isMayBeObjectLiteral() ? Arrays.asList(1, 2) : Collections.singleton(1)) : (decl.isMayBeObjectLiteral() ? Collections.singleton(2) : null);
        columnValues.add(termTypes);
        CartesianProduct cartesian = CartesianProduct.create(columnValues);
        for (List item : cartesian) {
            ArrayList<AbstractMap.SimpleEntry<QuadPrefixes, V>> row = new ArrayList<AbstractMap.SimpleEntry<QuadPrefixes, V>>(item);
            row.add(entry);
            this.table.add(row);
        }
    }

    public Multimap<Var, Expr> indexExprsByVar(Set<Expr> exprs) {
        HashMultimap result = HashMultimap.create();
        for (Expr expr : exprs) {
            Set exprVars = ExprVars.getVarsMentioned((Expr)expr);
            if (exprVars.size() != 1) continue;
            Var var = (Var)Iterables.getFirst((Iterable)exprVars, null);
            result.put((Object)var, (Object)expr);
        }
        return result;
    }

    public Map<String, Constraint> inferColumnConstraints(Set<Expr> dnfClause) {
        HashMap<String, Constraint> result = new HashMap<String, Constraint>();
        Multimap<Var, Expr> varToExprs = this.indexExprsByVar(dnfClause);
        for (int i = 0; i < 4; ++i) {
            Var var = (Var)Vars.gspo.get(i);
            String columnName = COLUMN_NAMES[i];
            Collection exprs = varToExprs.get((Object)var);
            for (Expr expr : exprs) {
                Node node;
                Map.Entry e = ExprUtils.extractConstantConstraint((Expr)expr);
                if (e == null || !(node = ((NodeValue)e.getValue()).asNode()).isURI()) continue;
                result.put(columnName, new IsPrefixOfConstraint(node.getURI()));
            }
        }
        return result;
    }

    @Override
    public Collection<Map.Entry<QuadPrefixes, V>> apply(Expr expr) {
        Set dnf = DnfUtils.toSetDnf((Expr)expr);
        LinkedHashSet<Map.Entry<QuadPrefixes, V>> result = new LinkedHashSet<Map.Entry<QuadPrefixes, V>>();
        for (Set clause : dnf) {
            Map<String, Constraint> columnConstraints = this.inferColumnConstraints(clause);
            if (columnConstraints == null) continue;
            int valueIndex = this.table.getColumns().size() - 1;
            Collection<List<Object>> rows = this.table.select(columnConstraints);
            List matches = rows.stream().map(row -> (Map.Entry)row.get(valueIndex)).collect(Collectors.toList());
            result.addAll(matches);
        }
        return result;
    }
}

