/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.database;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import org.aksw.commons.util.string.StringUtils;
import org.aksw.sparqlify.database.Constraint;
import org.aksw.sparqlify.database.Index;
import org.aksw.sparqlify.database.IndexMetaNode;
import org.aksw.sparqlify.database.Table;

public class PrefixIndex<T>
implements Index<T> {
    private Table<T> table;
    private int[] indexColumns;
    private List<String> indexColumnNames;
    private Function<T, Set<String>> prefixExtractor;
    private NavigableMap<String, Object> map = new TreeMap<String, Object>();

    public PrefixIndex(Table<T> table, int[] indexColumns, Function<T, Set<String>> prefixExtractor) {
        this.table = table;
        this.indexColumns = indexColumns;
        this.prefixExtractor = prefixExtractor;
        this.indexColumnNames = new ArrayList<String>();
        for (int index : indexColumns) {
            this.indexColumnNames.add(table.getColumns().getKey(index));
        }
    }

    public void index(String ... row) {
    }

    @Override
    public void add(List<? extends T> row) {
        TreeMap<String, Cloneable> current = this.map;
        for (int i = 0; i < this.indexColumns.length; ++i) {
            boolean isLast = i == this.indexColumns.length - 1;
            int index = this.indexColumns[i];
            T value = row.get(index);
            Set<String> prefixes = this.prefixExtractor.apply(value);
            for (String prefix : prefixes) {
                Object o = current.get(prefix);
                if (isLast) {
                    HashSet<List<T>> values = (HashSet<List<T>>)o;
                    if (values == null) {
                        values = new HashSet<List<T>>();
                        current.put(prefix, values);
                    }
                    values.add(row);
                    continue;
                }
                TreeMap<String, Cloneable> next = (TreeMap<String, Cloneable>)o;
                if (next == null) {
                    next = new TreeMap<String, Cloneable>();
                    current.put(prefix, next);
                }
                current = next;
            }
        }
    }

    public void lookup(Constraint ... constraints) {
    }

    public Collection<List<T>> lookupSimple(List<String> prefixList) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        this.lookupSimple(prefixList, 0, this.map, result);
        return result;
    }

    public Collection<List<T>> lookupSimpleLonger(List<String> prefixList) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        this.lookupSimpleLonger(prefixList, 0, this.map, result);
        return result;
    }

    public void lookupSimple(List<String> prefixList, int i, Object tmp, Collection<List<T>> result) {
        boolean isLast;
        boolean bl = isLast = i == prefixList.size();
        if (isLast) {
            this.lookupRemaining(tmp, i, result);
        } else {
            NavigableMap current = (NavigableMap)tmp;
            String prefix = prefixList.get(i);
            Map candidates = StringUtils.getAllPrefixes((String)prefix, (boolean)true, (NavigableMap)current);
            for (Map.Entry entry : candidates.entrySet()) {
                Object next = entry.getValue();
                this.lookupSimple(prefixList, i + 1, next, result);
            }
        }
    }

    public void lookupSimpleLonger(List<String> prefixList, int i, NavigableMap<String, Object> current, Collection<List<T>> result) {
        boolean isLast;
        boolean bl = isLast = i == prefixList.size();
        if (isLast) {
            this.lookupRemaining(current, i, result);
        } else {
            int index = this.indexColumns[i];
            String prefix = prefixList.get(index);
            Map candidates = StringUtils.getAllPrefixedEntries((String)prefix, (boolean)true, current);
            for (Map.Entry entry : candidates.entrySet()) {
                NavigableMap next = (NavigableMap)entry.getValue();
                this.lookupSimpleLonger(prefixList, i + 1, next, result);
            }
        }
    }

    public void lookupRemaining(Object tmp, int i, Collection<List<T>> result) {
        boolean isLast = i == this.indexColumns.length - 1;
        int index = this.indexColumns[i];
        if (isLast) {
            Set current = (Set)tmp;
            result.addAll(current);
        } else {
            NavigableMap current = (NavigableMap)tmp;
            for (Object o : current.values()) {
                NavigableMap next = (NavigableMap)o;
                this.lookupRemaining(next, i + 1, result);
            }
        }
    }

    public Collection<List<T>> lookup(List<Set<String>> prefixesList) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        this.lookup(prefixesList, 0, this.map, result);
        return result;
    }

    public void lookup(List<Set<String>> prefixesList, int i, NavigableMap<String, Object> current, Collection<List<T>> result) {
        boolean isLast = i == this.indexColumns.length - 1;
        int index = this.indexColumns[i];
        Set<String> prefixes = prefixesList.get(index);
        for (String prefix : prefixes) {
            Object o = current.get(prefix);
            if (isLast) {
                if (o == null) {
                    return;
                }
                List row = (List)o;
                result.add(row);
                continue;
            }
            NavigableMap next = (NavigableMap)o;
            if (next == null) {
                return;
            }
            this.lookup(prefixesList, i + 1, next, result);
        }
    }

    public static <T> PrefixIndex<T> attach(Function<T, Set<String>> prefixExtractor, Table<T> table, String ... columnNames) {
        List<String> names = Arrays.asList(columnNames);
        HashSet<String> nameSet = new HashSet<String>(names);
        Sets.SetView dangling = Sets.difference(nameSet, table.getColumns().keySet());
        if (!dangling.isEmpty()) {
            throw new RuntimeException("Columns " + String.valueOf(dangling) + " referenced, but not present in table");
        }
        int[] indexColumns = new int[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            Integer index = table.getColumns().getIndex(columnNames[i]);
            if (index == null) {
                throw new NullPointerException("Column name does not have an index");
            }
            indexColumns[i] = index;
        }
        PrefixIndex<T> index = new PrefixIndex<T>(table, indexColumns, prefixExtractor);
        table.addIndex(index);
        return index;
    }

    @Override
    public boolean preAdd(List<? extends T> row) {
        return true;
    }

    @Override
    public void postAdd(List<? extends T> row) {
    }

    @Override
    public Table<T> getTable() {
        return this.table;
    }

    @Override
    public int[] getIndexColumns() {
        return this.indexColumns;
    }

    @Override
    public List<String> getIndexColumnNames() {
        return this.indexColumnNames;
    }

    public String toString() {
        return "PrefixIndex [table=" + String.valueOf(this.table) + ", indexColumnNames=" + String.valueOf(this.indexColumnNames) + "]";
    }

    @Override
    public IndexMetaNode getRoot() {
        return null;
    }

    @Override
    public Object getStore() {
        return null;
    }
}

