/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.views;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.aksw.jena_sparql_api.views.IViewDef;
import org.aksw.jena_sparql_api.views.RestrictedExpr;
import org.aksw.jena_sparql_api.views.VarBinding;
import org.aksw.jena_sparql_api.views.VarDefinition;
import org.apache.jena.sparql.core.Var;

public class ViewInstance<T extends IViewDef> {
    private T viewDefinition;
    private VarBinding binding;

    public ViewInstance(T viewDefinition, VarBinding binding) {
        this.viewDefinition = viewDefinition;
        this.binding = binding;
    }

    public T getViewDefinition() {
        return this.viewDefinition;
    }

    public VarBinding getBinding() {
        return this.binding;
    }

    public Set<RestrictedExpr> getDefinitionsForViewVariable(Var viewVar) {
        Collection<RestrictedExpr> defs = this.viewDefinition.getVarDefinition().getDefinitions(viewVar);
        HashSet<RestrictedExpr> result = new HashSet<RestrictedExpr>(defs);
        return result;
    }

    public VarDefinition getVarDefinition() {
        return this.viewDefinition.getVarDefinition();
    }

    public String toString() {
        String result = "ViewInstance for " + this.viewDefinition.getName() + ", binding: " + String.valueOf(this.binding);
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.binding == null ? 0 : this.binding.hashCode());
        result = 31 * result + (this.viewDefinition == null ? 0 : this.viewDefinition.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ViewInstance other = (ViewInstance)obj;
        if (this.binding == null ? other.binding != null : !this.binding.equals(other.binding)) {
            return false;
        }
        return !(this.viewDefinition == null ? other.viewDefinition != null : !this.viewDefinition.equals(other.viewDefinition));
    }
}

