/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.views;

import java.util.HashMap;
import java.util.Map;
import org.aksw.commons.util.reflect.MultiMethod;
import org.aksw.jena_sparql_api.views.ExprCopy;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.ExprFunction;
import org.apache.jena.sparql.expr.ExprFunctionOp;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.aggregate.Aggregator;

public class NodeExprSubstitutor {
    private Map<? extends Node, ? extends Expr> map;

    public static NodeExprSubstitutor create(Map<String, Expr> varNameToExpr) {
        HashMap<Var, Expr> tmp = new HashMap<Var, Expr>();
        for (Map.Entry<String, Expr> entry : varNameToExpr.entrySet()) {
            tmp.put(Var.alloc((String)entry.getKey()), entry.getValue());
        }
        NodeExprSubstitutor result = new NodeExprSubstitutor(tmp);
        return result;
    }

    public NodeExprSubstitutor(Map<? extends Node, ? extends Expr> map) {
        this.map = map;
    }

    public ExprList transformMM(ExprList exprs) {
        ExprList result = new ExprList();
        for (Expr expr : exprs) {
            Expr item = this.transformMM(expr);
            result.add(expr);
        }
        return result;
    }

    public Expr transformMM(Expr expr) {
        return expr == null ? null : (Expr)MultiMethod.invoke((Object)this, (String)"_transform", (Object[])new Object[]{expr});
    }

    public Expr _transform(ExprFunction expr) {
        ExprList args = this.transformList(expr.getArgs());
        Expr result = ExprCopy.getInstance().copy((Expr)expr, args);
        return result;
    }

    public ExprList transformList(Iterable<Expr> exprs) {
        ExprList result = new ExprList();
        for (Expr expr : exprs) {
            result.add(this.transformMM(expr));
        }
        return result;
    }

    public Expr _transform(ExprFunctionOp funcOp, ExprList args, Op opArg) {
        throw new UnsupportedOperationException();
    }

    public Expr _transform(NodeValue nv) {
        return nv;
    }

    public Expr _transform(ExprVar nv) {
        Expr tmp = this.map.get(nv.asVar());
        return tmp != null ? tmp : nv;
    }

    public Expr _transform(ExprAggregator eAgg) {
        ExprList newAggExpr = this.transformMM(eAgg.getAggregator().getExprList());
        Aggregator newAgg = eAgg.getAggregator().copy(newAggExpr);
        Expr newAggVar = this.transformMM((Expr)eAgg.getAggVar());
        ExprAggregator result = new ExprAggregator(newAggVar.asVar(), newAgg);
        return result;
    }
}

