/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.database;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aksw.sparqlify.database.MapStoreAccessor;
import org.aksw.sparqlify.database.MetaIndexFactory;
import org.aksw.sparqlify.database.Table;

public class IndexMetaNode {
    private IndexMetaNode parent;
    private Table table;
    private List<String> columnNames;
    private MapStoreAccessor factory;
    private Map<List<String>, List<IndexMetaNode>> subIndexes = new HashMap<List<String>, List<IndexMetaNode>>();
    private List<IndexMetaNode> children = new ArrayList<IndexMetaNode>();

    public List<IndexMetaNode> getChildren() {
        return this.children;
    }

    public Map<List<String>, List<IndexMetaNode>> getSubIndexes() {
        return this.subIndexes;
    }

    public IndexMetaNode(Table table, List<String> columnNames, MapStoreAccessor factory) {
        this.parent = null;
        this.table = table;
        this.columnNames = columnNames;
        this.factory = factory;
    }

    public IndexMetaNode(IndexMetaNode parent, List<String> columnNames, MapStoreAccessor factory) {
        this.parent = parent;
        this.table = parent.getTable();
        this.columnNames = columnNames;
        this.factory = factory;
        List<IndexMetaNode> list = parent.subIndexes.get(columnNames);
        if (list == null) {
            list = new ArrayList<IndexMetaNode>();
            parent.subIndexes.put(columnNames, list);
        }
        list.add(this);
        parent.children.add(this);
    }

    public IndexMetaNode getParent() {
        return this.parent;
    }

    public Table getTable() {
        return this.table;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public MapStoreAccessor getFactory() {
        return this.factory;
    }

    public void addSubIndex(IndexMetaNode subIndex) {
    }

    public static IndexMetaNode create(Table table, MetaIndexFactory factory, String ... columns) {
        MapStoreAccessor f = factory.create(table, Arrays.asList(columns));
        return new IndexMetaNode(table, Arrays.asList(columns), f);
    }

    public static IndexMetaNode create(IndexMetaNode parent, MetaIndexFactory factory, String ... columns) {
        MapStoreAccessor f = factory.create(parent.getTable(), Arrays.asList(columns));
        return new IndexMetaNode(parent, Arrays.asList(columns), f);
    }

    public String toString() {
        return "IndexMetaNode [columnNames=" + String.valueOf(this.columnNames) + "]";
    }
}

