/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.views;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.collections.MapUtils;
import org.aksw.commons.collections.multimaps.ISetMultimap;
import org.aksw.jena_sparql_api.views.EquiMap;
import org.aksw.jenax.arq.util.quad.QuadUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;

public class TwoWayBinding {
    private EquiMap<Var, Node> equiMap = new EquiMap();

    public Set<Var> keySet() {
        return Sets.union(this.equiMap.getEquivalences().asMap().keySet(), this.equiMap.getKeyToValue().keySet());
    }

    public TwoWayBinding copySubstitute(Map<? extends Node, Node> map) {
        Var newKey;
        TwoWayBinding result = new TwoWayBinding();
        for (Map.Entry entry : this.equiMap.getEquivalences().asMap().entrySet()) {
            newKey = map == null ? (Var)entry.getKey() : (Var)MapUtils.getOrElse(map, (Object)((Node)entry.getKey()), (Object)((Node)entry.getKey()));
            for (Var item : (Collection)entry.getValue()) {
                Var newValue = map == null ? item : (Var)MapUtils.getOrElse(map, (Object)item, (Object)item);
                result.getEquiMap().getEquivalences().put((Object)newKey, (Object)newValue);
            }
        }
        for (Map.Entry<Object, Object> entry : this.equiMap.getKeyToValue().entrySet()) {
            newKey = map == null ? (Var)entry.getKey() : (Var)MapUtils.getOrElse(map, (Object)((Node)entry.getKey()), (Object)((Node)entry.getKey()));
            Node newValue = map == null ? (Node)entry.getValue() : (Node)MapUtils.getOrElse(map, (Object)((Node)entry.getValue()), (Object)((Node)entry.getValue()));
            result.getEquiMap().getKeyToValue().put(newKey, newValue);
        }
        return result;
    }

    public void clear() {
        this.equiMap.clear();
    }

    public EquiMap<Var, Node> getEquiMap() {
        return this.equiMap;
    }

    public boolean put(Var a, Node b) {
        if (this.equiMap.isConsistentInsertValue(a, b)) {
            this.equiMap.put(a, b);
            return true;
        }
        return false;
    }

    public boolean makeEqual(Var a, Var b) {
        if (this.equiMap.isConsistentInsertEquiv(a, b)) {
            this.equiMap.makeEqual(a, b);
            return true;
        }
        return false;
    }

    public boolean add(Node a, Node b) {
        if (a.isVariable() && b.isVariable()) {
            return this.makeEqual((Var)a, (Var)b);
        }
        if (a.isVariable() && b.isConcrete()) {
            return this.put((Var)a, b);
        }
        if (a.isConcrete() && b.isVariable()) {
            return this.put((Var)b, a);
        }
        if (a.isConcrete() && b.isConcrete()) {
            return a.equals((Object)b);
        }
        throw new RuntimeException("Should not happen.");
    }

    public void addAll(TwoWayBinding other) {
        this.equiMap.getEquivalences().putAll(other.getEquiMap().getEquivalences());
        this.equiMap.getKeyToValue().putAll(other.getEquiMap().getKeyToValue());
    }

    public String toString() {
        return this.equiMap.toString();
    }

    public boolean isCompatible(TwoWayBinding other) {
        return this.equiMap.isCompatible(other.getEquiMap());
    }

    public static TwoWayBinding getVarMappingTwoWay(Quad a, Quad b) {
        TwoWayBinding result = new TwoWayBinding();
        List nAs = QuadUtils.quadToList((Quad)a);
        List nBs = QuadUtils.quadToList((Quad)b);
        for (int i = 0; i < 4; ++i) {
            Node nB;
            Node nA = (Node)nAs.get(i);
            if (result.add(nA, nB = (Node)nBs.get(i))) continue;
            return null;
        }
        return result;
    }

    public Set<Var> getQueryVariables() {
        return this.equiMap.getEquivalences().asMap().keySet();
    }

    public ISetMultimap<Var, Var> getVariableMap() {
        return this.equiMap.getEquivalences();
    }

    public Map<Var, Node> getConstantMap() {
        return this.equiMap.getKeyToValue();
    }

    public Set<Var> getViewVariablesForQueryVariable(Var queryVar) {
        return this.equiMap.getEquivalences().get((Object)queryVar);
    }

    public Set<Var> getViewVariables() {
        return this.equiMap.getEquivalences().getInverse().asMap().keySet();
    }
}

