/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.restriction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.jena_sparql_api.exprs_ext.E_StrConcatPermissive;
import org.aksw.jena_sparql_api.normal_form.Clause;
import org.aksw.jena_sparql_api.normal_form.NestedNormalForm;
import org.aksw.jena_sparql_api.restriction.RestrictionImpl;
import org.aksw.jena_sparql_api.restriction.RestrictionManager;
import org.aksw.jena_sparql_api.views.PrefixSet;
import org.aksw.jena_sparql_api.views.RdfTermType;
import org.aksw.jenax.arq.util.expr.CnfUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.E_LogicalNot;
import org.apache.jena.sparql.expr.E_StrConcat;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprFunction;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.util.ExprUtils;

public class RestrictionManagerImpl
implements RestrictionManager {
    private RestrictionManagerImpl parent;
    private HashMap<Var, RestrictionImpl> restrictions = new HashMap();
    private NestedNormalForm cnf;
    private Map<Expr, RestrictionImpl> exprToRestriction = new HashMap<Expr, RestrictionImpl>();
    private Map<Var, Node> binding = new HashMap<Var, Node>();
    private BindingBuilder bindingBuilder = BindingFactory.builder();
    private Boolean satisfiability = Boolean.TRUE;

    public RestrictionManagerImpl() {
        this.cnf = new NestedNormalForm(null, false);
        this.satisfiability = Boolean.TRUE;
    }

    public RestrictionManagerImpl(RestrictionManagerImpl parent) {
        this.parent = parent;
        this.cnf = new NestedNormalForm(parent.getCnf(), true);
    }

    public RestrictionManagerImpl(NestedNormalForm cnf) {
        this.cnf = cnf;
        this.deriveRestrictions(cnf);
    }

    public NestedNormalForm getCnf() {
        return this.cnf;
    }

    public Boolean getSatisfiability() {
        return this.satisfiability;
    }

    public static RestrictionImpl deriveRestriction(Expr expr) {
        if (expr instanceof E_StrConcat || expr instanceof E_StrConcatPermissive) {
            return RestrictionManagerImpl.deriveRestriction(expr);
        }
        if (expr.isConstant()) {
            RestrictionImpl result = new RestrictionImpl();
            result.stateNode(expr.getConstant().asNode());
            return result;
        }
        return null;
    }

    public static RestrictionImpl deriveRestriction(E_StrConcat expr) {
        return RestrictionManagerImpl.deriveRestrictionConcat((ExprFunction)expr);
    }

    public static RestrictionImpl deriveRestriction(E_StrConcatPermissive expr) {
        return RestrictionManagerImpl.deriveRestrictionConcat((ExprFunction)expr);
    }

    public static RestrictionImpl deriveRestrictionConcat(ExprFunction concat) {
        Expr arg;
        Object prefix = "";
        Iterator iterator = concat.getArgs().iterator();
        while (iterator.hasNext() && (arg = (Expr)iterator.next()).isConstant()) {
            prefix = (String)prefix + arg.getConstant().asUnquotedString();
        }
        RestrictionImpl result = new RestrictionImpl();
        result.stateUriPrefixes(new PrefixSet(new String[]{prefix}));
        return result;
    }

    public void deriveRestrictions(Set<Clause> cnf) {
        for (Clause clause : cnf) {
            if (clause.getExprs().size() != 1) continue;
            for (Map.Entry<Var, RestrictionImpl> entry : clause.getRestrictions().entrySet()) {
                this.stateRestriction(entry.getKey(), entry.getValue());
            }
        }
    }

    public boolean stateRestriction(Var var, RestrictionImpl restriction) {
        RestrictionImpl r = this.getOrCreateLocalRestriction(var);
        if (r.stateRestriction(restriction)) {
            if (r.isUnsatisfiable()) {
                this.satisfiability = Boolean.FALSE;
            } else {
                this.check(var);
            }
            return true;
        }
        return false;
    }

    public Set<Clause> getClausesForVar(Var var) {
        return this.getClausesForVars(Collections.singleton(var));
    }

    public Set<Clause> getClausesForVars(Collection<Var> vars) {
        HashSet<Clause> result = new HashSet<Clause>();
        for (Var var : vars) {
            Set<Clause> tmp = this.cnf.getClausesByVar(var);
            if (tmp == null) continue;
            result.addAll(tmp);
        }
        return result;
    }

    public void check(Var var) {
        Set<Clause> clauses = this.cnf.getClausesByVar(var);
        if (clauses != null) {
            this.checkClauses(clauses);
        }
    }

    public void checkClauses(Collection<Clause> clauses) {
        for (Clause clause : clauses) {
            this.check(clause);
            if (this.satisfiability != Boolean.FALSE) continue;
            return;
        }
    }

    public void check(Clause clause) {
        for (Expr expr : clause.getExprs()) {
            Boolean satisfiability = this.determineSatisfiability(expr);
            if (satisfiability != null && satisfiability != Boolean.TRUE) continue;
            return;
        }
        this.satisfiability = Boolean.FALSE;
    }

    @Override
    public Boolean determineSatisfiability(Expr expr) {
        if (this.binding.keySet().containsAll(expr.getVarsMentioned())) {
            try {
                NodeValue value = ExprUtils.eval((Expr)expr, (Binding)this.bindingBuilder.build());
                return value.getBoolean();
            }
            catch (Exception e) {
                System.err.println(e);
                return null;
            }
        }
        if (expr instanceof E_LogicalNot) {
            Boolean tmp = this.determineSatisfiability(((E_LogicalNot)expr).getArg());
            return tmp == null ? null : Boolean.valueOf(tmp == false);
        }
        if (expr instanceof E_Equals) {
            E_Equals e = (E_Equals)expr;
            RestrictionImpl a = this.getRestriction(e.getArg1());
            RestrictionImpl b = this.getRestriction(e.getArg2());
            return RestrictionManagerImpl.determineSatisfiabilityEquals(a, b);
        }
        return null;
    }

    public void collectRestrictions(Map<Var, RestrictionImpl> result) {
        if (this.parent != null) {
            this.parent.collectRestrictions(result);
        }
        result.putAll(this.restrictions);
    }

    public Map<Var, RestrictionImpl> getRestrictions() {
        HashMap<Var, RestrictionImpl> result = new HashMap<Var, RestrictionImpl>();
        this.collectRestrictions(result);
        return result;
    }

    @Override
    public RestrictionImpl getRestriction(Expr expr) {
        if (expr.isVariable()) {
            return this.restrictions.get(expr.asVar());
        }
        return this.exprToRestriction.get(expr);
    }

    public static Boolean determineSatisfiabilityEquals(RestrictionImpl a, RestrictionImpl b) {
        if (a == null || b == null) {
            return null;
        }
        RestrictionImpl tmp = new RestrictionImpl(a);
        tmp.stateRestriction(b);
        if (!tmp.isConsistent()) {
            return false;
        }
        return null;
    }

    @Override
    public RestrictionImpl getRestriction(Var a) {
        RestrictionImpl result = this.restrictions.get(a);
        if (result == null && this.parent != null) {
            return this.parent.getRestriction(a);
        }
        return result;
    }

    @Override
    public RestrictionImpl getOrCreateLocalRestriction(Var a) {
        RestrictionImpl toCopy;
        RestrictionImpl result = this.restrictions.get(a);
        if (result == null && this.parent != null && (toCopy = this.parent.getRestriction(a)) != null) {
            result = toCopy.clone();
        }
        if (result == null) {
            result = new RestrictionImpl();
            this.restrictions.put(a, result);
        }
        return result;
    }

    @Override
    public void stateType(Var a, RdfTermType type) {
        RestrictionImpl r = this.getOrCreateLocalRestriction(a);
        if (r.stateType(type)) {
            if (r.isUnsatisfiable()) {
                this.satisfiability = false;
            } else {
                this.check(a);
            }
        }
    }

    @Override
    public void stateNode(Var a, Node b) {
        RestrictionImpl r = this.getOrCreateLocalRestriction(a);
        if (r.stateNode(b)) {
            if (!r.isConsistent()) {
                this.satisfiability = Boolean.FALSE;
                return;
            }
            this.check(a);
            if (this.satisfiability != Boolean.FALSE) {
                this.binding.put(a, b);
                this.bindingBuilder.add(a, b);
            }
        }
    }

    @Override
    public void stateUri(Var a, String uri) {
        this.stateNode(a, NodeFactory.createURI((String)uri));
    }

    @Override
    public void stateLiteral(Var a, NodeValue b) {
        this.stateNode(a, b.asNode());
    }

    public void stateExpr(Expr expr) {
        Set sets = CnfUtils.toSetCnf((Expr)expr);
        HashSet<Clause> clauses = new HashSet<Clause>();
        for (Set set : sets) {
            clauses.add(new Clause(set));
        }
        NestedNormalForm newCnf = new NestedNormalForm(clauses);
        this.stateCnf(newCnf);
    }

    public void stateCnf(NestedNormalForm newCnf) {
        this.deriveRestrictions(newCnf);
        if (this.satisfiability == Boolean.FALSE) {
            return;
        }
        this.cnf.addAll(newCnf);
        this.checkClauses(newCnf);
    }

    @Override
    public void stateNonEqual(Var a, Var b) {
        throw new UnsupportedOperationException();
    }

    public Map<Var, Node> getBindings() {
        HashMap<Var, Node> result = new HashMap<Var, Node>();
        RestrictionManagerImpl current = this;
        while (current != null) {
            result.putAll(current.binding);
            current = current.parent;
        }
        return result;
    }

    public Set<Var> getVariables() {
        HashSet<Var> result = new HashSet<Var>();
        RestrictionManagerImpl current = this;
        while (current != null) {
            result.addAll(current.restrictions.keySet());
            current = current.parent;
        }
        return result;
    }

    public boolean stateRestriction(RestrictionManagerImpl rm) {
        if (this.isUnsatisfiable()) {
            return false;
        }
        if (rm == null) {
            throw new RuntimeException("Should not happen");
        }
        Set<Var> vars = rm.getVariables();
        for (Var var : vars) {
            RestrictionImpl r = rm.getRestriction(var);
            if (r == null) continue;
            this.stateRestriction(var, r);
            if (!r.isUnsatisfiable()) continue;
            this.satisfiability = Boolean.FALSE;
            return true;
        }
        if (rm.isUnsatisfiable()) {
            this.satisfiability = Boolean.FALSE;
            return true;
        }
        this.stateCnf(rm.getCnf());
        if (this.isUnsatisfiable()) {
            return true;
        }
        return true;
    }

    public Set<Clause> getEffectiveDnf(Collection<Var> vars) {
        ArrayList<Clause> clauses = new ArrayList<Clause>(this.getClausesForVars(vars));
        Collections.sort(clauses, new Comparator<Clause>(){

            @Override
            public int compare(Clause a, Clause b) {
                return a.size() - b.size();
            }
        });
        HashSet<Clause> result = new HashSet<Clause>();
        this.getEffectiveDnf(0, clauses, null, result);
        return result;
    }

    public ExprList getExprs() {
        ExprList result = new ExprList();
        for (Clause clause : this.getCnf()) {
            result.add(org.aksw.jenax.arq.util.expr.ExprUtils.orifyBalanced(clause.getExprs()));
        }
        return result;
    }

    public void getEffectiveDnf(int index, List<Clause> cnfs, Clause parentClause, Set<Clause> result) {
        if (index >= cnfs.size()) {
            if (parentClause != null) {
                result.add(parentClause);
            }
            return;
        }
        Clause clause = cnfs.get(index);
        for (Expr expr : clause.getExprs()) {
            HashSet<Expr> exprs = new HashSet<Expr>();
            if (parentClause != null) {
                exprs.addAll(parentClause.getExprs());
            }
            exprs.add(expr);
            Clause merged = new Clause(exprs);
            this.getEffectiveDnf(index + 1, cnfs, merged, result);
        }
    }

    public String toString() {
        if (this.satisfiability == Boolean.FALSE) {
            return "inconsistent";
        }
        HashMap<Var, RestrictionImpl> varToRest = new HashMap<Var, RestrictionImpl>();
        this.collectRestrictions(varToRest);
        return String.valueOf(varToRest) + " " + this.cnf.toString();
    }

    public void stateUriPrefixes(Var a, PrefixSet prefixes) {
        RestrictionImpl r = this.getOrCreateLocalRestriction(a);
        if (r.stateUriPrefixes(prefixes)) {
            if (!r.isConsistent()) {
                this.satisfiability = Boolean.FALSE;
                return;
            }
            this.check(a);
        }
    }

    public boolean isUnsatisfiable() {
        return this.satisfiability == Boolean.FALSE;
    }
}

