/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.database;

import org.aksw.sparqlify.database.Constraint;

public class StartsWithConstraint
implements Constraint {
    private String prefix;
    private boolean inclusive;

    public StartsWithConstraint(String prefix) {
        this(prefix, true);
    }

    public StartsWithConstraint(String prefix, boolean inclusive) {
        this.prefix = prefix;
        this.inclusive = inclusive;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean isInclusive() {
        return this.inclusive;
    }

    @Override
    public boolean isSatisfiedBy(Object value) {
        return value.toString().startsWith(this.prefix) && (this.inclusive || !value.toString().equals(this.prefix));
    }

    public String toString() {
        return "startsWith " + this.prefix + (this.inclusive ? "" : " (non-inclusive)");
    }
}

