/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.views;

import org.aksw.jena_sparql_api.core.QueryExecutionFactoryBackQuery;
import org.aksw.jena_sparql_api.views.CandidateViewSelector;
import org.aksw.jena_sparql_api.views.Dialect;
import org.aksw.jena_sparql_api.views.MyOpAsQuery;
import org.aksw.jena_sparql_api.views.SparqlView;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.sparql.algebra.Op;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExecutionFactorySparqlView
extends QueryExecutionFactoryBackQuery {
    private static Logger logger = LoggerFactory.getLogger(QueryExecutionFactorySparqlView.class);
    private QueryExecutionFactory factory;
    private CandidateViewSelector<SparqlView> candidateViewSelector;
    private Dialect dialect;

    public QueryExecutionFactorySparqlView(QueryExecutionFactory factory, CandidateViewSelector<SparqlView> candidateViewSelector, Dialect dialect) {
        this.factory = factory;
        this.candidateViewSelector = candidateViewSelector;
        this.dialect = dialect;
    }

    public String getId() {
        return this.factory.getId() + "-" + ((Object)((Object)this)).hashCode();
    }

    public String getState() {
        return null;
    }

    public QueryExecution createQueryExecution(Query query) {
        Op rewrittenOp = this.candidateViewSelector.getApplicableViews(query);
        Query rewritten = MyOpAsQuery.asQuery(rewrittenOp, this.dialect);
        System.out.println("Rewritten query: " + String.valueOf(rewritten));
        QueryExecution result = this.factory.createQueryExecution(rewritten);
        return result;
    }
}

