/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.aksw.jena_sparql_api.views.ExprCopy;
import org.aksw.jena_sparql_api.views.ExprEvaluator;
import org.aksw.jena_sparql_api.views.SparqlifyConstants;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_Conditional;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprFunction;
import org.apache.jena.sparql.expr.ExprNotComparableException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionRegistry;
import org.apache.jena.sparql.util.ExprUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExprEvaluatorPartial
implements ExprEvaluator {
    private static final Logger logger = LoggerFactory.getLogger(ExprEvaluatorPartial.class);
    private FunctionRegistry registry;

    public ExprEvaluatorPartial(FunctionRegistry registry) {
        this.registry = registry;
    }

    public static boolean isConstantsOnly(Iterable<Expr> exprs) {
        for (Expr expr : exprs) {
            if (expr.isConstant()) continue;
            return false;
        }
        return true;
    }

    public static boolean isConstantArgsOnly(ExprFunction fn) {
        boolean result = ExprEvaluatorPartial.isConstantsOnly(fn.getArgs());
        return result;
    }

    public Expr eval(ExprFunction fn, Map<Var, Expr> binding) {
        NodeValue newExpr;
        if (fn instanceof E_Conditional) {
            E_Conditional cond = (E_Conditional)fn;
            Expr a = this.eval(cond.getArg1(), binding);
            if (a.equals((Object)SparqlifyConstants.nvTypeError)) {
                newExpr = SparqlifyConstants.nvTypeError;
            } else {
                Expr b = this.eval(cond.getArg2(), binding);
                Expr c = this.eval(cond.getArg3(), binding);
                newExpr = new E_Conditional(a, b, c);
            }
        } else {
            ArrayList<Expr> evaledArgs = new ArrayList<Expr>();
            for (Expr arg : fn.getArgs()) {
                Expr evaledArg = this.eval(arg, binding);
                if (evaledArg == null) {
                    throw new RuntimeException("Null must not happen here");
                }
                if (evaledArg.equals((Object)SparqlifyConstants.nvTypeError)) {
                    return SparqlifyConstants.nvTypeError;
                }
                evaledArgs.add(evaledArg);
            }
            newExpr = ExprCopy.getInstance().copy(fn, evaledArgs);
        }
        NodeValue tmp = newExpr;
        if (tmp.isFunction() && !ExprEvaluatorPartial.isConstantArgsOnly(tmp.getFunction())) {
            return tmp;
        }
        HashSet<String> builtInOps = new HashSet<String>(Arrays.asList("<=", "<", "=", "!=", ">", ">=", "if", "&&", "||", "!", "+", "-", "*", "/"));
        String fnIri = org.aksw.jenax.arq.util.expr.ExprUtils.getFunctionId((ExprFunction)fn);
        if (fnIri != null && !fnIri.isEmpty() && !builtInOps.contains(fnIri) && this.registry.get(fnIri) == null) {
            return tmp;
        }
        NodeValue result = tmp;
        try {
            result = ExprUtils.eval((Expr)tmp);
        }
        catch (ExprNotComparableException e) {
            return SparqlifyConstants.nvTypeError;
        }
        catch (Exception e) {
            logger.warn("Failed to evaluate expr: " + String.valueOf(tmp));
        }
        return result;
    }

    @Override
    public Expr eval(Expr expr, Map<Var, Expr> binding) {
        if (expr == null) {
            throw new RuntimeException("Null expression should not happen");
        }
        Expr result = null;
        if (expr.isConstant()) {
            result = expr;
        } else if (expr.isFunction()) {
            ExprFunction fn = expr.getFunction();
            result = this.eval(fn, binding);
        } else if (expr.isVariable()) {
            Expr boundExpr;
            result = expr;
            if (binding != null && (boundExpr = binding.get(expr.asVar())) != null) {
                result = this.eval(boundExpr, null);
            }
        } else {
            throw new RuntimeException("Unknown expression type encountered: " + String.valueOf(expr));
        }
        return result;
    }

    @Override
    public Expr transform(Expr expr) {
        Expr result = this.eval(expr, null);
        return result;
    }
}

