/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.database;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Predicate;
import org.aksw.commons.util.reflect.MultiMethod;
import org.aksw.jena_sparql_api.normal_form.Clause;
import org.aksw.jena_sparql_api.normal_form.NestedNormalForm;
import org.aksw.jena_sparql_api.restriction.RestrictionImpl;
import org.aksw.jena_sparql_api.restriction.RestrictionManagerImpl;
import org.aksw.jena_sparql_api.views.OpViewInstanceJoin;
import org.aksw.sparqlify.database.FilterSplit;
import org.aksw.sparqlify.database.GetVarsMentioned;
import org.aksw.sparqlify.database.OpFilterIndexed;
import org.aksw.sparqlify.database.PredicateInstanceOf;
import org.aksw.sparqlify.sparqlview.OpSparqlViewPattern;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.op.OpConditional;
import org.apache.jena.sparql.algebra.op.OpDisjunction;
import org.apache.jena.sparql.algebra.op.OpDistinct;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpGroup;
import org.apache.jena.sparql.algebra.op.OpJoin;
import org.apache.jena.sparql.algebra.op.OpLeftJoin;
import org.apache.jena.sparql.algebra.op.OpNull;
import org.apache.jena.sparql.algebra.op.OpOrder;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpSequence;
import org.apache.jena.sparql.algebra.op.OpSlice;
import org.apache.jena.sparql.algebra.op.OpTopN;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_Bound;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterPlacementOptimizer2 {
    private static FilterPlacementOptimizer2 instance;
    private static final Logger logger;

    public static FilterPlacementOptimizer2 get() {
        if (instance == null) {
            instance = new FilterPlacementOptimizer2();
        }
        return instance;
    }

    public static Op optimizeStatic(Op op) {
        Op result = FilterPlacementOptimizer2.optimizeStatic(op, null);
        return result;
    }

    public static Op optimizeStatic(Op op, RestrictionManagerImpl cnf) {
        FilterPlacementOptimizer2 inst = FilterPlacementOptimizer2.get();
        Op result = inst.optimize(op, cnf);
        return result;
    }

    public Op optimize(Op op) {
        Op result = this.optimize(op, null);
        return result;
    }

    public Op optimize(Op op, RestrictionManagerImpl cnf) {
        if (cnf == null) {
            cnf = new RestrictionManagerImpl();
        }
        Op result = (Op)MultiMethod.invoke((Object)this, (String)"_optimize", (Object[])new Object[]{op, cnf});
        return result;
    }

    public RestrictionManagerImpl filterByVars(RestrictionManagerImpl cnf, Op op) {
        Set<Var> vars = GetVarsMentioned.getVarsMentioned(op);
        Set<Clause> clauses = cnf.getClausesForVars(vars);
        return new RestrictionManagerImpl(new NestedNormalForm(clauses));
    }

    public Op _optimize(OpOrder op, RestrictionManagerImpl cnf) {
        return new OpOrder(this.optimize(op.getSubOp(), cnf), op.getConditions());
    }

    public Op _optimize(OpTopN op, RestrictionManagerImpl cnf) {
        return new OpTopN(this.optimize(op.getSubOp(), cnf), op.getLimit(), op.getConditions());
    }

    public Op _optimize(OpJoin op, RestrictionManagerImpl cnf) {
        Op result = this.handleLeftJoin(op.getLeft(), op.getRight(), cnf, OpJoin::create);
        return result;
    }

    public Op _optimizeBreaking(OpJoin op, RestrictionManagerImpl cnf) {
        RestrictionManagerImpl leftCnf = this.filterByVars(cnf, op.getLeft());
        RestrictionManagerImpl rightCnf = this.filterByVars(cnf, op.getRight());
        Sets.SetView union = Sets.union((Set)leftCnf.getCnf(), (Set)rightCnf.getCnf());
        Sets.SetView remaining = Sets.difference((Set)cnf.getCnf(), (Set)union);
        Object result = OpJoin.create((Op)this.optimize(op.getLeft(), leftCnf), (Op)this.optimize(op.getRight(), rightCnf));
        if (!remaining.isEmpty()) {
            result = OpFilterIndexed.filter(new RestrictionManagerImpl(new NestedNormalForm((Set<Clause>)remaining)), result);
        }
        return result;
    }

    public Op _optimize(OpSequence op, RestrictionManagerImpl cnf) {
        List members = op.getElements();
        ArrayList<Op> newMembers = new ArrayList<Op>(members.size());
        HashSet intersection = new HashSet();
        for (Op member : members) {
            RestrictionManagerImpl restrictions = this.filterByVars(cnf, member);
            Op newMember = this.optimize(member, restrictions);
            newMembers.add(newMember);
            Sets.SetView tmp = Sets.intersection((Set)restrictions.getCnf(), intersection);
            intersection = new HashSet(tmp);
        }
        Sets.SetView remaining = Sets.difference((Set)cnf.getCnf(), intersection);
        Object result = OpSequence.create().copy(newMembers);
        if (!remaining.isEmpty()) {
            result = OpFilterIndexed.filter(new RestrictionManagerImpl(new NestedNormalForm((Set<Clause>)remaining)), (Op)result);
        }
        return result;
    }

    public Op _optimize(OpDisjunction op, RestrictionManagerImpl cnf) {
        ArrayList<Op> args = new ArrayList<Op>();
        for (Op element : op.getElements()) {
            Set<Var> elementVars = GetVarsMentioned.getVarsMentioned(element);
            boolean elementHasRequiredVars = true;
            for (Clause clause : cnf.getCnf()) {
                Set<Var> clauseVars = clause.getVarsMentioned();
                if (!clauseVars.containsAll(elementVars)) continue;
                elementHasRequiredVars = false;
                break;
            }
            if (!elementHasRequiredVars) continue;
            Op optimizedMember = this.optimize(element, cnf);
            args.add(optimizedMember);
        }
        OpDisjunction result = OpDisjunction.create();
        result.getElements().addAll(args);
        return result;
    }

    public Op _optimize(OpDistinct op, RestrictionManagerImpl cnf) {
        return new OpDistinct(this.optimize(op.getSubOp(), cnf));
    }

    public Op _optimize(OpProject op, RestrictionManagerImpl cnf) {
        Op subOp = this.optimize(op.getSubOp(), cnf);
        OpProject result = new OpProject(subOp, op.getVars());
        return result;
    }

    public Op _optimize(OpExtend op, RestrictionManagerImpl cnf) {
        logger.warn("OpExtend probably not optimally implemented");
        return op.copy(this.optimize(op.getSubOp(), cnf));
    }

    public Op _optimize(OpGroup op, RestrictionManagerImpl cnf) {
        return new OpGroup(this.optimize(op.getSubOp(), cnf), op.getGroupVars(), op.getAggregators());
    }

    public Op _optimizeNewButNotSureIfWeNeedSplitsHere(OpFilterIndexed op, RestrictionManagerImpl cnf) {
        RestrictionManagerImpl child = new RestrictionManagerImpl(cnf);
        child.stateRestriction(op.getRestrictions());
        FilterSplit filterSplit = FilterPlacementOptimizer2.splitFilter((Op)op, child);
        RestrictionManagerImpl pushable = filterSplit.getPushable();
        Object result = this.optimize(op.getSubOp(), pushable);
        if (!filterSplit.getNonPushable().getCnf().isEmpty()) {
            result = OpFilterIndexed.filter(filterSplit.getNonPushable(), result);
        }
        return result;
    }

    public Op _optimize(OpFilterIndexed op, RestrictionManagerImpl cnf) {
        RestrictionManagerImpl child = new RestrictionManagerImpl(cnf);
        child.stateRestriction(op.getRestrictions());
        Op result = this.optimize(op.getSubOp(), child);
        return result;
    }

    public Op _optimize(OpNull op, RestrictionManagerImpl cnf) {
        return op;
    }

    public Op _optimize(OpSlice op, RestrictionManagerImpl cnf) {
        return op.copy(this.optimize(op.getSubOp(), cnf));
    }

    public static boolean evalPredicate(Expr expr, Predicate<Expr> predicate) {
        if (predicate.test(expr)) {
            return true;
        }
        if (expr.isFunction()) {
            for (Expr arg : expr.getFunction().getArgs()) {
                if (!FilterPlacementOptimizer2.evalPredicate(arg, predicate)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean doesClauseContainBoundExpr(Clause clause) {
        PredicateInstanceOf<Expr> predicate = new PredicateInstanceOf<Expr>(E_Bound.class);
        for (Expr expr : clause.getExprs()) {
            if (!FilterPlacementOptimizer2.evalPredicate(expr, predicate)) continue;
            return true;
        }
        return false;
    }

    public Op _optimize(OpLeftJoin op, RestrictionManagerImpl cnf) {
        Op result = this.handleLeftJoin(op.getLeft(), op.getRight(), cnf, (a, b) -> OpLeftJoin.create((Op)a, (Op)b, (ExprList)op.getExprs()));
        return result;
    }

    public Op _optimize(OpConditional op, RestrictionManagerImpl cnf) {
        Op result = this.handleLeftJoin(op.getLeft(), op.getRight(), cnf, OpConditional::new);
        return result;
    }

    public static FilterSplit splitFilter(Op op, RestrictionManagerImpl cnf) {
        Set<Var> opVars = GetVarsMentioned.getVarsMentioned(op);
        HashSet<Clause> leftClauses = new HashSet<Clause>();
        HashSet<Clause> nonPushable = new HashSet<Clause>();
        for (Clause clause : cnf.getCnf()) {
            Set<Var> clauseVars = clause.getVarsMentioned();
            if (opVars.containsAll(clauseVars)) {
                leftClauses.add(clause);
                continue;
            }
            nonPushable.add(clause);
        }
        RestrictionManagerImpl leftRm = new RestrictionManagerImpl(new NestedNormalForm(leftClauses));
        RestrictionManagerImpl np = new RestrictionManagerImpl(new NestedNormalForm(nonPushable));
        for (Map.Entry entry : cnf.getRestrictions().entrySet()) {
            Var var = (Var)entry.getKey();
            RestrictionImpl rest = (RestrictionImpl)entry.getValue();
            leftRm.stateRestriction(var, rest);
            np.stateRestriction(var, rest);
        }
        FilterSplit result = new FilterSplit(leftRm, np);
        return result;
    }

    public Op handleLeftJoin(Op left, Op right, RestrictionManagerImpl cnf, BinaryOperator<Op> factory) {
        FilterSplit filterSplit = FilterPlacementOptimizer2.splitFilter(left, cnf);
        RestrictionManagerImpl leftRm = filterSplit.getPushable();
        RestrictionManagerImpl np = filterSplit.getNonPushable();
        Op newLeft = this.optimize(left, leftRm);
        FilterSplit rsplit = FilterPlacementOptimizer2.splitFilter(right, leftRm);
        RestrictionManagerImpl rightRm = rsplit.getPushable();
        Op newRight = this.optimize(right, rightRm);
        Op leftJoin = (Op)factory.apply(newLeft, newRight);
        Op result = this.surroundWithFilterIfNeccessary(leftJoin, np);
        return result;
    }

    public Op handleLeftJoinOld(Op left, Op right, RestrictionManagerImpl cnf, BinaryOperator<Op> factory) {
        Set<Var> rightVars = GetVarsMentioned.getVarsMentioned(right);
        HashSet<Clause> leftClauses = new HashSet<Clause>();
        HashSet<Clause> nonPushable = new HashSet<Clause>();
        for (Clause clause : cnf.getCnf()) {
            Set<Var> clauseVars = clause.getVarsMentioned();
            if (Sets.intersection(clauseVars, rightVars).isEmpty()) {
                leftClauses.add(clause);
                continue;
            }
            nonPushable.add(clause);
        }
        RestrictionManagerImpl leftRm = new RestrictionManagerImpl(new NestedNormalForm(leftClauses));
        RestrictionManagerImpl np = new RestrictionManagerImpl(new NestedNormalForm(nonPushable));
        Op newLeft = this.optimize(left, leftRm);
        Op newRight = this.optimize(right, leftRm);
        Op leftJoin = (Op)factory.apply(newLeft, newRight);
        Op result = this.surroundWithFilterIfNeccessary(leftJoin, np);
        return result;
    }

    public Op surroundWithFilterIfNeccessary(Op op, RestrictionManagerImpl cnf) {
        Object result = cnf.isUnsatisfiable() ? new OpFilterIndexed(op, new RestrictionManagerImpl(new NestedNormalForm(new HashSet<Clause>(Collections.singleton(new Clause(new HashSet<NodeValue>(Collections.singleton(NodeValue.FALSE)))))))) : (cnf.getCnf().isEmpty() ? op : new OpFilterIndexed(op, cnf));
        return result;
    }

    public Op _optimize(OpViewInstanceJoin op, RestrictionManagerImpl cnf) {
        return this.surroundWithFilterIfNeccessary((Op)op, cnf);
    }

    public Op _optimize(OpSparqlViewPattern op, RestrictionManagerImpl cnf) {
        return this.surroundWithFilterIfNeccessary((Op)op, cnf);
    }

    static {
        logger = LoggerFactory.getLogger(FilterPlacementOptimizer2.class);
    }
}

