/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.normal_form;

import com.google.common.collect.Sets;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class NestedSet<T>
extends AbstractSet<T> {
    private Set<T> parent = null;
    int parentEffectiveItemCount;
    int cachedSize;
    private Set<T> effectiveItems;
    private Set<T> addedItems;
    private Set<T> removedItems;

    public boolean isView() {
        return this.addedItems != null;
    }

    public NestedSet(Set<T> items, boolean asView) {
        if (asView) {
            this.addedItems = new HashSet<T>();
            this.removedItems = new HashSet<T>();
            this.cachedSize = this.parentEffectiveItemCount = items.size();
            this.effectiveItems = Sets.union(this.addedItems, (Set)Sets.difference(items, this.removedItems));
        } else if (items == null) {
            this.effectiveItems = new HashSet<T>();
        } else {
            this.effectiveItems = items;
            this.cachedSize = this.effectiveItems.size();
        }
    }

    private void checkCopy(Set<T> deltaSet) {
        if (deltaSet.size() > 4 * this.parentEffectiveItemCount) {
            this.effectiveItems = new HashSet<T>(this.effectiveItems);
            this.addedItems = null;
            this.removedItems = null;
        }
    }

    @Override
    public boolean add(T item) {
        if (this.effectiveItems.contains(item)) {
            return false;
        }
        if (this.isView()) {
            this.checkCopy(this.addedItems);
            if (this.isView()) {
                this.addedItems.add(item);
                this.removedItems.remove(item);
            }
        }
        if (!this.isView()) {
            this.effectiveItems.add(item);
        }
        ++this.cachedSize;
        this.onAdd(item);
        return true;
    }

    @Override
    public boolean remove(Object item) {
        if (!this.effectiveItems.contains(item)) {
            return false;
        }
        if (this.isView()) {
            this.checkCopy(this.removedItems);
            if (this.isView()) {
                this.removedItems.add(item);
                this.addedItems.remove(item);
            }
        }
        if (!this.isView()) {
            this.effectiveItems.remove(item);
        }
        this.onRemove(item);
        --this.cachedSize;
        return true;
    }

    protected void onAdd(T item) {
    }

    protected void onRemove(T item) {
    }

    public int getNestingDepth() {
        if (this.parent != null && this.parent instanceof NestedSet) {
            return 1 + ((NestedSet)this.parent).getNestingDepth();
        }
        return 0;
    }

    @Override
    public boolean contains(Object item) {
        return this.effectiveItems.contains(item);
    }

    public boolean containsDirect(Object item) {
        return this.isView() ? this.addedItems.contains(item) : this.effectiveItems.contains(item);
    }

    @Override
    public Iterator<T> iterator() {
        return this.effectiveItems.iterator();
    }

    @Override
    public int size() {
        return this.cachedSize;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.effectiveItems == null ? 0 : this.effectiveItems.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NestedSet other = (NestedSet)obj;
        return !(this.effectiveItems == null ? other.effectiveItems != null : !this.effectiveItems.equals(other.effectiveItems));
    }
}

