/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.views;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.collections.multimaps.BiHashMultimap;
import org.aksw.commons.collections.multimaps.IBiSetMultimap;
import org.aksw.commons.collections.multimaps.MultimapUtils;

public class EquiMap<K, V> {
    private IBiSetMultimap<K, K> equivalences = new BiHashMultimap();
    private Map<K, V> keyToValue = new HashMap();

    public Set<K> keySet() {
        return Sets.union(this.equivalences.asMap().keySet(), this.keyToValue.keySet());
    }

    public void clear() {
        this.equivalences.clear();
        this.keyToValue.clear();
    }

    public boolean isEqual(K a, K b) {
        return this.get(a).contains(b);
    }

    public boolean areAllEqual(Collection<K> set) {
        if (set.isEmpty()) {
            return true;
        }
        return this.get(set.iterator().next()).containsAll(set);
    }

    public boolean isConsistentInsertEquiv(K a, K b) {
        return this.isConsistentSet((Set<V>)Sets.union(this.get(a), this.get(b)));
    }

    public boolean isConsistentSet(Set<V> set) {
        return set.size() <= 1;
    }

    public boolean isConsistentInsertValue(K a, V b) {
        Set<V> values = this.get(a);
        if (values.isEmpty()) {
            return true;
        }
        if (values.size() == 1 && values.contains(b)) {
            return true;
        }
        if (values.size() > 1) {
            throw new RuntimeException("Should not happen");
        }
        return false;
    }

    public boolean isSelfConsistent() {
        HashSet<K> open = new HashSet<K>(this.keyToValue.keySet());
        while (!open.isEmpty()) {
            Object key = open.iterator().next();
            open.remove(key);
            Set<K> keys = this.getEquivalences(key, false);
            open.removeAll(keys);
            Set<V> values = this.get(keys);
            if (this.isConsistentSet(values)) continue;
            return false;
        }
        return true;
    }

    public EquiMap() {
    }

    public EquiMap(EquiMap<K, V> other) {
        for (Map.Entry entry : this.equivalences.asMap().entrySet()) {
            for (Object value : (Collection)entry.getValue()) {
                this.equivalences.put(entry.getKey(), value);
            }
        }
        this.keyToValue.putAll(other.keyToValue);
    }

    public IBiSetMultimap<K, K> getEquivalences() {
        return this.equivalences;
    }

    public Map<K, V> getKeyToValue() {
        return this.keyToValue;
    }

    public void put(K key, V value) {
        this.keyToValue.put(key, value);
    }

    public Set<V> getAll(Set<?> keys) {
        HashSet<V> result = new HashSet<V>();
        for (Object key : keys) {
            if (!this.keyToValue.containsKey(key)) continue;
            result.add(this.keyToValue.get(key));
        }
        return result;
    }

    public Set<K> getEquivalences(Object key, boolean reflexiv) {
        Set result = MultimapUtils.transitiveGetBoth(this.equivalences, (Object)key);
        if (reflexiv) {
            result.add(key);
        }
        return result;
    }

    public Set<K> getAllEquivalences(Collection<?> keys, boolean reflexiv) {
        HashSet<K> result = new HashSet<K>();
        HashSet<K> open = new HashSet<K>(keys);
        while (!open.isEmpty()) {
            Object key = open.iterator().next();
            open.remove(key);
            Set<K> equivs = this.getEquivalences(key, reflexiv);
            open.removeAll(equivs);
            result.addAll(equivs);
        }
        return result;
    }

    public Set<V> get(Object key) {
        return this.getAll(this.getEquivalences(key, true));
    }

    public boolean makeEqual(K a, K b) {
        return this.equivalences.put(a, b);
    }

    public boolean isCompatible(EquiMap<K, V> other) {
        HashSet<K> open = new HashSet<K>(this.keyToValue.keySet());
        while (!open.isEmpty()) {
            Set<V> otherValues;
            Object key = open.iterator().next();
            open.remove(key);
            HashSet<Object> bothEquivs = new HashSet<Object>();
            Set<Object> newEquivs = Collections.singleton(key);
            do {
                Set<K> thisEquivs = this.getAllEquivalences(newEquivs, true);
                thisEquivs.removeAll(bothEquivs);
                open.removeAll(thisEquivs);
                bothEquivs.addAll(thisEquivs);
                newEquivs = other.getAllEquivalences(thisEquivs, true);
                newEquivs.removeAll(bothEquivs);
                open.removeAll(newEquivs);
                bothEquivs.addAll(newEquivs);
            } while (!newEquivs.isEmpty());
            Set<V> thisValues = this.getAll(bothEquivs);
            Sets.SetView union = Sets.union(thisValues, otherValues = other.getAll(bothEquivs));
            if (this.isConsistentSet((Set<V>)union)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "[equivalences=" + String.valueOf(this.equivalences) + ", keyToValue=" + String.valueOf(this.keyToValue) + "]";
    }
}

