/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.normal_form;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;

public class ClauseBase {
    private Set<Var> varsMentioned;
    private Set<Expr> exprs;
    private Multimap<Var, Expr> varToExpr;

    public Set<Expr> getExprs(Collection<Var> vars) {
        HashSet<Expr> result = new HashSet<Expr>();
        float scanFactor = 0.75f;
        if ((float)vars.size() > scanFactor * (float)this.exprs.size()) {
            for (Expr expr : this.exprs) {
                if (!expr.getVarsMentioned().stream().anyMatch(x -> vars.contains(x))) continue;
                result.add(expr);
            }
        } else {
            for (Var var : vars) {
                result.addAll(this.varToExpr.get((Object)var));
            }
        }
        return result;
    }

    public ClauseBase(Set<Expr> exprs) {
        this.exprs = exprs;
        this.varToExpr = HashMultimap.create();
        HashSet<Var> vars = new HashSet<Var>();
        for (Expr expr : exprs) {
            Set evs = expr.getVarsMentioned();
            vars.addAll(evs);
            for (Var ev : evs) {
                this.varToExpr.put((Object)ev, (Object)expr);
            }
        }
        this.varsMentioned = vars;
    }

    public Set<Expr> getExprs() {
        return this.exprs;
    }

    public Set<Var> getVarsMentioned() {
        return this.varsMentioned;
    }

    public int size() {
        return this.exprs.size();
    }

    public String toString() {
        return this.exprs.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.exprs == null ? 0 : this.exprs.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClauseBase other = (ClauseBase)obj;
        return !(this.exprs == null ? other.exprs != null : !this.exprs.equals(other.exprs));
    }
}

