/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.rdf.io.lenient;

import java.io.InputStream;
import java.util.Iterator;
import org.aksw.jenax.rdf.io.lenient.IteratorRecovering;
import org.aksw.jenax.rdf.io.lenient.TokenizerWrapperRecovering;
import org.apache.jena.atlas.io.PeekReader;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.lang.LangNQuads;
import org.apache.jena.riot.lang.LangNTriples;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerText;
import org.apache.jena.sparql.core.Quad;

public class IteratorParsersLenient {
    public static Iterator<Triple> createIteratorNTriples(InputStream input) {
        return IteratorParsersLenient.createIteratorNTriples(input, RiotLib.dftProfile());
    }

    public static Iterator<Triple> createIteratorNTriples(InputStream input, ParserProfile profile) {
        PeekReader peekReader = PeekReader.makeUTF8((InputStream)input);
        Tokenizer core = TokenizerText.create().source(peekReader).errorHandler(profile.getErrorHandler()).build();
        TokenizerWrapperRecovering tokenizer = new TokenizerWrapperRecovering(core, peekReader);
        LangNTriples ct = IteratorParsersLenient.createParserNTriples(tokenizer, null, profile);
        return new IteratorRecovering(ct, peekReader);
    }

    static LangNTriples createParserNTriples(Tokenizer tokenizer, StreamRDF dest, ParserProfile profile) {
        LangNTriples parser = new LangNTriples(tokenizer, profile, dest);
        return parser;
    }

    public static Iterator<Quad> createIteratorNQuads(InputStream input) {
        return IteratorParsersLenient.createIteratorNQuads(input, RiotLib.dftProfile());
    }

    public static Iterator<Quad> createIteratorNQuads(InputStream input, ParserProfile profile) {
        PeekReader peekReader = PeekReader.makeUTF8((InputStream)input);
        Tokenizer core = TokenizerText.create().source(peekReader).errorHandler(profile.getErrorHandler()).build();
        TokenizerWrapperRecovering tokenizer = new TokenizerWrapperRecovering(core, peekReader);
        LangNQuads ct = IteratorParsersLenient.createParserNQuads(tokenizer, null, profile);
        return new IteratorRecovering(ct, peekReader);
    }

    static LangNQuads createParserNQuads(Tokenizer tokenizer, StreamRDF dest, ParserProfile profile) {
        LangNQuads parser = new LangNQuads(tokenizer, profile, dest);
        return parser;
    }
}

