/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.ClassUtils;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;

public class TypeMapperUtils {
    public static List<RDFDatatype> getTypesBySubClassOf(TypeMapper tm, Class<?> cls) {
        List<RDFDatatype> result;
        RDFDatatype cand = tm.getTypeByClass(cls);
        if (cand == null) {
            result = new ArrayList<RDFDatatype>();
            Iterator it = tm.listTypes();
            while (it.hasNext()) {
                RDFDatatype dtype = (RDFDatatype)it.next();
                Class dtypeCls = dtype.getJavaClass();
                if (dtypeCls == null || !ClassUtils.isAssignable((Class)dtypeCls, cls)) continue;
                result.add(dtype);
            }
        } else {
            result = Collections.singletonList(cand);
        }
        return result;
    }
}

