/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.tuple;

import java.util.function.Function;
import org.aksw.commons.tuple.accessor.TupleAccessor;
import org.aksw.commons.tuple.bridge.TupleBridge;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.lib.tuple.TupleFactory;

public class TupleOps {
    public static <DomainType, ComponentType> Function<DomainType, Tuple<ComponentType>> createProjector(int[] project, TupleAccessor<? super DomainType, ? extends ComponentType> accessor) {
        int len = project.length;
        return switch (len) {
            case 1 -> domain -> TupleFactory.create1((Object)accessor.get(domain, project[0]));
            case 2 -> domain -> TupleFactory.create2((Object)accessor.get(domain, project[0]), (Object)accessor.get(domain, project[1]));
            case 3 -> domain -> TupleFactory.create3((Object)accessor.get(domain, project[0]), (Object)accessor.get(domain, project[1]), (Object)accessor.get(domain, project[2]));
            case 4 -> domain -> TupleFactory.create4((Object)accessor.get(domain, project[0]), (Object)accessor.get(domain, project[1]), (Object)accessor.get(domain, project[2]), (Object)accessor.get(domain, project[3]));
            default -> domain -> TupleOps.project(project, domain, accessor);
        };
    }

    public static <DomainType, ComponentType> Tuple<ComponentType> project(int[] proj, DomainType domainObject, TupleAccessor<? super DomainType, ? extends ComponentType> accessor) {
        Object[] tuple = new Object[proj.length];
        for (int i = 0; i < proj.length; ++i) {
            tuple[i] = accessor.get(domainObject, proj[i]);
        }
        return TupleFactory.create((Object[])tuple);
    }

    public static <D, C> Function<D, Tuple<C>> tupelizer(TupleBridge<? super D, ? extends C> accessor) {
        int len = accessor.getDimension();
        return switch (len) {
            case 1 -> domain -> TupleFactory.create1((Object)accessor.get(domain, 0));
            case 2 -> domain -> TupleFactory.create2((Object)accessor.get(domain, 0), (Object)accessor.get(domain, 1));
            case 3 -> domain -> TupleFactory.create3((Object)accessor.get(domain, 0), (Object)accessor.get(domain, 1), (Object)accessor.get(domain, 2));
            case 4 -> domain -> TupleFactory.create4((Object)accessor.get(domain, 0), (Object)accessor.get(domain, 1), (Object)accessor.get(domain, 2), (Object)accessor.get(domain, 3));
            default -> domain -> TupleFactory.create((Object[])accessor.toComponentArray(domain));
        };
    }
}

