/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.triple;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.aksw.commons.util.string.StringUtils;
import org.aksw.jenax.arq.util.binding.BindingUtils;
import org.aksw.jenax.arq.util.io.NTripleUtils;
import org.aksw.jenax.arq.util.node.NodeUtils;
import org.aksw.jenax.arq.util.tuple.TupleUtils;
import org.aksw.jenax.arq.util.tuple.adapter.TupleBridgeTriple;
import org.aksw.jenax.arq.util.var.Vars;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.riot.writer.NTriplesWriter;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.mem.TupleSlot;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.path.P_Path0;
import org.apache.jena.sparql.util.ModelUtils;
import org.apache.jena.sparql.util.NodeCmp;

public class TripleUtils {
    private static final TupleSlot[] SLOTS = new TupleSlot[]{TupleSlot.SUBJECT, TupleSlot.PREDICATE, TupleSlot.OBJECT};

    public static Node[] tripleToArray(Triple t) {
        return new Node[]{t.getSubject(), t.getPredicate(), t.getObject()};
    }

    public static Set<Var> getVarsMentioned(Triple t) {
        return NodeUtils.getVarsMentioned(Arrays.asList(TripleUtils.tripleToArray(t)));
    }

    public static Stream<Node> streamNodes(Triple t) {
        return Stream.of(t.getSubject(), t.getPredicate(), t.getObject());
    }

    public static Iterator<Node> iterateNodes(Triple t) {
        return TripleUtils.streamNodes(t).iterator();
    }

    public static boolean isValidAsStatement(Triple t) {
        return ModelUtils.isValidAsStatement((Node)t.getSubject(), (Node)t.getPredicate(), (Node)t.getObject());
    }

    public static Node getNode(Triple triple, int idx) {
        switch (idx) {
            case 0: {
                return triple.getSubject();
            }
            case 1: {
                return triple.getPredicate();
            }
            case 2: {
                return triple.getObject();
            }
        }
        throw new IndexOutOfBoundsException("Cannot access index " + idx + " of a triple");
    }

    public static TupleSlot idxToSlot(int idx) {
        return SLOTS[idx];
    }

    public static int slotToIdx(TupleSlot slot) {
        switch (slot) {
            case SUBJECT: {
                return 0;
            }
            case PREDICATE: {
                return 1;
            }
            case OBJECT: {
                return 2;
            }
        }
        throw new IndexOutOfBoundsException("Cannot access slot " + String.valueOf(slot) + " of a triple");
    }

    public static Node getNode(Triple triple, TupleSlot slot) {
        return TripleUtils.getNode(triple, TripleUtils.slotToIdx(slot));
    }

    public static Triple logicalAnd(Triple a, Triple b) {
        Node s = NodeUtils.logicalAnd(a.getMatchSubject(), b.getMatchSubject());
        Node p = NodeUtils.logicalAnd(a.getMatchPredicate(), b.getMatchPredicate());
        Node o = NodeUtils.logicalAnd(a.getMatchObject(), b.getMatchObject());
        Triple result = s == null || p == null || o == null ? null : Triple.createMatch((Node)s, (Node)p, (Node)o);
        return result;
    }

    public static Node getSource(Triple triple, boolean isForward) {
        return isForward ? triple.getSubject() : triple.getObject();
    }

    public static Node getTarget(Triple triple, boolean isForward) {
        return isForward ? triple.getObject() : triple.getSubject();
    }

    public static Triple createMatch(Node source, P_Path0 predicate) {
        return TripleUtils.createMatch(source, predicate.getNode(), predicate.isForward());
    }

    public static Triple createMatch(Triple triple, boolean isForward) {
        return isForward ? triple : TripleUtils.swap(triple);
    }

    public static Triple createMatch(Node source, Node predicate, boolean isForward) {
        Triple result = isForward ? Triple.createMatch((Node)source, (Node)predicate, (Node)Node.ANY) : Triple.createMatch((Node)Node.ANY, (Node)predicate, (Node)source);
        return result;
    }

    public static Triple create(Node s, P_Path0 p, Node o) {
        Triple result = TripleUtils.create(s, p.getNode(), o, p.isForward());
        return result;
    }

    public static Triple create(Node s, Node p, Node o, boolean isForward) {
        Triple result = isForward ? Triple.create((Node)s, (Node)p, (Node)o) : Triple.create((Node)o, (Node)p, (Node)s);
        return result;
    }

    public static Node[] toArray(Triple t) {
        Node[] result = new Node[]{t.getSubject(), t.getPredicate(), t.getObject()};
        return result;
    }

    public static Triple fromArray(Node[] nodes) {
        Node s = nodes[0];
        Node p = nodes[1];
        Node o = nodes[2];
        Triple result = Triple.create((Node)s, (Node)p, (Node)o);
        return result;
    }

    public static Binding tripleToBinding(Triple triple) {
        Binding result = TripleUtils.tripleToBinding(triple, Binding.noParent);
        return result;
    }

    public static Binding tripleToBinding(Triple triple, Binding parent) {
        BindingBuilder result = BindingBuilder.create((Binding)parent);
        result.add(Vars.s, triple.getSubject());
        result.add(Vars.p, triple.getPredicate());
        result.add(Vars.o, triple.getObject());
        return result.build();
    }

    public static Triple bindingToTriple(Binding b) {
        return TripleUtils.bindingToTriple(b, Vars.s, Vars.p, Vars.o);
    }

    public static Triple bindingToTriple(Binding b, Var vs, Var vp, Var vo) {
        Node o;
        Node p;
        Triple result = null;
        Node s = b.get(vs);
        if (s != null && (p = b.get(vp)) != null && (o = b.get(vo)) != null) {
            result = Triple.create((Node)s, (Node)p, (Node)o);
        }
        return result;
    }

    public static Binding tripleToBinding(Triple pattern, Triple assignment) {
        return TupleUtils.tupleToBinding(TupleBridgeTriple.INSTANCE, pattern, assignment);
    }

    public static Triple swap(Triple t) {
        Triple result = Triple.create((Node)t.getObject(), (Node)t.getPredicate(), (Node)t.getSubject());
        return result;
    }

    public static Set<Triple> swap(Iterable<Triple> triples) {
        HashSet<Triple> result = new HashSet<Triple>();
        for (Triple t : triples) {
            result.add(TripleUtils.swap(t));
        }
        return result;
    }

    public static Triple listToTriple(List<Node> nodes) {
        return Triple.create((Node)nodes.get(0), (Node)nodes.get(1), (Node)nodes.get(2));
    }

    public static List<Node> tripleToList(Triple triple) {
        ArrayList<Node> result = new ArrayList<Node>();
        result.add(triple.getSubject());
        result.add(triple.getPredicate());
        result.add(triple.getObject());
        return result;
    }

    public static boolean isValid(Triple t) {
        boolean result;
        try {
            String str = NodeFmtLib.str((Triple)t) + " .";
            NTripleUtils.parseNTriplesString(str);
            result = true;
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public static String md5sum(Triple triple) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        NTriplesWriter.write((OutputStream)baos, Collections.singleton(triple).iterator());
        String raw = baos.toString();
        String result = StringUtils.md5Hash((String)raw);
        return result;
    }

    public static int compareRDFTerms(Triple o1, Triple o2) {
        return TripleUtils.compare(o1, o2, NodeCmp::compareRDFTerms);
    }

    public static int compare(Triple o1, Triple o2, Comparator<Node> nc) {
        int toReturn = nc.compare(o1.getSubject(), o2.getSubject());
        if (toReturn == 0 && (toReturn = nc.compare(o1.getPredicate(), o2.getPredicate())) == 0) {
            toReturn = nc.compare(o1.getObject(), o2.getObject());
        }
        return toReturn;
    }

    public static Triple copySubstitute(Triple quad, Binding binding) {
        return Triple.create((Node)BindingUtils.substitute(quad.getSubject(), binding), (Node)BindingUtils.substitute(quad.getPredicate(), binding), (Node)BindingUtils.substitute(quad.getObject(), binding));
    }
}

