/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.triple;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;
import org.aksw.jenax.arq.util.triple.GraphUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;

public class ModelUtils {
    public static Model union(Model ... models) {
        Model result = Stream.of(models).filter(Objects::nonNull).distinct().reduce(ModelFactory::createUnion).orElse(ModelFactory.createDefaultModel());
        return result;
    }

    public static Stream<Node> streamNodes(Model model) {
        return GraphUtils.streamNodes(model.getGraph());
    }

    public static Iterator<Node> iterateNodes(Model model) {
        return GraphUtils.iterateNodes(model.getGraph());
    }

    public static Model optimizePrefixes(Model model) {
        GraphUtils.optimizePrefixes(model.getGraph());
        return model;
    }

    public static String toString(Model model, RDFFormat rdfFormat) {
        String result;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            RDFDataMgr.write((OutputStream)out, (Model)model, (RDFFormat)rdfFormat);
            out.flush();
            result = out.toString(StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }
}

