/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.node;

import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.util.ArrayList;
import org.aksw.jenax.arq.util.expr.ExprUtils;
import org.aksw.jenax.arq.util.node.ComparableNodeValue;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.E_GreaterThan;
import org.apache.jena.sparql.expr.E_GreaterThanOrEqual;
import org.apache.jena.sparql.expr.E_LessThan;
import org.apache.jena.sparql.expr.E_LessThanOrEqual;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprLib;

public class RangeUtils {
    public static Expr createExpr(Node node, Range<? extends ComparableNodeValue> range) {
        Expr n = ExprLib.nodeToExpr((Node)node);
        ArrayList<Expr> parts = new ArrayList<Expr>();
        if (org.aksw.commons.util.range.RangeUtils.isSingleton(range)) {
            parts.add((Expr)new E_Equals(n, ExprLib.nodeToExpr((Node)((ComparableNodeValue)range.lowerEndpoint()).getNode())));
        } else {
            if (range.hasLowerBound()) {
                if (range.lowerBoundType().equals((Object)BoundType.OPEN)) {
                    parts.add((Expr)new E_GreaterThan(n, (Expr)((ComparableNodeValue)range.lowerEndpoint()).getNodeValue()));
                } else {
                    parts.add((Expr)new E_GreaterThanOrEqual(n, (Expr)((ComparableNodeValue)range.lowerEndpoint()).getNodeValue()));
                }
            }
            if (range.hasUpperBound()) {
                if (range.upperBoundType().equals((Object)BoundType.OPEN)) {
                    parts.add((Expr)new E_LessThan(n, (Expr)((ComparableNodeValue)range.upperEndpoint()).getNodeValue()));
                } else {
                    parts.add((Expr)new E_LessThanOrEqual(n, (Expr)((ComparableNodeValue)range.upperEndpoint()).getNodeValue()));
                }
            }
        }
        Expr result = ExprUtils.andifyBalanced(parts);
        return result;
    }
}

