/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.rdf.io.lenient;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import org.aksw.jenax.rdf.io.lenient.TokenizerWrapperRecovering;
import org.apache.jena.atlas.io.PeekReader;
import org.apache.jena.atlas.iterator.IteratorWrapper;

public class IteratorRecovering<T>
extends IteratorWrapper<T> {
    protected PeekReader peekReader;
    protected boolean isSlotSet = false;
    protected T slot = null;

    public IteratorRecovering(Iterator<T> iterator, PeekReader peekReader) {
        super(iterator);
        this.peekReader = peekReader;
    }

    public boolean hasNext() {
        boolean result;
        if (this.isSlotSet) {
            result = true;
        } else {
            while (true) {
                try {
                    result = super.hasNext();
                    if (!result) break;
                    this.slot = super.next();
                    this.isSlotSet = true;
                }
                catch (Exception e) {
                    TokenizerWrapperRecovering.tryRecovery(this.peekReader);
                    continue;
                }
                break;
            }
        }
        return result;
    }

    public T next() {
        this.hasNext();
        if (!this.isSlotSet) {
            throw new NoSuchElementException();
        }
        this.isSlotSet = false;
        return this.slot;
    }

    public void forEachRemaining(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        while (this.hasNext()) {
            action.accept(this.next());
        }
    }
}

