/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.template;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.aksw.jenax.arq.util.quad.QuadUtils;
import org.aksw.jenax.arq.util.triple.TripleUtils;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.engine.binding.Binding;

public class TemplateLib2 {
    public static Iterator<Triple> calcTriplesRaw(Triple tuple, Iterator<Binding> bindings) {
        return Iter.iter(bindings).map(binding -> {
            Triple r = Substitute.substitute((Triple)tuple, (Binding)binding);
            return r;
        });
    }

    public static Iterator<Triple> calcTriplesRaw(List<Triple> tuples, Iterator<Binding> bindings) {
        return Iter.iter(bindings).flatMap(binding -> Iter.iter((Collection)tuples).map(tuple -> {
            Triple r = Substitute.substitute((Triple)tuple, (Binding)binding);
            return r;
        }));
    }

    public static Iterator<Triple> calcTriples(Triple tuple, Iterator<Binding> bindings) {
        return Iter.iter(TemplateLib2.calcTriplesRaw(tuple, bindings)).filter(TripleUtils::isValidAsStatement);
    }

    public static Iterator<Triple> calcTriples(List<Triple> tuples, Iterator<Binding> bindings) {
        return Iter.iter(bindings).flatMap(binding -> Iter.iter((Collection)tuples).map(tuple -> {
            Triple r = Substitute.substitute((Triple)tuple, (Binding)binding);
            return r;
        }).filter(TripleUtils::isValidAsStatement));
    }

    public static Iterator<Quad> calcQuadsRaw(Quad tuple, Iterator<Binding> bindings) {
        return Iter.iter(bindings).map(binding -> {
            Quad r = Substitute.substitute((Quad)tuple, (Binding)binding);
            return r;
        });
    }

    public static Iterator<Quad> calcQuadsRaw(List<Quad> tuples, Iterator<Binding> bindings) {
        return Iter.iter(bindings).flatMap(binding -> Iter.iter((Collection)tuples).map(tuple -> {
            Quad r = Substitute.substitute((Quad)tuple, (Binding)binding);
            return r;
        }));
    }

    public static Iterator<Quad> calcQuads(Quad tuple, Iterator<Binding> bindings) {
        return Iter.iter(TemplateLib2.calcQuadsRaw(tuple, bindings)).filter(QuadUtils::isValidAsStatement);
    }

    public static Iterator<Quad> calcQuads(List<Quad> tuples, Iterator<Binding> bindings) {
        return Iter.iter(bindings).flatMap(binding -> Iter.iter((Collection)tuples).map(tuple -> {
            Quad r = Substitute.substitute((Quad)tuple, (Binding)binding);
            return r;
        }).filter(QuadUtils::isValidAsStatement));
    }
}

