/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.syntax;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aksw.commons.collections.generator.Generator;
import org.aksw.commons.util.math.Lehmer;
import org.aksw.jenax.arq.util.node.NodeTransformLib2;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.arq.util.syntax.LehmerHash;
import org.aksw.jenax.arq.util.syntax.QueryUtils;
import org.aksw.jenax.arq.util.syntax.VarExprListUtils;
import org.aksw.jenax.arq.util.var.VarGeneratorImpl2;
import org.aksw.jenax.arq.util.var.VarUtils;
import org.aksw.jenax.util.backport.syntaxtransform.QueryTransformOps;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QueryType;
import org.apache.jena.query.SortCondition;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprVars;
import org.apache.jena.sparql.expr.aggregate.Aggregator;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.graph.NodeTransformLib;
import org.apache.jena.sparql.modify.request.QuadAcc;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.PatternVars;
import org.apache.jena.sparql.syntax.Template;
import org.apache.jena.sparql.syntax.syntaxtransform.NodeTransformSubst;
import org.apache.jena.sparql.util.ExprUtils;
import org.apache.jena.sparql.util.FmtUtils;

public class QueryHash {
    protected Query originalQuery;
    protected Query harmonizedQuery;
    protected HashCode bodyHashCode;
    protected LehmerHash aggHash;
    protected LehmerHash groupByHash;
    protected LehmerHash havingHash;
    protected LehmerHash orderByHash;
    protected LehmerHash projecHash;
    protected LehmerHash defaultGraphHash;
    protected LehmerHash namedGraphHash;
    protected HashCode relabelHash;
    protected HashCode prologueHash;

    public QueryHash(Query originalQuery, Query harmonizedQuery, HashCode bodyHashCode, LehmerHash aggHash, LehmerHash groupByHash, LehmerHash havingHash, LehmerHash orderByHash, LehmerHash projecHash, HashCode relabelHash, LehmerHash defaultGraphHash, LehmerHash namedGraphHash, HashCode prologueHash) {
        this.originalQuery = originalQuery;
        this.harmonizedQuery = harmonizedQuery;
        this.bodyHashCode = bodyHashCode;
        this.aggHash = aggHash;
        this.groupByHash = groupByHash;
        this.havingHash = havingHash;
        this.orderByHash = orderByHash;
        this.projecHash = projecHash;
        this.relabelHash = relabelHash;
        this.defaultGraphHash = defaultGraphHash;
        this.namedGraphHash = namedGraphHash;
        this.prologueHash = prologueHash;
    }

    public Query getOriginalQuery() {
        return this.originalQuery;
    }

    public Query getHarmonizedQuery() {
        return this.harmonizedQuery;
    }

    public HashCode getBodyHashCode() {
        return this.bodyHashCode;
    }

    public LehmerHash getAggHash() {
        return this.aggHash;
    }

    public LehmerHash getGroupByHash() {
        return this.groupByHash;
    }

    public LehmerHash getHavingHash() {
        return this.havingHash;
    }

    public LehmerHash getOrderByHash() {
        return this.orderByHash;
    }

    public LehmerHash getProjecHash() {
        return this.projecHash;
    }

    public HashCode getRelabelHash() {
        return this.relabelHash;
    }

    public LehmerHash getDefaultGraphHash() {
        return this.defaultGraphHash;
    }

    public LehmerHash getNamedGraphHash() {
        return this.namedGraphHash;
    }

    public HashCode getPrologueHash() {
        return this.prologueHash;
    }

    public static Set<Var> getNonAggregateVars(Query query) {
        HashSet<Var> result = new HashSet<Var>();
        VarExprList proj = query.getProject();
        for (Var var : proj.getVars()) {
            Expr expr = proj.getExpr(var);
            boolean containsExprAggregator = expr == null ? false : org.aksw.jenax.arq.util.expr.ExprUtils.containsExprAggregator(expr);
            if (containsExprAggregator) continue;
            result.add(var);
        }
        return result;
    }

    public static void relabelVariables(Query query) {
        Set patternVars = (Set)PatternVars.vars(new LinkedHashSet(), (Element)query.getQueryPattern());
        Set<Object> groupByVars = new LinkedHashSet();
        LinkedHashSet orderByVars = new LinkedHashSet();
        LinkedHashSet havingVars = new LinkedHashSet();
        LinkedHashSet projVars = new LinkedHashSet();
        if (query.hasGroupBy()) {
            groupByVars = VarExprListUtils.getVarsMentioned(query.getGroupBy());
            if (query.hasHaving()) {
                query.getHavingExprs().forEach(e -> ExprVars.varsMentioned((Collection)havingVars, (Expr)e));
            }
        }
        if (query.hasOrderBy()) {
            ExprVars.varsMentioned(orderByVars, (Collection)query.getOrderBy());
        }
        VarExprListUtils.varsMentioned(projVars, query.getProject());
        LinkedHashSet allVars = new LinkedHashSet();
        allVars.addAll(patternVars);
        allVars.addAll(groupByVars);
        allVars.addAll(orderByVars);
        allVars.addAll(havingVars);
        allVars.addAll(projVars);
        LinkedHashMap<Var, Var> relabel = new LinkedHashMap<Var, Var>();
        VarGeneratorImpl2 vargen = VarGeneratorImpl2.create("v");
        for (Var v : allVars) {
            relabel.put(v, (Var)vargen.next());
        }
        Query result = QueryTransformOps.transform(query, relabel);
    }

    public static QueryHash createHash(Query query) {
        HashFunction queryPatternHashFn = Hashing.sha256();
        HashFunction aggHashFn = Hashing.murmur3_32_fixed();
        HashFunction datasetDescriptionHashFn = Hashing.farmHashFingerprint64();
        HashFunction orderByHashFn = Hashing.murmur3_32_fixed();
        HashFunction havingHashFn = Hashing.murmur3_32_fixed();
        HashFunction groupByHashFn = Hashing.murmur3_32_fixed();
        HashFunction projectHashFn = Hashing.murmur3_32_fixed();
        HashFunction varMapHashFn = Hashing.murmur3_32_fixed();
        HashFunction prologueHashFn = Hashing.murmur3_32_fixed();
        LinkedHashMap<Var, Var> relabel = new LinkedHashMap<Var, Var>();
        LinkedHashSet allVars = new LinkedHashSet();
        Query newQuery = new Query();
        newQuery.setQuerySelectType();
        Element queryPattern = query.getQueryPattern();
        if (queryPattern == null) {
            queryPattern = new ElementGroup();
        }
        Set patternVars = (Set)PatternVars.vars(new LinkedHashSet(), (Element)queryPattern);
        VarGeneratorImpl2 patternVarGen = VarGeneratorImpl2.create("v");
        patternVars.forEach(v -> QueryHash.getOrNext(relabel, v, patternVarGen));
        allVars.addAll(patternVars);
        NodeTransformSubst xform = new NodeTransformSubst(relabel);
        Element newQueryPattern = ElementUtils.applyNodeTransform(queryPattern, (NodeTransform)xform);
        newQuery.setQueryPattern(newQueryPattern);
        if (query.hasAggregators()) {
            List aggs = query.getAggregators();
            ArrayList<ExprAggregator> newAggregators = new ArrayList<ExprAggregator>(aggs.size());
            for (ExprAggregator ea : aggs) {
                ExprAggregator newEa = QueryHash.transform(ea, relabel, (Generator<Var>)patternVarGen, aggHashFn);
                newAggregators.add(newEa);
            }
            newQuery.getAggregators().addAll(newAggregators);
        } else {
            List newAggregators = List.of();
        }
        VarGeneratorImpl2 groupByVarGen = VarGeneratorImpl2.create("g");
        VarExprList newGroupBy = QueryHash.transform(query.getGroupBy(), relabel, (Generator<Var>)groupByVarGen, groupByHashFn);
        newQuery.getGroupBy().addAll(newGroupBy);
        VarGeneratorImpl2 havingVarGen = VarGeneratorImpl2.create("h");
        if (query.hasHaving()) {
            List<Expr> newHavingExprs = QueryHash.transform(query.getHavingExprs(), relabel, (Generator<Var>)havingVarGen);
            newHavingExprs.forEach(arg_0 -> ((Query)newQuery).addHavingCondition(arg_0));
        }
        VarGeneratorImpl2 orderByVarGen = VarGeneratorImpl2.create("o");
        if (query.hasOrderBy()) {
            NodeTransform xform2 = QueryHash.nodeTransform(relabel, orderByVarGen);
            List<SortCondition> newOrderBy = query.getOrderBy().stream().map(sc -> NodeTransformLib2.transform(xform2, sc)).collect(Collectors.toList());
            newOrderBy.forEach(arg_0 -> ((Query)newQuery).addOrderBy(arg_0));
        }
        QueryUtils.setQueryType(newQuery, query.queryType());
        DatasetDescription dd = query.getDatasetDescription();
        if (dd != null) {
            dd.getDefaultGraphURIs().forEach(arg_0 -> ((Query)newQuery).addGraphURI(arg_0));
            dd.getNamedGraphURIs().forEach(arg_0 -> ((Query)newQuery).addNamedGraphURI(arg_0));
        } else {
            dd = new DatasetDescription();
        }
        LehmerHash defaultGraphHash = QueryHash.hash(datasetDescriptionHashFn, dd.getDefaultGraphURIs(), Object::toString);
        LehmerHash namedGraphHash = QueryHash.hash(datasetDescriptionHashFn, dd.getNamedGraphURIs(), Object::toString);
        VarGeneratorImpl2 projectVarGen = VarGeneratorImpl2.create("p");
        switch (query.queryType()) {
            case SELECT: {
                newQuery.setQueryResultStar(query.isQueryResultStar());
                if (!query.isQueryResultStar()) {
                    VarExprList newProject = QueryHash.transform(query.getProject(), relabel, (Generator<Var>)projectVarGen, projectHashFn);
                    newQuery.getProject().addAll(newProject);
                }
                newQuery.setDistinct(query.isDistinct());
                newQuery.setReduced(query.isReduced());
                break;
            }
            case CONSTRUCT: {
                Template newTemplate = QueryHash.transform(query.getConstructTemplate(), relabel, (Generator<Var>)projectVarGen);
                newQuery.setConstructTemplate(newTemplate);
                break;
            }
            case ASK: {
                break;
            }
            case DESCRIBE: {
                List<Node> nodes = query.getResultURIs().stream().map(n -> QueryHash.transform(n, (Map<Var, Var>)relabel, (Generator<Var>)projectVarGen)).collect(Collectors.toList());
                nodes.forEach(arg_0 -> ((Query)newQuery).addDescribeNode(arg_0));
                break;
            }
            case CONSTRUCT_JSON: {
                Map<String, Node> newJsonMapping = query.getJsonMapping().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> QueryHash.transform((Node)e.getValue(), (Map<Var, Var>)relabel, (Generator<Var>)projectVarGen)));
                newJsonMapping.forEach((arg_0, arg_1) -> ((Query)newQuery).addJsonMapping(arg_0, arg_1));
                break;
            }
            default: {
                throw new RuntimeException("Unknown query type: " + String.valueOf(query.queryType()));
            }
        }
        HashCode bodyHashCode = queryPatternHashFn.hashString((CharSequence)newQuery.getQueryPattern().toString(), StandardCharsets.UTF_8);
        LehmerHash aggHash = QueryHash.hash(aggHashFn, newQuery.getAggregators(), ExprUtils::fmtSPARQL);
        LehmerHash groupByHash = QueryHash.toHashCode(newQuery.getGroupBy());
        LehmerHash havingHash = QueryHash.hash(havingHashFn, newQuery.getHavingExprs(), ExprUtils::fmtSPARQL);
        LehmerHash orderByHash = QueryHash.hash(orderByHashFn, newQuery.getOrderBy(), QueryHash::fmt);
        LehmerHash projectHash = switch (query.queryType()) {
            case QueryType.SELECT -> QueryHash.toHashCode(newQuery.getProject());
            case QueryType.CONSTRUCT -> QueryHash.hash(projectHashFn, newQuery.getConstructTemplate().getQuads(), FmtUtils::stringForQuad);
            case QueryType.ASK -> LehmerHash.of(HashCode.fromInt((int)0), BigInteger.valueOf(0L));
            case QueryType.DESCRIBE -> QueryHash.hash(projectHashFn, query.getResultURIs(), NodeFmtLib::strTTL);
            case QueryType.CONSTRUCT_JSON -> QueryHash.hash(projectHashFn, query.getJsonMapping().entrySet(), Objects::toString);
            default -> throw new RuntimeException("Unknown query type: " + String.valueOf(query.queryType()));
        };
        HashCode relabelHash = Hashing.combineUnordered((Iterable)relabel.entrySet().stream().map(Objects::toString).map(str -> varMapHashFn.hashString((CharSequence)str, StandardCharsets.UTF_8)).collect(Collectors.toList()));
        newQuery.setLimit(query.getLimit());
        newQuery.setOffset(query.getOffset());
        Prologue prologue = query.getPrologue();
        Set prefixes = prologue.getPrefixMapping().getNsPrefixMap().entrySet();
        HashCode prefixesHash = prefixes.isEmpty() ? HashCode.fromInt((int)0) : Hashing.combineUnordered((Iterable)prefixes.stream().map(Objects::toString).map(str -> prologueHashFn.hashString((CharSequence)str, StandardCharsets.UTF_8)).collect(Collectors.toList()));
        HashCode baseHash = prologue.explicitlySetBaseURI() ? prologueHashFn.hashString((CharSequence)query.getBaseURI(), StandardCharsets.UTF_8) : HashCode.fromInt((int)0);
        HashCode prologueHash = Hashing.combineOrdered(Arrays.asList(baseHash, prefixesHash));
        QueryHash result = new QueryHash(query, newQuery, bodyHashCode, aggHash, groupByHash, havingHash, orderByHash, projectHash, relabelHash, defaultGraphHash, namedGraphHash, prologueHash);
        return result;
    }

    public static String fmt(SortCondition sc) {
        String exprStr = ExprUtils.fmtSPARQL((Expr)sc.getExpression());
        return switch (sc.getDirection()) {
            case 1 -> "ASC(" + exprStr + ")";
            case -1 -> "DESC(" + exprStr + ")";
            default -> exprStr;
        };
    }

    public static List<ExprAggregator> transform(List<ExprAggregator> eas, Map<Var, Var> relabel, Generator<Var> varGen, HashFunction hashFn) {
        VarExprList vel = new VarExprList();
        for (ExprAggregator ea : eas) {
            vel.add(ea.getVar(), (Expr)ea);
        }
        VarExprList newVel = QueryHash.transform(vel, relabel, varGen, hashFn);
        List<ExprAggregator> result = VarExprListUtils.streamVarExprs(newVel).map(e -> {
            ExprAggregator r = new ExprAggregator((Var)e.getKey(), ((ExprAggregator)e.getValue()).getAggregator());
            return r;
        }).collect(Collectors.toList());
        return result;
    }

    public static VarExprList transform(VarExprList vel, Map<Var, Var> relabel, Generator<Var> varGen, HashFunction hashFn) {
        VarExprList result = new VarExprList();
        for (Var v : vel.getVars()) {
            Expr e = vel.getExpr(v);
            Map.Entry<Var, Expr> contrib = QueryHash.transform(v, e, relabel, varGen, hashFn);
            result.add(contrib.getKey(), contrib.getValue());
        }
        return result;
    }

    public static List<Expr> transform(List<Expr> es, Map<Var, Var> relabel, Generator<Var> varGen) {
        return es.stream().map(e -> QueryHash.transform(e, relabel, varGen)).collect(Collectors.toList());
    }

    public static Expr transform(Expr e, Map<Var, Var> relabel, Generator<Var> varGen) {
        LinkedHashSet mentionedVars = new LinkedHashSet();
        ExprVars.varsMentioned(mentionedVars, (Expr)e);
        for (Var mv : mentionedVars) {
            QueryHash.getOrNext(relabel, mv, varGen);
        }
        Expr result = NodeTransformLib.transform((NodeTransform)new NodeTransformSubst(relabel), (Expr)e);
        return result;
    }

    public static Map.Entry<Var, Expr> transform(Var v, Expr e, Map<Var, Var> relabel, Generator<Var> varGen, HashFunction hashFn) {
        Map.Entry<Var, Object> result;
        if (e != null) {
            LinkedHashSet mentionedVars = new LinkedHashSet();
            ExprVars.varsMentioned(mentionedVars, (Expr)e);
            for (Var mv : mentionedVars) {
                QueryHash.getOrNext(relabel, mv, varGen);
            }
            Expr newExpr = NodeTransformLib.transform((NodeTransform)new NodeTransformSubst(relabel), (Expr)e);
            String str = ExprUtils.fmtSPARQL((Expr)newExpr);
            HashCode hashCode = hashFn.hashString((CharSequence)str, StandardCharsets.UTF_8);
            String newVarName = QueryHash.getSpecialPrefix(v) + QueryHash.str(hashCode);
            Var newVar = Var.alloc((String)newVarName);
            relabel.put(v, newVar);
            result = Map.entry(newVar, newExpr);
        } else {
            Var newVar = QueryHash.getOrNext(relabel, v, varGen);
            result = new AbstractMap.SimpleEntry<Var, Object>(newVar, null);
        }
        return result;
    }

    public static Var getOrNext(Map<Var, Var> relabel, Var v, Generator<Var> varGen) {
        Var result = relabel.computeIfAbsent(v, x -> QueryHash.nextVar(x, varGen));
        return result;
    }

    public static Var nextVar(Var baseVar, Generator<Var> varGen) {
        String prefix = QueryHash.getSpecialPrefix(baseVar);
        Var tmp = (Var)varGen.next();
        Var result = prefix.isEmpty() ? tmp : Var.alloc((String)(prefix + tmp.getName()));
        return result;
    }

    public static String getSpecialPrefix(Var var) {
        StringBuilder sb = new StringBuilder();
        String name = var.getName();
        String result = name.codePoints().takeWhile(c -> !VarUtils.isValidFirstCharForVarName(c)).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
        return result;
    }

    public static NodeTransform nodeTransform(Map<Var, Var> relabel, Generator<Var> varGen) {
        return node -> QueryHash.transform(node, relabel, varGen);
    }

    public static Node transform(Node node, Map<Var, Var> relabel, Generator<Var> varGen) {
        Node r = node;
        if (node.isVariable()) {
            Var v = (Var)node;
            r = QueryHash.getOrNext(relabel, v, varGen);
        }
        return r;
    }

    public static Template transform(Template template, Map<Var, Var> relabel, Generator<Var> varGen) {
        NodeTransform xform = node -> QueryHash.transform(node, relabel, varGen);
        List quads = template.getQuads().stream().map(q -> NodeTransformLib.transform((NodeTransform)xform, (Quad)q)).collect(Collectors.toList());
        return new Template(new QuadAcc(quads));
    }

    public static ExprAggregator transform(ExprAggregator ea, Map<Var, Var> relabel, Generator<Var> varGen, HashFunction hashFn) {
        Var newVar;
        LinkedHashSet mentionedVars = new LinkedHashSet();
        ExprList exprList = ea.getAggregator().getExprList();
        ExprList newExprList = null;
        if (exprList != null) {
            ExprVars.varsMentioned(mentionedVars, (ExprList)exprList);
            for (Var mv : mentionedVars) {
                QueryHash.getOrNext(relabel, mv, varGen);
            }
            newExprList = NodeTransformLib.transform((NodeTransform)new NodeTransformSubst(relabel), (ExprList)exprList);
        }
        Aggregator newAgg = ea.getAggregator().copy(newExprList);
        String str = newAgg.asSparqlExpr(FmtUtils.sCxt());
        HashCode hashCode = hashFn.hashString((CharSequence)str, StandardCharsets.UTF_8);
        Var oldVar = ea.getVar();
        String newVarBaseName = QueryHash.getSpecialPrefix(oldVar) + BaseEncoding.base64Url().omitPadding().encode(hashCode.asBytes());
        int i = 0;
        while (true) {
            String newVarName;
            if (!relabel.containsValue(newVar = Var.alloc((String)(newVarName = i == 0 ? newVarBaseName : newVarBaseName + "_" + i)))) break;
            ++i;
        }
        relabel.put(oldVar, newVar);
        ExprAggregator result = new ExprAggregator(newVar, newAgg);
        return result;
    }

    public static LehmerHash toHashCode(VarExprList vel) {
        HashFunction hashFn = Hashing.murmur3_32_fixed();
        List elements = VarExprListUtils.streamVarExprs(vel).map(Object::toString).collect(Collectors.toList());
        return QueryHash.hash(hashFn, elements, Objects::toString);
    }

    public static <T> LehmerHash hash(HashFunction hashFn, Collection<T> elements, Function<T, String> toString) {
        List strs = elements == null ? List.of() : elements.stream().map(toString::apply).collect(Collectors.toList());
        List hashCodes = strs.stream().map(str -> {
            HashCode r = hashFn.hashString((CharSequence)str, StandardCharsets.UTF_8);
            return r;
        }).collect(Collectors.toList());
        HashCode hashCode = hashCodes.isEmpty() ? HashCode.fromInt((int)0) : Hashing.combineUnordered(hashCodes);
        BigInteger lehmerValue = Lehmer.lehmerValue(strs, Comparator.naturalOrder());
        return LehmerHash.of(hashCode, lehmerValue);
    }

    public static String str(HashCode hashCode) {
        return QueryHash.str(hashCode.asBytes());
    }

    public static byte[] trim(byte[] rawBytes) {
        int n = rawBytes.length;
        int i = 0;
        for (i = 0; i < n && rawBytes[i] == 0; ++i) {
        }
        byte[] result = Arrays.copyOfRange(rawBytes, i, n);
        return result;
    }

    public static String str(byte[] rawBytes) {
        byte[] bytes = QueryHash.trim(rawBytes);
        if (bytes.length == 0) {
            bytes = new byte[]{0};
        }
        BaseEncoding encoding = BaseEncoding.base64Url().omitPadding();
        String result = encoding.encode(bytes);
        return result;
    }

    public String str(BigInteger value) {
        return QueryHash.str(value.toByteArray());
    }

    protected String getQueryTypePrefix(QueryType queryType) {
        return Character.toString(queryType.name().charAt(0)).toLowerCase();
    }

    protected String getQueryTypePrefix(Query query) {
        QueryType queryType = query.queryType();
        Object result = this.getQueryTypePrefix(queryType);
        if (QueryType.SELECT.equals((Object)queryType)) {
            String suffix = query.isDistinct() ? "d" : (query.isReduced() ? "r" : "_");
            result = (String)result + "/" + suffix;
        }
        return result;
    }

    public String toString() {
        Query query = this.getHarmonizedQuery();
        Object sliceHash = query.hasOffset() ? "" + query.getOffset() : "";
        sliceHash = (String)sliceHash + (String)(query.hasLimit() ? "+" + query.getLimit() : "");
        String baseHash = QueryHash.str(this.getBodyHashCode()) + "/" + QueryHash.str(this.getGroupByHash().getHash()) + "/" + QueryHash.str(this.getHavingHash().getHash()) + "/" + this.getQueryTypePrefix(this.harmonizedQuery) + "/" + QueryHash.str(this.getProjecHash().getHash()) + "/" + QueryHash.str(this.getOrderByHash().getHash()) + "/" + this.str(this.getGroupByHash().getLehmer()) + "/" + this.str(this.getHavingHash().getLehmer()) + "/" + (String)(!this.harmonizedQuery.isAskType() ? this.str(this.getProjecHash().getLehmer()) + "/" + this.str(this.getOrderByHash().getLehmer()) + "/" : "") + QueryHash.str(this.getRelabelHash()) + QueryHash.str(this.getDefaultGraphHash().getHash()) + "/" + this.str(this.getDefaultGraphHash().getLehmer()) + "/" + QueryHash.str(this.getNamedGraphHash().getHash()) + "/" + this.str(this.getNamedGraphHash().getLehmer()) + "/" + QueryHash.str(this.getPrologueHash());
        return baseHash + (String)(((String)sliceHash).isEmpty() ? "" : "/" + (String)sliceHash);
    }

    public static void main(String[] args) {
        System.out.println(QueryHash.createHash(QueryFactory.create((String)"SELECT ?s COUNT(?p) FROM <http://dbpedia.org/sparql> { ?s ?p ?o } GROUP BY ?s STR(?o) ORDER BY DESC(?s) DESC(STR(?o)) LIMIT 10 OFFSET 2")));
        System.out.println(QueryHash.createHash(QueryFactory.create((String)"SELECT COUNT(?y) ?x FROM <http://dbpedia.org/sparql> FROM NAMED <urn:foo> { ?x ?y ?z } GROUP BY ?x STR(?z) ORDER BY DESC(STR(?z)) DESC(?x) LIMIT 10 OFFSET 2")));
        System.out.println(QueryHash.createHash(QueryFactory.create((String)"SELECT ?a COUNT(?b) FROM <http://dbpedia.org/sparql> FROM NAMED <urn:foo> { ?a ?b ?c } GROUP BY STR(?c) ?a ORDER BY DESC(?a) DESC(STR(?c)) LIMIT 10 OFFSET 2")));
        System.out.println(QueryHash.createHash(QueryFactory.create((String)"SELECT DISTINCT ?s COUNT(?p) FROM <http://dbpedia.org/sparql> { ?s ?p ?o } GROUP BY ?s STR(?o) ORDER BY DESC(?s) DESC(STR(?o)) LIMIT 10 OFFSET 2")));
        System.out.println(QueryHash.createHash(QueryFactory.create((String)"SELECT ?s (COUNT(?p) AS ?count) FROM <http://dbpedia.org/sparql> { ?s ?p ?o } GROUP BY ?s STR(?o) ORDER BY DESC(?s) DESC(STR(?o)) LIMIT 10 OFFSET 2")));
        System.out.println(QueryHash.createHash(QueryFactory.create((String)"SELECT (COUNT(?y) AS ?count) ?x FROM <http://dbpedia.org/sparql> FROM NAMED <urn:foo> { ?x ?y ?z } GROUP BY ?x STR(?z) ORDER BY DESC(STR(?z)) DESC(?x) LIMIT 10 OFFSET 2")));
        System.out.println(QueryHash.createHash(QueryFactory.create((String)"SELECT ?a (COUNT(?b) AS ?count) FROM <http://dbpedia.org/sparql> FROM NAMED <urn:foo> { ?a ?b ?c } GROUP BY STR(?c) ?a ORDER BY DESC(?a) DESC(STR(?c)) LIMIT 10 OFFSET 2")));
        System.out.println(QueryHash.createHash(QueryFactory.create((String)"PREFIX eg: <http://www.example.org> SELECT ?a (COUNT(?b) AS ?count) FROM <http://dbpedia.org/sparql> FROM NAMED <urn:foo> { ?a ?b ?c } GROUP BY STR(?c) ?a ORDER BY DESC(?a) DESC(STR(?c)) LIMIT 10 OFFSET 2")));
    }
}

