/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.syntax;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aksw.commons.collections.MapUtils;
import org.aksw.jenax.arq.util.expr.CnfUtils;
import org.aksw.jenax.arq.util.node.NodeTransformCollectNodes;
import org.aksw.jenax.arq.util.node.NodeTransformRenameMap;
import org.aksw.jenax.arq.util.syntax.ElementTransformSubst2;
import org.aksw.jenax.arq.util.syntax.ElementVisitorDatasetGraph;
import org.aksw.jenax.arq.util.syntax.ElementVisitorGetSubElements;
import org.aksw.jenax.arq.util.syntax.ElementVisitorGraph;
import org.aksw.jenax.arq.util.triple.TripleUtils;
import org.aksw.jenax.arq.util.var.VarGeneratorBlacklist;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.util.backport.syntaxtransform.ElementTransformer;
import org.aksw.jenax.util.backport.syntaxtransform.ExprTransformNodeElement;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpAsQuery;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementBind;
import org.apache.jena.sparql.syntax.ElementData;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementNamedGraph;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.ElementUnion;
import org.apache.jena.sparql.syntax.ElementVisitor;
import org.apache.jena.sparql.syntax.ElementWalker;
import org.apache.jena.sparql.syntax.PatternVars;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransform;

public class ElementUtils {
    public static ElementData create(Table table) {
        return new ElementData(table.getVars(), Iter.toList((Iterator)table.rows()));
    }

    public static List<Element> getSubElements(Element element) {
        return ElementVisitorGetSubElements.getSubElements(element);
    }

    public static Element applyOpTransform(Element elt, Function<? super Op, ? extends Op> transform) {
        Op beforeOp = Algebra.compile((Element)elt);
        Op afterOp = transform.apply((Op)beforeOp);
        Query query = OpAsQuery.asQuery((Op)afterOp);
        Element r = query.getQueryPattern();
        return r;
    }

    public static Set<Var> getVarsMentioned(Element e) {
        NodeTransformCollectNodes tmp = new NodeTransformCollectNodes();
        ElementUtils.applyNodeTransform(e, tmp);
        Set<Node> nodes = tmp.getNodes();
        Set<Var> result = nodes.stream().filter(Node::isVariable).map(n -> (Var)n).collect(Collectors.toSet());
        return result;
    }

    public static ElementTriplesBlock createElementTriple(Triple ... triples) {
        return ElementUtils.createElementTriple(Arrays.asList(triples));
    }

    public static ElementTriplesBlock createElementTriple(Iterable<Triple> triples) {
        BasicPattern bgp = new BasicPattern();
        triples.forEach(arg_0 -> ((BasicPattern)bgp).add(arg_0));
        ElementTriplesBlock result = new ElementTriplesBlock(bgp);
        return result;
    }

    public static ElementTriplesBlock createElementTriple(Node s, Node p, Node o) {
        return ElementUtils.createElement(Triple.create((Node)s, (Node)p, (Node)o));
    }

    public static ElementTriplesBlock createElementTriple(Node s, Node p, Node o, boolean isForward) {
        return ElementUtils.createElement(TripleUtils.create(s, p, o, isForward));
    }

    public static ElementPathBlock createElementPath(Node s, Path p, Node o) {
        ElementPathBlock result = ElementUtils.createElementPath(new TriplePath(s, p, o));
        return result;
    }

    public static ElementPathBlock createElementPath(TriplePath ... tps) {
        ElementPathBlock result = ElementUtils.createElementPath(Arrays.asList(tps));
        return result;
    }

    public static ElementPathBlock createElementPath(Iterable<TriplePath> it) {
        ElementPathBlock result = new ElementPathBlock();
        for (TriplePath tp : it) {
            result.addTriple(tp);
        }
        return result;
    }

    public static ElementTriplesBlock createElement(Triple triple) {
        BasicPattern bgp = new BasicPattern();
        bgp.add(triple);
        ElementTriplesBlock result = new ElementTriplesBlock(bgp);
        return result;
    }

    public static Element createElement(Quad quad) {
        ElementTriplesBlock tripleEl = ElementUtils.createElement(quad.asTriple());
        ElementTriplesBlock result = Quad.isDefaultGraph((Node)quad.getGraph()) ? tripleEl : new ElementNamedGraph(quad.getGraph(), (Element)tripleEl);
        return result;
    }

    public static ElementPathBlock createElement(TriplePath triplePath) {
        ElementPathBlock result = new ElementPathBlock();
        result.addTriplePath(triplePath);
        return result;
    }

    public static List<Triple> extractTriples(Element e) {
        ArrayList<Triple> result = new ArrayList<Triple>();
        ElementUtils.extractTriples(e, result);
        return result;
    }

    public static Triple extractTriple(Element e) {
        Triple result = null;
        if (e instanceof ElementFilter) {
            ElementFilter x = (ElementFilter)e;
            Expr expr = x.getExpr();
            Set<Set<Expr>> cnf = CnfUtils.toSetCnf(expr);
            Map<Var, Node> map = CnfUtils.getConstants(cnf, true);
            Node s = (Node)MapUtils.getOrElse(map, (Object)Vars.s, (Object)Node.ANY);
            Node p = (Node)MapUtils.getOrElse(map, (Object)Vars.p, (Object)Node.ANY);
            Node o = (Node)MapUtils.getOrElse(map, (Object)Vars.o, (Object)Node.ANY);
            result = Triple.create((Node)s, (Node)p, (Node)o);
        } else {
            List<Triple> triples = ElementUtils.extractTriples(e);
            if (triples.size() == 1) {
                result = triples.get(0);
            }
        }
        return result;
    }

    @Deprecated
    public static void extractTriples(Element e, List<Triple> result) {
        if (e instanceof ElementGroup) {
            ElementGroup g = (ElementGroup)e;
            for (Element item : g.getElements()) {
                ElementUtils.extractTriples(item, result);
            }
        } else if (e instanceof ElementTriplesBlock) {
            ElementTriplesBlock b = (ElementTriplesBlock)e;
            List triples = b.getPattern().getList();
            result.addAll(triples);
        }
    }

    public static DatasetGraph toDataset(Element elt) {
        return ElementUtils.toDataset(elt, DatasetGraphFactory.create());
    }

    public static <T extends DatasetGraph> T toDataset(Element elt, T acc) {
        ElementVisitorDatasetGraph visitor = new ElementVisitorDatasetGraph(acc);
        ElementWalker.walk((Element)elt, (ElementVisitor)visitor);
        return acc;
    }

    public static Graph toGraph(Element elt) {
        return ElementUtils.toGraph(elt, GraphFactory.createDefaultGraph());
    }

    public static <T extends Graph> T toGraph(Element elt, T acc) {
        ElementVisitorGraph visitor = new ElementVisitorGraph(acc);
        ElementWalker.walk((Element)elt, (ElementVisitor)visitor);
        return acc;
    }

    public static Map<Node, Var> createMapFixVarNames(Element element) {
        Collection vars = PatternVars.vars((Element)element);
        Map<Node, Var> result = ElementUtils.createMapFixVarNames(vars);
        return result;
    }

    public static Map<Node, Var> createMapFixVarNames(Collection<Var> vars) {
        VarGeneratorBlacklist gen = VarGeneratorBlacklist.create("v", vars);
        HashMap<Node, Var> result = new HashMap<Node, Var>();
        for (Var var : vars) {
            if (!var.getName().startsWith("?") && !var.getName().startsWith("/")) continue;
            result.put((Node)var, (Var)gen.next());
        }
        return result;
    }

    public static Element fixVarNames(Element element) {
        Map<Node, Var> nodeMap = ElementUtils.createMapFixVarNames(element);
        NodeTransformRenameMap nodeTransform = NodeTransformRenameMap.create(nodeMap);
        Element result = ElementUtils.applyNodeTransform(element, nodeTransform);
        return result;
    }

    public static Element toElement(Collection<Element> elements) {
        Element result;
        if (elements.size() == 1) {
            result = elements.iterator().next();
        } else {
            ElementGroup e = new ElementGroup();
            for (Element element : elements) {
                e.addElement(element);
            }
            result = e;
        }
        return result;
    }

    public static Element unionIfNeeded(Element ... elements) {
        Element result = ElementUtils.unionIfNeeded(Arrays.asList(elements));
        return result;
    }

    public static Element unionIfNeeded(Collection<Element> elements) {
        Element result;
        if (elements.size() == 1) {
            result = elements.iterator().next();
        } else {
            ElementUnion e = new ElementUnion();
            for (Element element : elements) {
                e.addElement(element);
            }
            result = e;
        }
        return result;
    }

    public static Element groupIfNeeded(Iterable<? extends Element> members) {
        ElementGroup result = Iterables.size(members) == 1 ? members.iterator().next() : ElementUtils.createElementGroup(members);
        return result;
    }

    public static Element groupIfNeeded(Element ... members) {
        Element result = ElementUtils.groupIfNeeded(Arrays.asList(members));
        return result;
    }

    public static ElementGroup createElementGroup(Iterable<? extends Element> members) {
        ElementGroup result = new ElementGroup();
        for (Element element : members) {
            result.addElement(element);
        }
        return result;
    }

    public static ElementGroup createElementGroup(Element ... members) {
        ElementGroup result = new ElementGroup();
        for (Element member : members) {
            result.addElement(member);
        }
        return result;
    }

    public static Element createRenamedElement(Element element, Map<?, ? extends Node> nodeMap) {
        NodeTransformRenameMap nodeTransform = NodeTransformRenameMap.create(nodeMap);
        Element result = ElementUtils.applyNodeTransform(element, nodeTransform);
        return result;
    }

    public static Element applyNodeTransform(Element element, NodeTransform nodeTransform) {
        return ElementUtils.applyNodeTransformBackport(element, nodeTransform);
    }

    public static Element applyNodeTransformJena(Element element, NodeTransform nodeTransform) {
        ElementTransformSubst2 elementTransform = new ElementTransformSubst2(nodeTransform);
        org.apache.jena.sparql.syntax.syntaxtransform.ExprTransformNodeElement exprTransform = new org.apache.jena.sparql.syntax.syntaxtransform.ExprTransformNodeElement(nodeTransform, (ElementTransform)elementTransform);
        Element result = org.apache.jena.sparql.syntax.syntaxtransform.ElementTransformer.transform((Element)element, (ElementTransform)elementTransform, (ExprTransform)exprTransform);
        return result;
    }

    @Deprecated
    public static Element applyNodeTransformBackport(Element element, NodeTransform nodeTransform) {
        ElementTransformSubst2 elementTransform = new ElementTransformSubst2(nodeTransform);
        ExprTransformNodeElement exprTransform = new ExprTransformNodeElement(nodeTransform, (ElementTransform)elementTransform);
        Element result = ElementTransformer.transform(element, (ElementTransform)elementTransform, (ExprTransform)exprTransform);
        return result;
    }

    public static ElementGroup copyElements(ElementGroup target, Element source) {
        if (source instanceof ElementGroup) {
            ElementGroup es = (ElementGroup)source;
            for (Element e : es.getElements()) {
                target.addElement(e);
            }
        } else {
            target.addElement(source);
        }
        return target;
    }

    public static void mergeElements(ElementGroup target, ElementTriplesBlock etb, Element source) {
        if (source instanceof ElementTriplesBlock) {
            ElementTriplesBlock e = (ElementTriplesBlock)source;
            for (Triple t : e.getPattern()) {
                etb.addTriple(t);
            }
        } else if (source instanceof ElementGroup) {
            ElementGroup es = (ElementGroup)source;
            for (Element e : es.getElements()) {
                ElementUtils.mergeElements(target, etb, e);
            }
        } else {
            target.addElement(source);
        }
    }

    public static Element mergeElements(Element first, Element second) {
        ElementGroup tmp = new ElementGroup();
        ElementTriplesBlock etb = new ElementTriplesBlock();
        tmp.addElement((Element)etb);
        ElementUtils.mergeElements(tmp, etb, first);
        ElementUtils.mergeElements(tmp, etb, second);
        ArrayList<Element> els = new ArrayList<Element>();
        for (Element e : tmp.getElements()) {
            if (e instanceof ElementTriplesBlock && ((ElementTriplesBlock)e).isEmpty()) continue;
            els.add(e);
        }
        Element result = ElementUtils.groupIfNeeded(els);
        return result;
    }

    public static Element unionElements(Element first, Element second) {
        ElementUnion result = new ElementUnion();
        ElementUtils.addUnionElements(result, first);
        ElementUtils.addUnionElements(result, second);
        return result;
    }

    public static void addUnionElements(ElementUnion out, Element e) {
        if (e instanceof ElementUnion) {
            ElementUnion u = (ElementUnion)e;
            for (Element m : u.getElements()) {
                out.addElement(m);
            }
        } else if (!(e instanceof ElementGroup) || !((ElementGroup)e).isEmpty()) {
            out.addElement(e);
        }
    }

    public static List<Element> toElementList(Element element) {
        List<Element> result = element instanceof ElementGroup ? ((ElementGroup)element).getElements() : Arrays.asList(element);
        result = new ArrayList<Element>(result);
        return result;
    }

    public static Element flatten(Element e) {
        ElementGroup tmp;
        List els;
        Object result = e instanceof ElementGroup ? ((els = (tmp = (ElementGroup)e).getElements()).size() == 1 ? (Element)els.get(0) : tmp) : e;
        return result;
    }

    public static Element flatMerge(Element ... elts) {
        return ElementUtils.flatMerge(Arrays.asList(elts));
    }

    public static Element flatMerge(Iterable<Element> elts) {
        Element result = ElementUtils.groupIfNeeded(ElementUtils.flatMergeList(elts));
        return result;
    }

    public static List<Element> flatMergeList(Element ... elts) {
        return ElementUtils.flatMergeList(Arrays.asList(elts));
    }

    public static List<Element> flatMergeList(Iterable<? extends Element> elts) {
        ArrayList<Element> result = new ArrayList<Element>();
        for (Element element : elts) {
            if (element == null) continue;
            List<Element> contrib = ElementUtils.toElementList(element);
            result.addAll(contrib);
        }
        return result;
    }

    public static ElementData createElementData(Collection<Var> vars, Collection<Binding> rows) {
        ElementData result = new ElementData();
        vars.forEach(arg_0 -> ((ElementData)result).add(arg_0));
        rows.forEach(arg_0 -> ((ElementData)result).add(arg_0));
        return result;
    }

    public static ElementGroup addBinding(ElementGroup group, Binding binding) {
        if (binding != null) {
            binding.forEach((v, n) -> group.addElement((Element)new ElementBind(v, (Expr)NodeValue.makeNode((Node)n))));
        }
        return group;
    }
}

