/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.syntax;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.aksw.jenax.arq.util.quad.QuadUtils;
import org.aksw.jenax.arq.util.triple.TripleUtils;
import org.aksw.jenax.arq.util.var.VarGeneratorImpl2;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.graph.NodeTransformLib;
import org.apache.jena.sparql.syntax.syntaxtransform.NodeTransformSubst;

public class CanonicalRdf {
    public static List<Quad> canonicalizeQuads(List<Quad> quads) {
        List<Var> mentionedVars = quads.stream().map(QuadUtils::getVarsMentioned).flatMap(Collection::stream).distinct().toList();
        Map<Var, Var> relabel = CanonicalRdf.createRelabelMap(mentionedVars);
        NodeTransformSubst nodeTransform = new NodeTransformSubst(relabel);
        List<Quad> result = quads.stream().map(arg_0 -> CanonicalRdf.lambda$canonicalizeQuads$0((NodeTransform)nodeTransform, arg_0)).toList();
        return result;
    }

    public static List<Triple> canonicalizeTriples(List<Triple> triples) {
        List<Var> mentionedVars = triples.stream().map(TripleUtils::getVarsMentioned).flatMap(Collection::stream).distinct().toList();
        Map<Var, Var> relabel = CanonicalRdf.createRelabelMap(mentionedVars);
        NodeTransformSubst nodeTransform = new NodeTransformSubst(relabel);
        List<Triple> result = triples.stream().map(arg_0 -> CanonicalRdf.lambda$canonicalizeTriples$1((NodeTransform)nodeTransform, arg_0)).toList();
        return result;
    }

    public static Triple canonicalize(Triple t) {
        Set<Var> mentionedVars = TripleUtils.getVarsMentioned(t);
        Map<Var, Var> relabel = CanonicalRdf.createRelabelMap(mentionedVars);
        NodeTransformSubst nodeTransform = new NodeTransformSubst(relabel);
        Triple result = NodeTransformLib.transform((NodeTransform)nodeTransform, (Triple)t);
        return result;
    }

    public static Map<Var, Var> createRelabelMap(Collection<Var> mentionedVars) {
        VarGeneratorImpl2 vargen = VarGeneratorImpl2.create("v");
        Map<Var, Var> relabel = mentionedVars.stream().collect(Collectors.toMap(v -> v, v -> (Var)vargen.next()));
        return relabel;
    }

    private static /* synthetic */ Triple lambda$canonicalizeTriples$1(NodeTransform nodeTransform, Triple quad) {
        return NodeTransformLib.transform((NodeTransform)nodeTransform, (Triple)quad);
    }

    private static /* synthetic */ Quad lambda$canonicalizeQuads$0(NodeTransform nodeTransform, Quad quad) {
        return NodeTransformLib.transform((NodeTransform)nodeTransform, (Quad)quad);
    }
}

