/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.streamrdf;

import java.io.OutputStream;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.aksw.jenax.arq.util.streamrdf.StreamRDFUtils;
import org.aksw.jenax.arq.util.streamrdf.WriterStreamRDFBaseUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.irix.IRIx;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.out.NodeToLabel;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFOps;
import org.apache.jena.riot.system.StreamRDFWrapper;
import org.apache.jena.riot.system.StreamRDFWriter;
import org.apache.jena.riot.system.SyntaxLabels;
import org.apache.jena.riot.writer.WriterStreamRDFBase;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.Context;

public class StreamRDFWriterEx {
    public static StreamRDF getWriterStream(OutputStream out, RDFFormat rdfFormat, Context context) {
        return StreamRDFWriterEx.getWriterStream(out, rdfFormat, context, null, null, null, null);
    }

    public static StreamRDF getWriterStream(OutputStream out, Lang lang, Context context) {
        StreamRDF rawWriter = StreamRDFWriter.getWriterStream((OutputStream)out, (Lang)lang, (Context)context);
        StreamRDF result = StreamRDFWriterEx.enhanceWriterAsGiven(rawWriter, lang);
        return result;
    }

    public static void writeAsGiven(DatasetGraph dg, OutputStream out, RDFFormat format, Context cxt, Function<StreamRDF, StreamRDF> applyWrapper) {
        StreamRDFWriterEx.writeAsGiven(dg, StreamRDFOps::sendDatasetToStream, out, format, cxt, applyWrapper);
    }

    public static void writeAsGiven(Graph graph, OutputStream out, RDFFormat format, Context cxt, Function<StreamRDF, StreamRDF> applyWrapper) {
        StreamRDFWriterEx.writeAsGiven(graph, StreamRDFOps::sendGraphToStream, out, format, cxt, applyWrapper);
    }

    public static <T> void writeAsGiven(T data, BiConsumer<T, StreamRDF> sendToStream, OutputStream out, RDFFormat format, Context cxt, Function<StreamRDF, StreamRDF> applyWrapper) {
        StreamRDF streamRdf = StreamRDFWriterEx.getWriterStream(out, format, cxt);
        if (applyWrapper != null) {
            streamRdf = applyWrapper.apply(streamRdf);
        }
        streamRdf.start();
        sendToStream.accept(data, streamRdf);
        streamRdf.finish();
    }

    public static StreamRDF getWriterStream(OutputStream out, RDFFormat rdfFormat, Context context, PrefixMapping fixedPrefixes, IRIx irix, NodeToLabel nodeToLabel, Boolean mapQuadsToTriplesForTripleLangs) {
        StreamRDF rawWriter = StreamRDFWriter.getWriterStream((OutputStream)out, (RDFFormat)rdfFormat, (Context)context);
        Lang lang = rdfFormat.getLang();
        StreamRDF result = StreamRDFWriterEx.enhanceWriter(rawWriter, lang, fixedPrefixes, irix, nodeToLabel, mapQuadsToTriplesForTripleLangs);
        return result;
    }

    public static StreamRDF enhanceWriterAsGiven(StreamRDF rawWriter, Lang lang) {
        StreamRDF result = StreamRDFWriterEx.enhanceWriter(rawWriter, lang, null, null, null, true);
        return result;
    }

    public static StreamRDF enhanceWriter(StreamRDF rawWriter, Lang lang, PrefixMapping fixedPrefixes, IRIx irix, NodeToLabel nodeToLabel, Boolean mapQuadsToTriplesForTripleLangs) {
        StreamRDF coreWriter = StreamRDFUtils.unwrap(rawWriter);
        if (coreWriter instanceof WriterStreamRDFBase) {
            WriterStreamRDFBase tmp = (WriterStreamRDFBase)coreWriter;
            IRIx effectiveIrix = irix == null ? IRIx.create((String)"") : irix;
            NodeToLabel effectiveNodeToLabel = nodeToLabel == null ? SyntaxLabels.createNodeToLabelAsGiven() : nodeToLabel;
            WriterStreamRDFBaseUtils.setNodeToLabel(tmp, effectiveNodeToLabel);
            WriterStreamRDFBaseUtils.updateFormatter(tmp);
            WriterStreamRDFBaseUtils.setNodeFormatterIRIx(tmp, effectiveIrix);
            if (fixedPrefixes != null) {
                PrefixMap pm = WriterStreamRDFBaseUtils.getPrefixMap(tmp);
                for (Map.Entry e : fixedPrefixes.getNsPrefixMap().entrySet()) {
                    pm.add((String)e.getKey(), (String)e.getValue());
                }
                rawWriter = StreamRDFUtils.wrapWithoutPrefixDelegation(rawWriter);
            }
        }
        if (Boolean.TRUE.equals(mapQuadsToTriplesForTripleLangs) && RDFLanguages.isTriples((Lang)lang)) {
            rawWriter = new StreamRDFWrapper((StreamRDF)rawWriter){

                public void quad(Quad quad) {
                    super.triple(quad.asTriple());
                }
            };
        }
        return rawWriter;
    }
}

