/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.security;

import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;

public class ArqSecurity {
    public static final Symbol symAllowFileAccess = SystemARQ.allocSymbol((String)"allowFileAccess");

    public static boolean isFileAccessEnabled(Context cxt) {
        Context effectiveCxt = cxt == null ? ARQ.getContext() : cxt;
        boolean result = effectiveCxt.isTrue(symAllowFileAccess);
        return result;
    }

    public static void requireFileAccess(Context cxt) {
        if (!ArqSecurity.isFileAccessEnabled(cxt)) {
            throw new SecurityException("Access to files is disallowed");
        }
    }
}

