/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.expr;

import java.util.Arrays;
import org.aksw.jenax.arq.util.exec.query.ExecutionContextUtils;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.expr.E_Function;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.Function;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.function.FunctionFactory;
import org.apache.jena.sparql.function.FunctionRegistry;

public class FunctionUtils {
    public static Node invokeWithNodes(String iri, Node ... nodes) {
        Node result = FunctionUtils.invokeWithNodes(FunctionRegistry.get(), iri, nodes);
        return result;
    }

    public static Node invokeWithNodes(FunctionRegistry registry, String iri, Node ... nodes) {
        FunctionFactory ff = registry.get(iri);
        Function fn = ff.create(iri);
        Node result = FunctionUtils.invokeWithNodes(fn, iri, nodes);
        return result;
    }

    public static Node invokeWithNodes(Function fn, Node ... nodes) {
        return FunctionUtils.invokeWithNodes(fn, null, nodes);
    }

    public static Node invokeWithNodes(Function fn, Iterable<Node> nodes) {
        return FunctionUtils.invokeWithNodes(fn, null, nodes);
    }

    public static Node invokeWithNodes(Function fn, String iri, Node ... nodes) {
        return FunctionUtils.invokeWithNodes(fn, iri, Arrays.asList(nodes));
    }

    public static Node invokeWithNodes(Function fn, String iri, Iterable<Node> nodes) {
        BindingBuilder bb = BindingFactory.builder();
        ExprList args = new ExprList();
        int i = 0;
        for (Node n : nodes) {
            Var v = Var.alloc((String)("arg" + i));
            args.add((Expr)new ExprVar(v));
            bb.add(v, n);
            ++i;
        }
        Binding b = bb.build();
        ExecutionContext env = ExecutionContextUtils.createFunctionEnv();
        NodeValue nv = null;
        try {
            nv = fn.exec(b, args, iri, (FunctionEnv)env);
        }
        catch (DatatypeFormatException | ExprEvalException throwable) {
            // empty catch block
        }
        Node result = nv == null ? null : nv.asNode();
        return result;
    }

    public static void runWithDisabledWarnOnUnknownFunction(Runnable action) {
        boolean storedValue = E_Function.WarnOnUnknownFunction;
        try {
            E_Function.WarnOnUnknownFunction = false;
            action.run();
        }
        finally {
            E_Function.WarnOnUnknownFunction = storedValue;
        }
    }
}

