/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.exec.query;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aksw.commons.collections.IteratorUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.util.ExprUtils;
import org.apache.jena.sparql.util.QueryExecUtils;

public class QueryExecSimple {
    protected PrefixMapping prefixMapping;

    protected QueryExecSimple(PrefixMapping prefixMapping) {
        this.prefixMapping = prefixMapping;
    }

    public static QueryExecSimple create(PrefixMapping prefixMapping) {
        return new QueryExecSimple(prefixMapping);
    }

    public String evalExprToLexicalForm(String exprStr) {
        Node node = this.evalExprToNode(exprStr);
        String result = node == null ? null : node.getLiteralLexicalForm();
        return result;
    }

    public Node evalExprToNode(String exprStr) {
        Expr expr = ExprUtils.parse((String)exprStr, (PrefixMapping)this.prefixMapping);
        NodeValue nv = ExprUtils.eval((Expr)expr);
        Node result = nv.asNode();
        return result;
    }

    public Node evalQueryToNode(String queryStr) {
        Query query = new Query();
        query.getPrefixMapping().setNsPrefixes(this.prefixMapping);
        QueryFactory.parse((Query)query, (String)queryStr, null, (Syntax)Syntax.syntaxARQ);
        RDFNode rdfNode = QueryExecUtils.getExactlyOne((String)query.toString(), (Dataset)DatasetFactory.empty());
        Node result = rdfNode == null ? null : rdfNode.asNode();
        return result;
    }

    public Binding evalQueryToBinding(String queryStr) {
        Query query = new Query();
        query.getPrefixMapping().setNsPrefixes(this.prefixMapping);
        QueryFactory.parse((Query)query, (String)queryStr, null, (Syntax)Syntax.syntaxARQ);
        Binding result = null;
        try (QueryExecution qe = QueryExecutionFactory.create((Query)query, (Dataset)DatasetFactory.empty());){
            RowSet rs = RowSet.adapt((ResultSet)qe.execSelect());
            result = (Binding)IteratorUtils.expectZeroOrOneItems((Iterator)rs);
        }
        return result;
    }

    public List<Node> evalQueryToNodes(String queryStr) {
        Query query = new Query();
        query.getPrefixMapping().setNsPrefixes(this.prefixMapping);
        QueryFactory.parse((Query)query, (String)queryStr, null, (Syntax)Syntax.syntaxARQ);
        Var resultVar = (Var)Iterables.getOnlyElement((Iterable)query.getProjectVars());
        ArrayList<Node> result = new ArrayList<Node>();
        try (QueryExecution qe = QueryExecutionFactory.create((Query)query, (Dataset)DatasetFactory.empty());){
            RowSet.adapt((ResultSet)qe.execSelect()).forEachRemaining(b -> result.add(b.get(resultVar)));
        }
        return result;
    }

    public String evalQueryToLexicalForm(String queryStr) {
        Node node = this.evalQueryToNode(queryStr);
        String result = node == null ? null : (node.isLiteral() ? node.getLiteralLexicalForm() : node.toString());
        return result;
    }
}

