/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.syntax;

import com.google.common.collect.Streams;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementData;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransformCopyBase;

public class ElementTransformSubst2
extends ElementTransformCopyBase {
    private final NodeTransform nodeTransform;

    public ElementTransformSubst2(NodeTransform nodeTransform) {
        this.nodeTransform = nodeTransform;
    }

    public Element transform(ElementTriplesBlock el) {
        ElementTriplesBlock etb = new ElementTriplesBlock();
        boolean changed = false;
        for (Triple t : el.getPattern()) {
            Triple t2 = this.transform(t);
            changed = changed || t != t2;
            etb.addTriple(t2);
        }
        if (changed) {
            return etb;
        }
        return el;
    }

    public Element transform(ElementPathBlock el) {
        ElementPathBlock epb = new ElementPathBlock();
        boolean changed = false;
        for (TriplePath p : el.getPattern()) {
            TriplePath p2 = this.transform(p);
            changed = changed || p != p2;
            epb.addTriplePath(p2);
        }
        if (changed) {
            return epb;
        }
        return el;
    }

    private TriplePath transform(TriplePath path) {
        Node s = path.getSubject();
        Node s1 = this.transform(s);
        Node o = path.getObject();
        Node o1 = this.transform(o);
        if (path.isTriple()) {
            Node p = path.getPredicate();
            Node p1 = this.transform(p);
            if (s == s1 && p == p1 && o == o1) {
                return path;
            }
            return new TriplePath(Triple.create((Node)s1, (Node)p1, (Node)o1));
        }
        if (s == s1 && o == o1) {
            return path;
        }
        return new TriplePath(s1, path.getPath(), o1);
    }

    public Triple transform(Triple triple) {
        Node s = triple.getSubject();
        Node s1 = this.transform(s);
        Node p = triple.getPredicate();
        Node p1 = this.transform(p);
        Node o = triple.getObject();
        Node o1 = this.transform(o);
        if (s == s1 && p == p1 && o == o1) {
            return triple;
        }
        return Triple.create((Node)s1, (Node)p1, (Node)o1);
    }

    protected Node transform(Node n) {
        return (Node)this.nodeTransform.apply((Object)n);
    }

    public static ElementData transform(ElementData el, NodeTransform nodeTransform) {
        Table inTable = el.getTable();
        ElementData result = new ElementData();
        inTable.getVars().stream().map(nodeTransform).map(v -> (Var)v).forEach(arg_0 -> ((ElementData)result).add(arg_0));
        Streams.stream((Iterator)inTable.rows()).map(b -> ElementTransformSubst2.transform(b, nodeTransform)).forEach(arg_0 -> ((ElementData)result).add(arg_0));
        return result;
    }

    public static Binding transform(Binding b, NodeTransform transform) {
        BindingBuilder b2 = BindingBuilder.create();
        List vars = Iter.toList((Iterator)b.vars());
        for (Var v : vars) {
            Node n = b.get(v);
            Var v2 = (Var)transform.apply((Object)v);
            Node n2 = (Node)transform.apply((Object)n);
            b2.add(v2, n2);
        }
        return b2.build();
    }

    public Element transform(ElementData el) {
        ElementData result = ElementTransformSubst2.transform(el, this.nodeTransform);
        return result;
    }
}

