/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.expr;

import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.common.graph.Traverser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.aksw.jenax.arq.util.expr.ClauseUtils;
import org.aksw.jenax.arq.util.expr.ExprUtils;
import org.aksw.jenax.arq.util.expr.FilterUtils;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_Coalesce;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.E_LogicalAnd;
import org.apache.jena.sparql.expr.E_LogicalNot;
import org.apache.jena.sparql.expr.E_LogicalOr;
import org.apache.jena.sparql.expr.E_NotEquals;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprFunction;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;

public class DnfUtils {
    public static Set<Var> fixedVars(Expr expr) {
        Set<Set<Expr>> clauses = DnfUtils.toSetDnf(expr);
        Set<Var> fixedVars = null;
        for (Set<Expr> clause : clauses) {
            Set<Var> fixedVarsOfClause = DnfUtils.fixedVarsClause(clause);
            if (fixedVars == null) {
                fixedVars = fixedVarsOfClause;
                continue;
            }
            fixedVars.retainAll(fixedVarsOfClause);
        }
        if (fixedVars == null) {
            fixedVars = Collections.emptySet();
        }
        return fixedVars;
    }

    public static Set<Var> fixedVarsClause(Iterable<? extends Expr> clause) {
        LinkedHashSet<Var> fixedVars = new LinkedHashSet<Var>();
        LinkedHashSet nonFixedVars = new LinkedHashSet();
        for (Expr expr : clause) {
            Set varsMentioned = expr.getVarsMentioned();
            boolean containsCoalesceOrNotBound = Streams.stream((Iterable)Traverser.forTree(ExprUtils::getSubExprs).depthFirstPreOrder((Object)expr)).anyMatch(x -> x instanceof E_Coalesce || ExprUtils.getIsNotBoundArg(x) != null);
            if (containsCoalesceOrNotBound) {
                nonFixedVars.addAll(varsMentioned);
                continue;
            }
            fixedVars.addAll(varsMentioned);
        }
        fixedVars.removeAll(nonFixedVars);
        return fixedVars;
    }

    public static Expr toExpr(Iterable<? extends Iterable<Expr>> ors) {
        ArrayList<Expr> tmpOrs = new ArrayList<Expr>();
        for (Iterable<Expr> iterable : ors) {
            Expr and = ExprUtils.andifyBalanced(iterable);
            if (and == null) {
                and = NodeValue.TRUE;
            }
            tmpOrs.add(and);
        }
        if (Iterables.isEmpty(tmpOrs)) {
            return NodeValue.FALSE;
        }
        Expr result = ExprUtils.orifyBalanced(tmpOrs);
        return result;
    }

    public static void addConstantConstraint(Map<Var, NodeValue> map, Map.Entry<Var, NodeValue> constraint) {
        if (constraint == null) {
            return;
        }
        DnfUtils.addConstantConstraint(map, constraint.getKey(), constraint.getValue());
    }

    public static void addConstantConstraint(Map<Var, NodeValue> map, Var var, NodeValue nodeValue) {
        if (map.containsKey(var)) {
            NodeValue oldValue = map.get(var);
            if (oldValue != null && !oldValue.equals((Object)nodeValue)) {
                map.put(var, null);
            }
        } else {
            map.put(var, nodeValue);
        }
    }

    public static Set<Map<Var, NodeValue>> extractConstantConstraints(Collection<? extends Collection<? extends Expr>> dnf) {
        dnf = dnf == null ? Collections.emptySet() : dnf;
        HashSet<Map<Var, NodeValue>> result = new HashSet<Map<Var, NodeValue>>(dnf.size());
        for (Collection<? extends Expr> collection : dnf) {
            Map<Var, NodeValue> map = ClauseUtils.extractConstantConstraints(collection);
            result.add(map);
        }
        return result;
    }

    public static Map<Var, NodeValue> extractCommonConstantConstraints(Set<Set<Expr>> dnf) {
        HashMap<Var, NodeValue> result = new HashMap<Var, NodeValue>();
        Iterator<Set<Expr>> clauseIt = dnf.iterator();
        if (!clauseIt.hasNext()) {
            return result;
        }
        Set<Expr> firstClause = clauseIt.next();
        for (Expr expr : firstClause) {
            Map.Entry<Var, NodeValue> constraint = ExprUtils.extractConstantConstraint(expr);
            DnfUtils.addConstantConstraint(result, constraint);
        }
        HashSet<Var> seenVars = new HashSet<Var>();
        while (clauseIt.hasNext()) {
            if (result.isEmpty()) {
                return result;
            }
            Set<Expr> clause = clauseIt.next();
            for (Expr expr : clause) {
                Map.Entry<Var, NodeValue> constraint = ExprUtils.extractConstantConstraint(expr);
                if (constraint == null || !result.containsKey(constraint.getKey())) continue;
                DnfUtils.addConstantConstraint(result, constraint);
                seenVars.add(constraint.getKey());
            }
            result.keySet().retainAll(seenVars);
            seenVars.clear();
        }
        return result;
    }

    public static Set<Set<Expr>> toSetDnf(Expr expr) {
        Set<Set<Expr>> result = DnfUtils.toSetDnf(expr, false);
        return result;
    }

    public static Set<Set<Expr>> toSetDnf(Expr expr, boolean allowEmptyClauseInsteadOfNull) {
        List<ExprList> clauses = DnfUtils.toClauses(expr);
        Set<Set<Object>> dnf = FilterUtils.toSets(clauses);
        if (dnf == null && allowEmptyClauseInsteadOfNull) {
            dnf = Collections.singleton(Collections.emptySet());
        }
        return dnf;
    }

    public static Set<Set<Expr>> toSetDnf(ExprList exprs) {
        List<ExprList> clauses = DnfUtils.toClauses(exprs);
        Set<Set<Expr>> dnf = FilterUtils.toSets(clauses);
        return dnf;
    }

    public static List<List<Expr>> toListDnf(ExprList exprs) {
        List result = DnfUtils.toClauses(exprs).stream().map(el -> new ArrayList(el.getList())).collect(Collectors.toCollection(ArrayList::new));
        return result;
    }

    public static boolean isSatisfiable(Set<Set<Expr>> dnf) {
        for (Set<Expr> clause : dnf) {
            if (!ClauseUtils.isSatisfiable(clause)) continue;
            return true;
        }
        return false;
    }

    public static Expr dnfToExpr(Set<Set<Expr>> dnf, boolean skipUnsatisfiable) {
        HashSet<Expr> exprs = new HashSet<Expr>();
        for (Set<Expr> clause : dnf) {
            if (clause.size() > 1 && clause.contains(NodeValue.TRUE)) {
                clause.remove(NodeValue.TRUE);
            }
            if (skipUnsatisfiable && !ClauseUtils.isSatisfiable(clause)) continue;
            exprs.add(ExprUtils.andifyBalanced(clause));
        }
        Expr result = ExprUtils.orifyBalanced(exprs);
        return result != null ? result : NodeValue.FALSE;
    }

    public static Expr andifyLeftSided(ExprList exprs) {
        Expr result = null;
        for (Expr expr : exprs.getList()) {
            result = result == null ? expr : new E_LogicalAnd(result, expr);
        }
        return result;
    }

    public static List<ExprList> toClauses(Expr expr) {
        Expr evaluated = DnfUtils.eval(expr);
        return evaluated == null ? null : DnfUtils.dnfToClauses(Collections.singleton(evaluated));
    }

    public static List<ExprList> toClauses(ExprList exprs) {
        Expr evaluated = DnfUtils.eval(ExprUtils.andifyBalanced((Iterable<Expr>)exprs));
        return evaluated == null ? null : DnfUtils.dnfToClauses(Collections.singleton(evaluated));
    }

    public static List<ExprList> dnfToClauses(Iterable<Expr> exprs) {
        ArrayList<ExprList> result = new ArrayList<ExprList>();
        for (Expr expr : exprs) {
            DnfUtils.collectOr(expr, result);
        }
        return result;
    }

    public static void collectAnd(Expr expr, ExprList list) {
        if (expr instanceof E_LogicalAnd) {
            E_LogicalAnd e = (E_LogicalAnd)expr;
            DnfUtils.collectAnd(e.getArg1(), list);
            DnfUtils.collectAnd(e.getArg2(), list);
        } else {
            list.add(expr);
        }
    }

    public static void collectOr(Expr expr, List<ExprList> list) {
        if (expr instanceof E_LogicalOr) {
            E_LogicalOr e = (E_LogicalOr)expr;
            DnfUtils.collectOr(e.getArg1(), list);
            DnfUtils.collectOr(e.getArg2(), list);
        } else if (expr instanceof E_LogicalAnd) {
            ExprList ors = new ExprList();
            DnfUtils.collectAnd(expr, ors);
            list.add(ors);
        } else {
            ExprList tmp = new ExprList();
            if (!NodeValue.TRUE.equals((Object)expr)) {
                tmp.add(expr);
            }
            list.add(tmp);
        }
    }

    public static ExprList eval(ExprList exprs) {
        ExprList result = new ExprList();
        for (Expr expr : exprs) {
            result.add(DnfUtils.eval(expr));
        }
        return result;
    }

    public static Expr eval(Expr expr) {
        if (expr instanceof ExprFunction) {
            return DnfUtils.handle((ExprFunction)expr);
        }
        return expr;
    }

    public static boolean containsDirectFuncChild(Expr expr, Class<?> clazz) {
        if (!(expr instanceof ExprFunction)) {
            return false;
        }
        ExprFunction func = (ExprFunction)expr;
        for (Expr arg : func.getArgs()) {
            if (arg == null || !clazz.isAssignableFrom(arg.getClass())) continue;
            return true;
        }
        return false;
    }

    public static Expr handle(ExprFunction expr) {
        if (expr instanceof E_LogicalNot) {
            Expr tmp = ((E_LogicalNot)expr).getArg();
            if (!(tmp instanceof ExprFunction)) {
                return expr;
            }
            ExprFunction child = (ExprFunction)tmp;
            ExprFunction newExpr = expr;
            if (child instanceof E_LogicalAnd) {
                newExpr = new E_LogicalOr(DnfUtils.eval((Expr)new E_LogicalNot(child.getArg(1))), DnfUtils.eval((Expr)new E_LogicalNot(child.getArg(2))));
            } else if (child instanceof E_LogicalOr) {
                newExpr = new E_LogicalAnd(DnfUtils.eval((Expr)new E_LogicalNot(child.getArg(1))), DnfUtils.eval((Expr)new E_LogicalNot(child.getArg(2))));
            } else if (child instanceof E_LogicalNot) {
                newExpr = DnfUtils.eval(child.getArg(1));
            } else {
                return expr;
            }
            return DnfUtils.eval((Expr)newExpr);
        }
        if (expr instanceof E_LogicalOr) {
            return new E_LogicalOr(DnfUtils.eval(expr.getArg(1)), DnfUtils.eval(expr.getArg(2)));
        }
        if (expr instanceof E_LogicalAnd) {
            Expr aa = DnfUtils.eval(expr.getArg(1));
            Expr bb = DnfUtils.eval(expr.getArg(2));
            E_LogicalOr a = null;
            Expr b = null;
            if (aa instanceof E_LogicalOr) {
                a = (E_LogicalOr)aa;
                b = bb;
            } else if (bb instanceof E_LogicalOr) {
                a = (E_LogicalOr)bb;
                b = aa;
            }
            if (a == null) {
                return new E_LogicalAnd(aa, bb);
            }
            return new E_LogicalOr(DnfUtils.eval((Expr)new E_LogicalAnd(a.getArg(1), b)), DnfUtils.eval((Expr)new E_LogicalAnd(a.getArg(2), b)));
        }
        if (expr instanceof E_NotEquals) {
            return new E_LogicalNot(DnfUtils.eval((Expr)new E_Equals(expr.getArg(1), expr.getArg(2))));
        }
        return expr;
    }
}

