/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.tuple.resultset;

import java.util.function.Supplier;
import java.util.stream.Stream;
import org.aksw.commons.tuple.bridge.TupleBridge;
import org.aksw.jenax.arq.util.tuple.resultset.ResultStreamer;
import org.apache.jena.atlas.lib.tuple.Tuple;

public class ResultStreamerFromTuple<D, C>
implements ResultStreamer<D, C, Tuple<C>> {
    protected int tupleDimension;
    protected Supplier<Stream<Tuple<C>>> tupleStreamer;
    protected TupleBridge<D, C> domainAccessor;

    public ResultStreamerFromTuple(int tupleDimension, Supplier<Stream<Tuple<C>>> tupleStreamer, TupleBridge<D, C> domainAccessor) {
        this.tupleDimension = tupleDimension;
        this.tupleStreamer = tupleStreamer;
        this.domainAccessor = domainAccessor;
    }

    @Override
    public Stream<D> streamAsDomainObject() {
        int domainDimension = this.domainAccessor.getDimension();
        if (domainDimension != this.tupleDimension) {
            throw new UnsupportedOperationException("Tuple dimension " + this.tupleDimension + " does not match domain dimension " + domainDimension);
        }
        return this.streamAsTuple().map(tuple -> this.domainAccessor.build(tuple, Tuple::get));
    }

    @Override
    public Stream<C> streamAsComponent() {
        if (this.tupleDimension != 1) {
            throw new UnsupportedOperationException("Cannot stream domain objects with dimension != 1 as a component");
        }
        return this.streamAsTuple().map(tuple -> tuple.get(0));
    }

    @Override
    public Stream<Tuple<C>> streamAsTuple() {
        return this.tupleStreamer.get();
    }

    @Override
    public ResultStreamer.BackingType getBackingType() {
        return ResultStreamer.BackingType.TUPLE;
    }
}

