/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.syntax;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.aksw.commons.collections.generator.Generator;
import org.aksw.jenax.arq.util.var.VarGeneratorBlacklist;
import org.aksw.jenax.util.backport.syntaxtransform.ElementTransformer;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpAsQuery;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.E_LogicalOr;
import org.apache.jena.sparql.expr.E_OneOf;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprLib;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprTransformCopy;
import org.apache.jena.sparql.expr.ExprTransformSubstitute;
import org.apache.jena.sparql.expr.ExprTransformer;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.XSDFuncOp;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementNamedGraph;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.ElementVisitor;
import org.apache.jena.sparql.syntax.ElementVisitorBase;
import org.apache.jena.sparql.syntax.PatternVars;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransform;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransformCopyBase;
import org.apache.jena.sparql.util.ExprUtils;

public class ElementTransformDatasetDescription
extends ElementTransformCopyBase {
    protected ExprList defaultGraphExprs;
    protected ExprList namedGraphExprs;
    protected Stack<Node> graphs;
    protected Generator<Var> varGen;

    public ElementTransformDatasetDescription(Stack<Node> graphs, Generator<Var> varGen, ExprList defaultGraphExprs, ExprList namedGraphExprs) {
        this.graphs = graphs;
        this.varGen = varGen;
        this.defaultGraphExprs = defaultGraphExprs;
        this.namedGraphExprs = namedGraphExprs;
    }

    public static ExprList toExprs(Collection<String> iris, Map<String, Expr> graphToExpr) {
        ExprList result = new ExprList();
        for (String iri : iris) {
            Expr expr;
            Expr expr2 = expr = graphToExpr == null ? null : graphToExpr.get(iri);
            if (expr == null) {
                expr = ExprLib.nodeToExpr((Node)NodeFactory.createURI((String)iri));
            }
            result.add(expr);
        }
        return result;
    }

    public static ElementTransformDatasetDescription create(Stack<Node> graphs, Element e, DatasetDescription dd, Map<String, Expr> graphToExpr) {
        Collection vars = PatternVars.vars((Element)e);
        VarGeneratorBlacklist varGen = VarGeneratorBlacklist.create("__dg_", vars);
        ExprList defaultGraphExprs = ElementTransformDatasetDescription.toExprs(dd.getDefaultGraphURIs(), graphToExpr);
        ExprList namedGraphExprs = ElementTransformDatasetDescription.toExprs(dd.getNamedGraphURIs(), graphToExpr);
        ElementTransformDatasetDescription result = new ElementTransformDatasetDescription(graphs, varGen, defaultGraphExprs, namedGraphExprs);
        return result;
    }

    public Element transform(ElementTriplesBlock el) {
        Element result = this.applyDefaultGraphs((Element)el);
        return result;
    }

    public Element transform(ElementPathBlock el) {
        Element result = this.applyDefaultGraphs((Element)el);
        return result;
    }

    public Element applyDefaultGraphs(Element el) {
        Element result = null;
        if (this.graphs.isEmpty() && !this.defaultGraphExprs.isEmpty()) {
            Expr expr;
            if (this.defaultGraphExprs.size() == 1 && (expr = (Expr)this.defaultGraphExprs.iterator().next()).isConstant() && !expr.getConstant().isBoolean()) {
                result = ElementTransformDatasetDescription.applyGraphs(this.varGen, expr.getConstant().asNode(), el, ExprList.emptyList);
            }
            if (result == null) {
                Var v = (Var)this.varGen.next();
                result = ElementTransformDatasetDescription.applyGraphs(this.varGen, (Node)v, el, this.defaultGraphExprs);
            }
        } else {
            result = el;
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Expr buildFilterExpr(Expr base, ExprList conditions) {
        NodeValue result = null;
        NodeValue disjunction = null;
        ExprList oneOfBatch = new ExprList();
        List exprs = conditions.getList();
        int n = exprs.size();
        boolean falseSeen = false;
        for (int i = 0; i < n; ++i) {
            Expr expr = (Expr)exprs.get(i);
            NodeValue constant = null;
            if (!expr.isConstant()) {
                Binding b;
                NodeValue evaled;
                Var var;
                Set vars = expr.getVarsMentioned();
                int vs = vars.size();
                if (vs > 1) throw new IllegalStateException("Expressions may only make use of at most one variables - encountered: " + String.valueOf(expr));
                if (!oneOfBatch.isEmpty()) {
                    E_Equals contrib = oneOfBatch.size() == 1 ? new E_Equals(base, oneOfBatch.get(0)) : new E_OneOf(base, oneOfBatch);
                    disjunction = disjunction == null ? contrib : new E_LogicalOr((Expr)disjunction, (Expr)contrib);
                    oneOfBatch = new ExprList();
                }
                Var var2 = var = vs == 1 ? (Var)vars.iterator().next() : null;
                if (base.isConstant() && (evaled = ExprLib.evalOrNull((Expr)expr, (Binding)(b = var == null ? BindingFactory.empty() : BindingFactory.binding((Var)var, (Node)base.getConstant().asNode())), null)) != null) {
                    if (var == null) {
                        constant = evaled.getConstant();
                    } else {
                        NodeValue value = evaled.getConstant();
                        boolean isTrue = XSDFuncOp.booleanEffectiveValue((NodeValue)value);
                        if (isTrue) {
                            result = NodeValue.TRUE;
                            break;
                        }
                        falseSeen = true;
                    }
                }
                if (constant == null) {
                    Expr contrib = ExprTransformer.transform((ExprTransform)new ExprTransformSubstitute(var, base), (Expr)expr);
                    disjunction = disjunction == null ? contrib : new E_LogicalOr((Expr)disjunction, contrib);
                }
            } else {
                constant = expr.getConstant();
            }
            if (constant == null) continue;
            if (constant.isBoolean()) {
                if (constant.getBoolean()) {
                    result = NodeValue.TRUE;
                    break;
                }
                falseSeen = true;
                continue;
            }
            if (base.isConstant()) {
                if (base.equals((Object)constant)) {
                    result = NodeValue.TRUE;
                    break;
                }
                falseSeen = true;
                continue;
            }
            oneOfBatch.add((Expr)constant);
        }
        if (result != null) return result;
        if (!oneOfBatch.isEmpty()) {
            E_Equals contrib = oneOfBatch.size() == 1 ? new E_Equals(base, oneOfBatch.get(0)) : new E_OneOf(base, oneOfBatch);
            disjunction = disjunction == null ? contrib : new E_LogicalOr((Expr)disjunction, (Expr)contrib);
        }
        if (disjunction != null) return disjunction;
        return NodeValue.booleanReturn((!falseSeen ? 1 : 0) != 0);
    }

    public static Element applyGraphs(Generator<Var> varGen, Node gn, Element elt1, ExprList exprs) {
        ElementNamedGraph result;
        if (!exprs.isEmpty()) {
            ExprList tmp;
            NodeValue ge;
            Node gv;
            if (gn.isURI() || gn.isLiteral()) {
                gv = gn;
                ge = NodeValue.makeNode((Node)gn);
                tmp = exprs;
            } else if (gn.isVariable()) {
                gv = (Var)gn;
                ge = new ExprVar(gv);
                tmp = exprs;
            } else if (gn.isBlank()) {
                gv = (Node)varGen.next();
                ge = new ExprVar(gv);
                tmp = exprs;
            } else {
                throw new RuntimeException("Unexpected case");
            }
            ElementNamedGraph el = new ElementNamedGraph(gv, elt1);
            Expr filterExpr = ElementTransformDatasetDescription.buildFilterExpr((Expr)ge, tmp);
            if (NodeValue.TRUE.equals((Object)filterExpr)) {
                result = el;
            } else {
                ElementFilter filter = new ElementFilter(filterExpr);
                ElementGroup group = new ElementGroup();
                group.addElement((Element)el);
                group.addElement((Element)filter);
                result = group;
            }
        } else {
            result = new ElementNamedGraph(gn, elt1);
        }
        return result;
    }

    public Element transform(ElementNamedGraph el, Node gn, Element elt1) {
        Element result = ElementTransformDatasetDescription.applyGraphs(this.varGen, gn, elt1, this.namedGraphExprs);
        return result;
    }

    public static Query rewrite(Query query) {
        return ElementTransformDatasetDescription.rewrite(query, null);
    }

    public static Query rewrite(Query query, Map<String, Expr> graphToExpr) {
        Query result;
        DatasetDescription dd = query.getDatasetDescription();
        if (dd != null) {
            result = query.cloneQuery();
            boolean usesResultStar = result.isQueryResultStar();
            ArrayList beforeRewriteVars = null;
            if (usesResultStar) {
                beforeRewriteVars = new ArrayList(result.getProjectVars());
            }
            Element before = result.getQueryPattern();
            Element after = ElementTransformDatasetDescription.rewrite(before, dd, graphToExpr);
            result.setQueryPattern(after);
            result.getGraphURIs().clear();
            result.getNamedGraphURIs().clear();
            if (usesResultStar) {
                result.setQueryResultStar(true);
                List afterRewriteVars = result.getProjectVars();
                if (!beforeRewriteVars.equals(afterRewriteVars)) {
                    result.setQueryResultStar(false);
                    result.getProject().clear();
                    result.addProjectVars(beforeRewriteVars);
                }
            }
        } else {
            result = query;
        }
        return result;
    }

    public static Element rewrite(Element element, DatasetDescription dd, Map<String, Expr> graphToExpr) {
        final Stack<Node> graphs = new Stack<Node>();
        ExprTransformCopy exprTransform = new ExprTransformCopy();
        ElementTransformDatasetDescription elementTransform = ElementTransformDatasetDescription.create(graphs, element, dd, graphToExpr);
        ElementVisitorBase beforeVisitor = new ElementVisitorBase(){

            public void visit(ElementNamedGraph el) {
                graphs.push(el.getGraphNameNode());
            }
        };
        ElementVisitorBase afterVisitor = new ElementVisitorBase(){

            public void visit(ElementNamedGraph el) {
                graphs.pop();
            }
        };
        Element result = ElementTransformer.transform(element, (ElementTransform)elementTransform, (ExprTransform)exprTransform, (ElementVisitor)beforeVisitor, (ElementVisitor)afterVisitor);
        return result;
    }

    public static void main(String[] args) {
        Query query = QueryFactory.create((String)"SELECT * { { ?s ?p ?o . Graph ?x { ?a ?b ?c } } Union { Graph <urn:example:cng> { ?s ?p ?o } } }");
        query.addGraphURI("dg1");
        query.addGraphURI("dg2");
        query.addNamedGraphURI("ng1");
        query.addNamedGraphURI("ng2");
        HashMap<String, Expr> remap = new HashMap<String, Expr>();
        remap.put("dg1", ExprUtils.parse((String)"true"));
        Query tmp = ElementTransformDatasetDescription.rewrite(query, remap);
        Op op = Algebra.compile((Query)tmp);
        tmp = OpAsQuery.asQuery((Op)op);
        System.out.println(tmp);
    }
}

