/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.quad;

import com.google.common.collect.Iterables;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import org.aksw.jenax.arq.util.triple.SetFromGraph;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;

public class SetFromDatasetGraph
extends AbstractSet<Quad> {
    private DatasetGraph datasetGraph;

    public SetFromDatasetGraph(DatasetGraph graph) {
        this.datasetGraph = graph;
    }

    public DatasetGraph getDatasetGraph() {
        return this.datasetGraph;
    }

    @Override
    public boolean add(Quad quad) {
        boolean result = this.contains(quad);
        this.datasetGraph.add(quad);
        return result;
    }

    @Override
    public boolean contains(Object item) {
        Graph defaultGraph;
        Quad quad;
        boolean result = item instanceof Quad ? (Quad.isDefaultGraph((Node)(quad = (Quad)item).getGraph()) ? ((defaultGraph = this.datasetGraph.getDefaultGraph()) == null ? false : defaultGraph.contains(quad.asTriple())) : this.datasetGraph.contains(quad)) : false;
        return result;
    }

    public static int size(DatasetGraph datasetGraph) {
        int result = 0;
        Graph defaultGraph = datasetGraph.getDefaultGraph();
        result += defaultGraph == null ? 0 : datasetGraph.getDefaultGraph().size();
        Iterator it = datasetGraph.listGraphNodes();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            Graph g = datasetGraph.getGraph(node);
            result += g == null ? 0 : g.size();
        }
        return result;
    }

    public static Iterable<Quad> quads(DatasetGraph datasetGraph) {
        Graph defaultGraph = datasetGraph.getDefaultGraph();
        SetFromGraph triples = defaultGraph == null ? Collections.emptySet() : SetFromGraph.wrap(defaultGraph);
        Iterable quads = () -> datasetGraph.find(Node.ANY, Node.ANY, Node.ANY, Node.ANY);
        Iterable result = Iterables.concat((Iterable)Iterables.transform((Iterable)triples, t -> new Quad(Quad.defaultGraphIRI, t)), quads);
        return result;
    }

    @Override
    public Iterator<Quad> iterator() {
        Iterable<Quad> it = SetFromDatasetGraph.quads(this.datasetGraph);
        return it.iterator();
    }

    @Override
    public int size() {
        int result = SetFromDatasetGraph.size(this.datasetGraph);
        return result;
    }

    public static SetFromDatasetGraph wrap(DatasetGraph graph) {
        SetFromDatasetGraph result = new SetFromDatasetGraph(graph);
        return result;
    }
}

